/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.dev.failsafe.spi;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public final class ExecutionResult<R> {
    private static final CompletableFuture<?> NULL_FUTURE = CompletableFuture.completedFuture(null);
    private static final ExecutionResult<?> NONE = new ExecutionResult<Object>(null, null, true, 0L, true, true, true);
    private final R result;
    private final Throwable exception;
    private final boolean nonResult;
    private final long delayNanos;
    private final boolean complete;
    private final boolean success;
    private final Boolean successAll;

    public ExecutionResult(R result, Throwable exception) {
        this(result, exception, false, 0L, true, exception == null, exception == null);
    }

    private ExecutionResult(R result, Throwable exception, boolean nonResult, long delayNanos, boolean complete, boolean success, Boolean successAll) {
        this.nonResult = nonResult;
        this.result = result;
        this.exception = exception;
        this.delayNanos = delayNanos;
        this.complete = complete;
        this.success = success;
        this.successAll = successAll;
    }

    public static <R> CompletableFuture<ExecutionResult<R>> nullFuture() {
        return NULL_FUTURE;
    }

    public static <R> ExecutionResult<R> success(R result) {
        return new ExecutionResult<R>(result, null, false, 0L, true, true, true);
    }

    public static <R> ExecutionResult<R> exception(Throwable exception) {
        return new ExecutionResult<Object>(null, exception, false, 0L, true, false, false);
    }

    public static <R> ExecutionResult<R> none() {
        return NONE;
    }

    public R getResult() {
        return this.result;
    }

    public Throwable getException() {
        return this.exception;
    }

    public long getDelay() {
        return this.delayNanos;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isNonResult() {
        return this.nonResult;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public ExecutionResult<R> withNonResult() {
        return this.success && this.result == null && this.nonResult ? this : new ExecutionResult<Object>(null, null, true, this.delayNanos, true, true, this.successAll);
    }

    public ExecutionResult<R> withResult(R result) {
        boolean unchangedNull = this.result == null && result == null && this.exception == null;
        boolean unchangedNotNull = this.result != null && this.result.equals(result);
        return this.success && (unchangedNull || unchangedNotNull) ? this : new ExecutionResult<R>(result, null, this.nonResult, this.delayNanos, true, true, this.successAll);
    }

    public ExecutionResult<R> withNotComplete() {
        return !this.complete ? this : new ExecutionResult<R>(this.result, this.exception, this.nonResult, this.delayNanos, false, this.success, this.successAll);
    }

    public ExecutionResult<R> withException() {
        return !this.success ? this : new ExecutionResult<R>(this.result, this.exception, this.nonResult, this.delayNanos, this.complete, false, false);
    }

    public ExecutionResult<R> withSuccess() {
        return this.complete && this.success ? this : new ExecutionResult<R>(this.result, this.exception, this.nonResult, this.delayNanos, true, true, this.successAll);
    }

    public ExecutionResult<R> withDelay(long delayNanos) {
        return this.delayNanos == delayNanos ? this : new ExecutionResult<R>(this.result, this.exception, this.nonResult, delayNanos, this.complete, this.success, this.successAll);
    }

    public ExecutionResult<R> with(long delayNanos, boolean complete, boolean success) {
        return this.delayNanos == delayNanos && this.complete == complete && this.success == success ? this : new ExecutionResult<R>(this.result, this.exception, this.nonResult, delayNanos, complete, success, this.successAll == null ? success : success && this.successAll != false);
    }

    public boolean getSuccessAll() {
        return this.successAll != null && this.successAll != false;
    }

    public String toString() {
        return "[result=" + this.result + ", exception=" + this.exception + ", nonResult=" + this.nonResult + ", delayNanos=" + this.delayNanos + ", complete=" + this.complete + ", success=" + this.success + ", successAll=" + this.successAll + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionResult that = (ExecutionResult)o;
        return Objects.equals(this.result, that.result) && Objects.equals(this.exception, that.exception);
    }

    public int hashCode() {
        return Objects.hash(this.result, this.exception);
    }
}

