/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.xml.processing.sax;

import java.io.IOException;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.ProcessingFeature;
import org.apache.nifi.xml.processing.sax.InputSourceParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class StandardInputSourceParser
implements InputSourceParser {
    private boolean namespaceAware;

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    @Override
    public void parse(InputSource inputSource, ContentHandler contentHandler) {
        Objects.requireNonNull(inputSource, "InputSource required");
        Objects.requireNonNull(contentHandler, "ContentHandler required");
        try {
            this.parseInputSource(inputSource, contentHandler);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new ProcessingException("Parsing failed", e);
        }
    }

    private void parseInputSource(InputSource inputSource, ContentHandler contentHandler) throws ParserConfigurationException, SAXException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(this.namespaceAware);
        saxParserFactory.setXIncludeAware(false);
        saxParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", ProcessingFeature.SECURE_PROCESSING.isEnabled());
        saxParserFactory.setFeature(ProcessingFeature.DISALLOW_DOCTYPE_DECL.getFeature(), ProcessingFeature.DISALLOW_DOCTYPE_DECL.isEnabled());
        if (this.namespaceAware) {
            saxParserFactory.setFeature(ProcessingFeature.SAX_NAMESPACES.getFeature(), ProcessingFeature.SAX_NAMESPACES.isEnabled());
            saxParserFactory.setFeature(ProcessingFeature.SAX_NAMESPACE_PREFIXES.getFeature(), ProcessingFeature.SAX_NAMESPACE_PREFIXES.isEnabled());
        }
        SAXParser parser = saxParserFactory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        reader.setContentHandler(contentHandler);
        try {
            reader.parse(inputSource);
        }
        catch (IOException e) {
            throw new ProcessingException("Parsing failed", e);
        }
    }
}

