/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.detection;

import com.google.cloud.opentelemetry.detection.DetectedPlatform;
import com.google.cloud.opentelemetry.detection.EnvironmentVariables;
import com.google.cloud.opentelemetry.detection.GCPMetadataConfig;
import com.google.cloud.opentelemetry.detection.GoogleAppEngine;
import com.google.cloud.opentelemetry.detection.GoogleCloudFunction;
import com.google.cloud.opentelemetry.detection.GoogleCloudRun;
import com.google.cloud.opentelemetry.detection.GoogleCloudRunJob;
import com.google.cloud.opentelemetry.detection.GoogleComputeEngine;
import com.google.cloud.opentelemetry.detection.GoogleKubernetesEngine;
import com.google.cloud.opentelemetry.detection.UnknownPlatform;

public class GCPPlatformDetector {
    public static final GCPPlatformDetector DEFAULT_INSTANCE = new GCPPlatformDetector();
    private final GCPMetadataConfig metadataConfig;
    private final EnvironmentVariables environmentVariables;

    GCPPlatformDetector(GCPMetadataConfig metadataConfig, EnvironmentVariables environmentVariables) {
        this.metadataConfig = metadataConfig;
        this.environmentVariables = environmentVariables;
    }

    private GCPPlatformDetector() {
        this.metadataConfig = GCPMetadataConfig.DEFAULT_INSTANCE;
        this.environmentVariables = EnvironmentVariables.DEFAULT_INSTANCE;
    }

    public DetectedPlatform detectPlatform() {
        return this.generateDetectedPlatform(this.detectSupportedPlatform());
    }

    private SupportedPlatform detectSupportedPlatform() {
        if (!this.isRunningOnGcp()) {
            return SupportedPlatform.UNKNOWN_PLATFORM;
        }
        if (this.environmentVariables.get("KUBERNETES_SERVICE_HOST") != null) {
            return SupportedPlatform.GOOGLE_KUBERNETES_ENGINE;
        }
        if (this.environmentVariables.get("K_CONFIGURATION") != null && this.environmentVariables.get("FUNCTION_TARGET") == null) {
            return SupportedPlatform.GOOGLE_CLOUD_RUN;
        }
        if (this.environmentVariables.get("FUNCTION_TARGET") != null) {
            return SupportedPlatform.GOOGLE_CLOUD_FUNCTIONS;
        }
        if (this.environmentVariables.get("CLOUD_RUN_JOB") != null) {
            return SupportedPlatform.GOOGLE_CLOUD_RUN_JOB;
        }
        if (this.environmentVariables.get("GAE_SERVICE") != null) {
            return SupportedPlatform.GOOGLE_APP_ENGINE;
        }
        return SupportedPlatform.GOOGLE_COMPUTE_ENGINE;
    }

    private boolean isRunningOnGcp() {
        return this.metadataConfig.getProjectId() != null && !this.metadataConfig.getProjectId().isEmpty();
    }

    private DetectedPlatform generateDetectedPlatform(SupportedPlatform platform) {
        DetectedPlatform detectedPlatform;
        switch (platform) {
            case GOOGLE_KUBERNETES_ENGINE: {
                detectedPlatform = new GoogleKubernetesEngine(this.metadataConfig);
                break;
            }
            case GOOGLE_CLOUD_RUN: {
                detectedPlatform = new GoogleCloudRun(this.environmentVariables, this.metadataConfig);
                break;
            }
            case GOOGLE_CLOUD_FUNCTIONS: {
                detectedPlatform = new GoogleCloudFunction(this.environmentVariables, this.metadataConfig);
                break;
            }
            case GOOGLE_CLOUD_RUN_JOB: {
                detectedPlatform = new GoogleCloudRunJob(this.environmentVariables, this.metadataConfig);
                break;
            }
            case GOOGLE_APP_ENGINE: {
                detectedPlatform = new GoogleAppEngine(this.environmentVariables, this.metadataConfig);
                break;
            }
            case GOOGLE_COMPUTE_ENGINE: {
                detectedPlatform = new GoogleComputeEngine(this.metadataConfig);
                break;
            }
            default: {
                detectedPlatform = new UnknownPlatform();
            }
        }
        return detectedPlatform;
    }

    public static enum SupportedPlatform {
        GOOGLE_COMPUTE_ENGINE,
        GOOGLE_KUBERNETES_ENGINE,
        GOOGLE_APP_ENGINE,
        GOOGLE_CLOUD_RUN,
        GOOGLE_CLOUD_RUN_JOB,
        GOOGLE_CLOUD_FUNCTIONS,
        UNKNOWN_PLATFORM;

    }
}

