/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.pulsar.broker.BitRateUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxInfoUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LinuxInfoUtils.class);
    private static final String CGROUPS_CPU_USAGE_PATH = "/sys/fs/cgroup/cpu/cpuacct.usage";
    private static final String CGROUPS_CPU_LIMIT_QUOTA_PATH = "/sys/fs/cgroup/cpu/cpu.cfs_quota_us";
    private static final String CGROUPS_CPU_LIMIT_PERIOD_PATH = "/sys/fs/cgroup/cpu/cpu.cfs_period_us";
    private static final String PROC_STAT_PATH = "/proc/stat";
    private static final String NIC_PATH = "/sys/class/net/";
    private static final int ARPHRD_ETHER = 1;
    private static final String NIC_SPEED_TEMPLATE = "/sys/class/net/%s/speed";
    private static final long errLogPrintedFrequencyInReadingNicLimits = 1000L;
    private static final AtomicLong failedCounterInReadingNicLimits = new AtomicLong(0L);
    private static Object metrics;
    private static Method getMetricsProviderMethod;
    private static Method getCpuQuotaMethod;
    private static Method getCpuPeriodMethod;
    private static Method getCpuUsageMethod;

    public static boolean isLinux() {
        return SystemUtils.IS_OS_LINUX;
    }

    public static boolean isCGroupEnabled() {
        try {
            if (metrics == null) {
                return Files.exists(Paths.get(CGROUPS_CPU_USAGE_PATH, new String[0]), new LinkOption[0]);
            }
            String provider = (String)getMetricsProviderMethod.invoke(metrics, new Object[0]);
            log.info("[LinuxInfo] The system metrics provider is: {}", (Object)provider);
            return provider.contains("cgroup");
        }
        catch (Exception e) {
            log.warn("[LinuxInfo] Failed to check cgroup CPU: {}", (Object)e.getMessage());
            return false;
        }
    }

    public static double getTotalCpuLimit(boolean isCGroupsEnabled) {
        if (isCGroupsEnabled) {
            try {
                long period;
                long quota;
                if (metrics != null && getCpuQuotaMethod != null && getCpuPeriodMethod != null) {
                    quota = (Long)getCpuQuotaMethod.invoke(metrics, new Object[0]);
                    period = (Long)getCpuPeriodMethod.invoke(metrics, new Object[0]);
                } else {
                    quota = LinuxInfoUtils.readLongFromFile(Paths.get(CGROUPS_CPU_LIMIT_QUOTA_PATH, new String[0]));
                    period = LinuxInfoUtils.readLongFromFile(Paths.get(CGROUPS_CPU_LIMIT_PERIOD_PATH, new String[0]));
                }
                if (quota > 0L) {
                    return 100.0 * (double)quota / (double)period;
                }
            }
            catch (Exception e) {
                log.warn("[LinuxInfo] Failed to read CPU quotas from cgroup", (Throwable)e);
            }
        }
        return 100 * Runtime.getRuntime().availableProcessors();
    }

    public static long getCpuUsageForCGroup() {
        try {
            if (metrics != null && getCpuUsageMethod != null) {
                return (Long)getCpuUsageMethod.invoke(metrics, new Object[0]);
            }
            return LinuxInfoUtils.readLongFromFile(Paths.get(CGROUPS_CPU_USAGE_PATH, new String[0]));
        }
        catch (Exception e) {
            log.error("[LinuxInfo] Failed to read CPU usage from cgroup", (Throwable)e);
            return -1L;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ResourceUsage getCpuUsageForEntireHost() {
        try (Stream<String> stream = Files.lines(Paths.get(PROC_STAT_PATH, new String[0]));){
            Optional<String> first = stream.findFirst();
            if (!first.isPresent()) {
                log.error("[LinuxInfo] Failed to read CPU usage from /proc/stat, because of empty values.");
                ResourceUsage resourceUsage2 = ResourceUsage.empty();
                return resourceUsage2;
            }
            String[] words = first.get().split("\\s+");
            long total = Arrays.stream(words).filter(s -> !s.contains("cpu")).mapToLong(Long::parseLong).sum();
            long idle = Long.parseLong(words[4]) + Long.parseLong(words[5]);
            ResourceUsage resourceUsage = ResourceUsage.builder().usage(total - idle).idle(idle).total(total).build();
            return resourceUsage;
        }
        catch (IOException e) {
            log.error("[LinuxInfo] Failed to read CPU usage from /proc/stat", (Throwable)e);
            return ResourceUsage.empty();
        }
    }

    private static boolean isPhysicalNic(Path nicPath) {
        try {
            if (nicPath.toString().contains("/virtual/")) {
                return false;
            }
            Path nicTypePath = nicPath.resolve("type");
            if (!Files.exists(nicTypePath, new LinkOption[0])) {
                if (log.isDebugEnabled()) {
                    log.debug("Failed to read NIC type, the expected linux type file does not exist. nic_type_path={}", (Object)nicTypePath);
                }
                return false;
            }
            return Integer.parseInt(LinuxInfoUtils.readTrimStringFromFile(nicTypePath)) == 1;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to read NIC type. nic_path={}", (Object)nicPath, (Object)ex);
            }
            return false;
        }
    }

    private static boolean isUsable(Path nicPath) {
        try {
            String operstate = LinuxInfoUtils.readTrimStringFromFile(nicPath.resolve("operstate"));
            Operstate operState = Operstate.valueOf(operstate.toUpperCase(Locale.ROOT));
            switch (operState.ordinal()) {
                case 0: 
                case 3: 
                case 4: {
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            log.warn("[LinuxInfo] Failed to read {} NIC operstate, the detail is: {}", (Object)nicPath, (Object)e.getMessage());
            return false;
        }
    }

    public static double getTotalNicLimit(List<String> nics, BitRateUnit bitRateUnit) {
        return bitRateUnit.convert(nics.stream().mapToDouble(nicPath -> {
            try {
                return LinuxInfoUtils.readDoubleFromFile(LinuxInfoUtils.getReplacedNICPath(NIC_SPEED_TEMPLATE, nicPath));
            }
            catch (IOException e) {
                if (failedCounterInReadingNicLimits.getAndIncrement() % 1000L == 0L) {
                    log.error("[LinuxInfo] Failed to get the nic limit of {}.", nicPath, (Object)e);
                } else if (log.isDebugEnabled()) {
                    log.debug("[LinuxInfo] Failed to get the nic limit of {}.", nicPath, (Object)e);
                }
                return 0.0;
            }
        }).sum(), BitRateUnit.Megabit);
    }

    public static double getTotalNicUsage(List<String> nics, NICUsageType type, BitRateUnit bitRateUnit) {
        return bitRateUnit.convert(nics.stream().mapToDouble(nic -> {
            try {
                return LinuxInfoUtils.readDoubleFromFile(LinuxInfoUtils.getReplacedNICPath(type.template, nic));
            }
            catch (IOException e) {
                log.error("[LinuxInfo] Failed to read {} bytes for NIC {} ", new Object[]{type, nic, e});
                return 0.0;
            }
        }).sum(), BitRateUnit.Byte);
    }

    public static List<String> getUsablePhysicalNICs() {
        List<String> list;
        block8: {
            Stream<Path> stream = Files.list(Paths.get(NIC_PATH, new String[0]));
            try {
                list = stream.filter(LinuxInfoUtils::isPhysicalNic).filter(LinuxInfoUtils::isUsable).map(path -> path.getFileName().toString()).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("[LinuxInfo] Failed to find NICs", (Throwable)e);
                    return Collections.emptyList();
                }
            }
            stream.close();
        }
        return list;
    }

    public static boolean checkHasNicSpeeds() {
        List<String> physicalNICs = LinuxInfoUtils.getUsablePhysicalNICs();
        if (CollectionUtils.isEmpty(physicalNICs)) {
            return false;
        }
        double totalNicLimit = LinuxInfoUtils.getTotalNicLimit(physicalNICs, BitRateUnit.Kilobit);
        return totalNicLimit > 0.0;
    }

    private static Path getReplacedNICPath(String template, String nic) {
        return Paths.get(String.format(template, nic), new String[0]);
    }

    private static String readTrimStringFromFile(Path path) throws IOException {
        return new String(Files.readAllBytes(path), StandardCharsets.UTF_8).trim();
    }

    private static long readLongFromFile(Path path) throws IOException {
        return Long.parseLong(LinuxInfoUtils.readTrimStringFromFile(path));
    }

    private static double readDoubleFromFile(Path path) throws IOException {
        return Double.parseDouble(LinuxInfoUtils.readTrimStringFromFile(path));
    }

    @VisibleForTesting
    public static Object getMetrics() {
        return metrics;
    }

    static {
        try {
            metrics = Class.forName("jdk.internal.platform.Container").getMethod("metrics", new Class[0]).invoke(null, new Object[0]);
            if (metrics != null) {
                getMetricsProviderMethod = metrics.getClass().getMethod("getProvider", new Class[0]);
                getMetricsProviderMethod.setAccessible(true);
                getCpuQuotaMethod = metrics.getClass().getMethod("getCpuQuota", new Class[0]);
                getCpuQuotaMethod.setAccessible(true);
                getCpuPeriodMethod = metrics.getClass().getMethod("getCpuPeriod", new Class[0]);
                getCpuPeriodMethod.setAccessible(true);
                getCpuUsageMethod = metrics.getClass().getMethod("getCpuUsage", new Class[0]);
                getCpuUsageMethod.setAccessible(true);
            }
        }
        catch (Throwable e) {
            log.warn("Failed to get runtime metrics", e);
        }
    }

    public static class ResourceUsage {
        private final long total;
        private final long idle;
        private final long usage;

        public static ResourceUsage empty() {
            return ResourceUsage.builder().total(-1L).idle(-1L).usage(-1L).build();
        }

        public boolean isEmpty() {
            return this.total == -1L && this.idle == -1L && this.usage == -1L;
        }

        @Generated
        ResourceUsage(long total, long idle, long usage) {
            this.total = total;
            this.idle = idle;
            this.usage = usage;
        }

        @Generated
        public static ResourceUsageBuilder builder() {
            return new ResourceUsageBuilder();
        }

        @Generated
        public long getTotal() {
            return this.total;
        }

        @Generated
        public long getIdle() {
            return this.idle;
        }

        @Generated
        public long getUsage() {
            return this.usage;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResourceUsage)) {
                return false;
            }
            ResourceUsage other = (ResourceUsage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTotal() != other.getTotal()) {
                return false;
            }
            if (this.getIdle() != other.getIdle()) {
                return false;
            }
            return this.getUsage() == other.getUsage();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResourceUsage;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $total = this.getTotal();
            result = result * 59 + (int)($total >>> 32 ^ $total);
            long $idle = this.getIdle();
            result = result * 59 + (int)($idle >>> 32 ^ $idle);
            long $usage = this.getUsage();
            result = result * 59 + (int)($usage >>> 32 ^ $usage);
            return result;
        }

        @Generated
        public String toString() {
            return "LinuxInfoUtils.ResourceUsage(total=" + this.getTotal() + ", idle=" + this.getIdle() + ", usage=" + this.getUsage() + ")";
        }

        @Generated
        public static class ResourceUsageBuilder {
            @Generated
            private long total;
            @Generated
            private long idle;
            @Generated
            private long usage;

            @Generated
            ResourceUsageBuilder() {
            }

            @Generated
            public ResourceUsageBuilder total(long total) {
                this.total = total;
                return this;
            }

            @Generated
            public ResourceUsageBuilder idle(long idle) {
                this.idle = idle;
                return this;
            }

            @Generated
            public ResourceUsageBuilder usage(long usage) {
                this.usage = usage;
                return this;
            }

            @Generated
            public ResourceUsage build() {
                return new ResourceUsage(this.total, this.idle, this.usage);
            }

            @Generated
            public String toString() {
                return "LinuxInfoUtils.ResourceUsage.ResourceUsageBuilder(total=" + this.total + ", idle=" + this.idle + ", usage=" + this.usage + ")";
            }
        }
    }

    static enum Operstate {
        UNKNOWN,
        DOWN,
        LOWERLAYERDOWN,
        DORMANT,
        UP;

    }

    public static enum NICUsageType {
        TX("/sys/class/net/%s/statistics/tx_bytes"),
        RX("/sys/class/net/%s/statistics/rx_bytes");

        private final String template;

        @Generated
        private NICUsageType(String template) {
            this.template = template;
        }
    }
}

