/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.channel;

import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitStateData;
import org.apache.pulsar.broker.loadbalance.extensions.manager.StateChangeListener;
import org.apache.pulsar.broker.loadbalance.extensions.models.Split;
import org.apache.pulsar.broker.loadbalance.extensions.models.Unload;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.stats.Metrics;

public interface ServiceUnitStateChannel
extends Closeable {
    public void start() throws PulsarServerException;

    public boolean started();

    @Override
    public void close() throws PulsarServerException;

    public CompletableFuture<Optional<String>> getChannelOwnerAsync();

    public CompletableFuture<Boolean> isChannelOwnerAsync();

    public boolean isChannelOwner() throws ExecutionException, InterruptedException, TimeoutException;

    public CompletableFuture<Optional<String>> getOwnerAsync(String var1);

    public Optional<String> getAssigned(String var1);

    public boolean isOwner(String var1, String var2);

    public boolean isOwner(String var1);

    public CompletableFuture<String> publishAssignEventAsync(String var1, String var2);

    public CompletableFuture<Void> publishUnloadEventAsync(Unload var1);

    public CompletableFuture<Void> publishSplitEventAsync(Split var1);

    public List<Metrics> getMetrics();

    public void listen(StateChangeListener var1);

    public Set<Map.Entry<String, ServiceUnitStateData>> getOwnershipEntrySet();

    public Set<NamespaceBundle> getOwnedServiceUnits();

    public void scheduleOwnershipMonitor();

    public void cancelOwnershipMonitor();

    public void cleanOwnerships();
}

