/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.api.kv;

import io.netty.util.ReferenceCountUtil;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.api.kv.PTableBase;
import org.apache.bookkeeper.api.kv.exceptions.KvApiException;
import org.apache.bookkeeper.api.kv.options.Options;
import org.apache.bookkeeper.api.kv.options.RangeOption;
import org.apache.bookkeeper.api.kv.result.Code;
import org.apache.bookkeeper.api.kv.result.KeyValue;
import org.apache.bookkeeper.api.kv.result.RangeResult;
import org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.bookkeeper.common.concurrent.FutureUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public interface PTableReadView<K, V>
extends PTableBase<K, V> {
    public CompletableFuture<RangeResult<K, V>> get(K var1, K var2, RangeOption<K> var3);

    default public CompletableFuture<V> get(K pKey, K lKey) {
        RangeOption option = (RangeOption)this.opFactory().optionFactory().newRangeOption().build();
        return ((CompletableFuture)this.get(pKey, lKey, option).thenApply(result -> {
            try {
                if (result.count() == 0L) {
                    Object var1_1 = null;
                    return var1_1;
                }
                Object object = ReferenceCountUtil.retain(result.kvs().get(0).value());
                return object;
            }
            finally {
                result.close();
            }
        })).whenComplete((value, cause) -> option.close());
    }

    default public CompletableFuture<Long> getNumber(K pKey, K lKey) {
        RangeOption option = (RangeOption)this.opFactory().optionFactory().newRangeOption().build();
        return ((CompletableFuture)this.get(pKey, lKey, option).thenCompose(result -> {
            try {
                if (result.count() == 0L) {
                    CompletableFuture completableFuture = FutureUtils.value(null);
                    return completableFuture;
                }
                KeyValue kv = result.kvs().get(0);
                if (kv.isNumber()) {
                    CompletableFuture completableFuture = FutureUtils.value((Object)kv.numberValue());
                    return completableFuture;
                }
                CompletableFuture completableFuture = FutureUtils.exception((Throwable)new KvApiException(Code.ILLEGAL_OP, "Key (" + pKey + ", " + lKey + ") doesn't have any number value"));
                return completableFuture;
            }
            finally {
                result.close();
            }
        })).whenComplete((value, cause) -> option.close());
    }

    default public CompletableFuture<KeyValue<K, V>> getKv(K pKey, K lKey) {
        return this.get(pKey, lKey, Options.get()).thenApply(result -> {
            try {
                if (result.count() == 0L) {
                    KeyValue keyValue = null;
                    return keyValue;
                }
                KeyValue keyValue = result.getKvsAndClear().get(0);
                return keyValue;
            }
            finally {
                result.close();
            }
        });
    }

    default public CompletableFuture<List<KeyValue<K, V>>> range(K pKey, K lStartKey, K lEndKey) {
        RangeOption option = (RangeOption)this.opFactory().optionFactory().newRangeOption().countOnly(false).keysOnly(false).limit(Long.MAX_VALUE).endKey(lEndKey).build();
        return ((CompletableFuture)this.get(pKey, lStartKey, option).thenApply(result -> {
            try {
                List list = result.getKvsAndClear();
                return list;
            }
            finally {
                result.close();
            }
        })).whenComplete((value, cause) -> option.close());
    }
}

