/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest.api;

import io.netty.buffer.ByteBuf;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.IOException;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.common.util.SimpleTextOutputStream;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.rest.FunctionApiResource;

@Path(value="/")
public class FunctionsMetricsResource
extends FunctionApiResource {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="metrics")
    @GET
    @Produces(value={"text/plain"})
    public Response getMetrics() throws IOException {
        WorkerService workerService = this.get();
        ByteBuf buf = PulsarByteBufAllocator.DEFAULT.heapBuffer();
        if (workerService.getWorkerConfig().isIncludeStandardPrometheusMetrics()) {
            BufWriter writer = new BufWriter(buf);
            TextFormat.write004((Writer)writer, (Enumeration)CollectorRegistry.defaultRegistry.metricFamilySamples());
        }
        try {
            SimpleTextOutputStream stream = new SimpleTextOutputStream(buf);
            workerService.generateFunctionsStats(stream);
            byte[] payload = buf.array();
            int arrayOffset = buf.arrayOffset();
            int readableBytes = buf.readableBytes();
            StreamingOutput streamOut = out -> {
                out.write(payload, arrayOffset, readableBytes);
                out.flush();
            };
            Response response = Response.ok((Object)streamOut).type("text/plain; version=0.0.4; charset=utf-8").build();
            return response;
        }
        finally {
            buf.release();
        }
    }

    private static class BufWriter
    extends Writer {
        private final ByteBuf buf;

        public BufWriter(ByteBuf buf) {
            this.buf = buf;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.buf.writeCharSequence((CharSequence)CharBuffer.wrap(cbuf, off, len), StandardCharsets.UTF_8);
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

