/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.transaction.coordinator.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.intercept.ManagedLedgerInterceptor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.pulsar.transaction.coordinator.impl.MLTransactionLogImpl;
import org.apache.pulsar.transaction.coordinator.proto.TransactionMetadataEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLTransactionSequenceIdGenerator
implements ManagedLedgerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(MLTransactionSequenceIdGenerator.class);
    private static final long TC_ID_NOT_USED = -1L;
    public static final String MAX_LOCAL_TXN_ID = "max_local_txn_id";
    private final AtomicLong sequenceId = new AtomicLong(-1L);

    public void beforeAddEntry(ManagedLedgerInterceptor.AddEntryOperation op, int numberOfMessages) {
    }

    public void onManagedLedgerPropertiesInitialize(Map<String, String> propertiesMap) {
        if (propertiesMap == null || propertiesMap.size() == 0) {
            return;
        }
        if (propertiesMap.containsKey(MAX_LOCAL_TXN_ID)) {
            this.sequenceId.set(Long.parseLong(propertiesMap.get(MAX_LOCAL_TXN_ID)));
        }
    }

    public CompletableFuture<Void> onManagedLedgerLastLedgerInitialize(String name, ManagedLedgerInterceptor.LastEntryHandle lh) {
        return lh.readLastEntryAsync().thenAccept(lastEntryOptional -> {
            if (lastEntryOptional.isPresent()) {
                Entry lastEntry = (Entry)lastEntryOptional.get();
                try {
                    List<TransactionMetadataEntry> transactionLogs = MLTransactionLogImpl.deserializeEntry(lastEntry.getDataBuffer());
                    if (!CollectionUtils.isEmpty(transactionLogs)) {
                        TransactionMetadataEntry lastConfirmEntry = transactionLogs.get(transactionLogs.size() - 1);
                        this.sequenceId.set(lastConfirmEntry.getMaxLocalTxnId());
                    }
                }
                finally {
                    lastEntry.release();
                }
            }
        });
    }

    public void onUpdateManagedLedgerInfo(Map<String, String> propertiesMap) {
        propertiesMap.put(MAX_LOCAL_TXN_ID, "" + this.sequenceId.get());
    }

    long generateSequenceId() {
        return this.sequenceId.incrementAndGet();
    }

    long getCurrentSequenceId() {
        return this.sequenceId.get();
    }
}

