/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.bookkeeper.stream.proto.common.Endpoint;
import org.apache.commons.lang3.StringUtils;

public class NetUtils {
    public static InetSocketAddress of(Endpoint endpoint) {
        return new InetSocketAddress(endpoint.getHostname(), endpoint.getPort());
    }

    public static String getLocalHostName(boolean useHostname) {
        String hostname;
        try {
            hostname = useHostname ? InetAddress.getLocalHost().getHostName() : InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException uhe) {
            hostname = "Unknown-Host-Name";
        }
        return hostname;
    }

    public static Endpoint getLocalEndpoint(int port, boolean useHostname) throws UnknownHostException {
        String hostname = useHostname ? InetAddress.getLocalHost().getHostName() : InetAddress.getLocalHost().getHostAddress();
        return NetUtils.createEndpoint(hostname, port);
    }

    public static List<Endpoint> parseEndpoints(String endpointStr) {
        String[] endpointParts = StringUtils.split((String)endpointStr, (char)',');
        Preconditions.checkArgument((endpointParts.length > 0 ? 1 : 0) != 0, (String)"Invalid endpoint strings %s", (Object)endpointStr);
        ArrayList endpoints = Lists.newArrayListWithExpectedSize((int)endpointParts.length);
        for (String endpointPart : endpointParts) {
            endpoints.add(NetUtils.parseEndpoint(endpointPart));
        }
        return endpoints;
    }

    public static Endpoint parseEndpoint(String endpointStr) {
        int port;
        String[] endpointParts = StringUtils.split((String)endpointStr, (char)':');
        Preconditions.checkArgument((2 == endpointParts.length ? 1 : 0) != 0, (String)"Invalid endpoint string %s - It should be 'host:port'.", (Object)endpointStr);
        String host = endpointParts[0];
        try {
            port = Integer.parseInt(endpointParts[1]);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid port found in the endpoint string " + endpointStr, nfe);
        }
        return NetUtils.createEndpoint(host, port);
    }

    public static Endpoint createEndpoint(String hostname, int port) {
        return Endpoint.newBuilder().setHostname(hostname).setPort(port).build();
    }

    public static String endpointToString(Endpoint ep) {
        StringBuilder sb = new StringBuilder();
        sb.append(ep.getHostname()).append(":").append(ep.getPort());
        return sb.toString();
    }
}

