/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1IngressBackend;
import io.kubernetes.client.openapi.models.V1IngressRule;
import io.kubernetes.client.openapi.models.V1IngressTLS;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="IngressSpec describes the Ingress the user wishes to exist.")
public class V1IngressSpec {
    public static final String SERIALIZED_NAME_DEFAULT_BACKEND = "defaultBackend";
    @SerializedName(value="defaultBackend")
    private V1IngressBackend defaultBackend;
    public static final String SERIALIZED_NAME_INGRESS_CLASS_NAME = "ingressClassName";
    @SerializedName(value="ingressClassName")
    private String ingressClassName;
    public static final String SERIALIZED_NAME_RULES = "rules";
    @SerializedName(value="rules")
    private List<V1IngressRule> rules = null;
    public static final String SERIALIZED_NAME_TLS = "tls";
    @SerializedName(value="tls")
    private List<V1IngressTLS> tls = null;

    public V1IngressSpec defaultBackend(V1IngressBackend defaultBackend) {
        this.defaultBackend = defaultBackend;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1IngressBackend getDefaultBackend() {
        return this.defaultBackend;
    }

    public void setDefaultBackend(V1IngressBackend defaultBackend) {
        this.defaultBackend = defaultBackend;
    }

    public V1IngressSpec ingressClassName(String ingressClassName) {
        this.ingressClassName = ingressClassName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IngressClassName is the name of an IngressClass cluster resource. Ingress controller implementations use this field to know whether they should be serving this Ingress resource, by a transitive connection (controller -> IngressClass -> Ingress resource). Although the `kubernetes.io/ingress.class` annotation (simple constant name) was never formally defined, it was widely supported by Ingress controllers to create a direct binding between Ingress controller and Ingress resources. Newly created Ingress resources should prefer using the field. However, even though the annotation is officially deprecated, for backwards compatibility reasons, ingress controllers should still honor that annotation if present.")
    public String getIngressClassName() {
        return this.ingressClassName;
    }

    public void setIngressClassName(String ingressClassName) {
        this.ingressClassName = ingressClassName;
    }

    public V1IngressSpec rules(List<V1IngressRule> rules) {
        this.rules = rules;
        return this;
    }

    public V1IngressSpec addRulesItem(V1IngressRule rulesItem) {
        if (this.rules == null) {
            this.rules = new ArrayList<V1IngressRule>();
        }
        this.rules.add(rulesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of host rules used to configure the Ingress. If unspecified, or no rule matches, all traffic is sent to the default backend.")
    public List<V1IngressRule> getRules() {
        return this.rules;
    }

    public void setRules(List<V1IngressRule> rules) {
        this.rules = rules;
    }

    public V1IngressSpec tls(List<V1IngressTLS> tls) {
        this.tls = tls;
        return this;
    }

    public V1IngressSpec addTlsItem(V1IngressTLS tlsItem) {
        if (this.tls == null) {
            this.tls = new ArrayList<V1IngressTLS>();
        }
        this.tls.add(tlsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.")
    public List<V1IngressTLS> getTls() {
        return this.tls;
    }

    public void setTls(List<V1IngressTLS> tls) {
        this.tls = tls;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1IngressSpec v1IngressSpec = (V1IngressSpec)o;
        return Objects.equals(this.defaultBackend, v1IngressSpec.defaultBackend) && Objects.equals(this.ingressClassName, v1IngressSpec.ingressClassName) && Objects.equals(this.rules, v1IngressSpec.rules) && Objects.equals(this.tls, v1IngressSpec.tls);
    }

    public int hashCode() {
        return Objects.hash(this.defaultBackend, this.ingressClassName, this.rules, this.tls);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1IngressSpec {\n");
        sb.append("    defaultBackend: ").append(this.toIndentedString(this.defaultBackend)).append("\n");
        sb.append("    ingressClassName: ").append(this.toIndentedString(this.ingressClassName)).append("\n");
        sb.append("    rules: ").append(this.toIndentedString(this.rules)).append("\n");
        sb.append("    tls: ").append(this.toIndentedString(this.tls)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

