/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1PodFailurePolicyRule;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="PodFailurePolicy describes how failed pods influence the backoffLimit.")
public class V1PodFailurePolicy {
    public static final String SERIALIZED_NAME_RULES = "rules";
    @SerializedName(value="rules")
    private List<V1PodFailurePolicyRule> rules = new ArrayList<V1PodFailurePolicyRule>();

    public V1PodFailurePolicy rules(List<V1PodFailurePolicyRule> rules) {
        this.rules = rules;
        return this;
    }

    public V1PodFailurePolicy addRulesItem(V1PodFailurePolicyRule rulesItem) {
        this.rules.add(rulesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of pod failure policy rules. The rules are evaluated in order. Once a rule matches a Pod failure, the remaining of the rules are ignored. When no rule matches the Pod failure, the default handling applies - the counter of pod failures is incremented and it is checked against the backoffLimit. At most 20 elements are allowed.")
    public List<V1PodFailurePolicyRule> getRules() {
        return this.rules;
    }

    public void setRules(List<V1PodFailurePolicyRule> rules) {
        this.rules = rules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodFailurePolicy v1PodFailurePolicy = (V1PodFailurePolicy)o;
        return Objects.equals(this.rules, v1PodFailurePolicy.rules);
    }

    public int hashCode() {
        return Objects.hash(this.rules);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PodFailurePolicy {\n");
        sb.append("    rules: ").append(this.toIndentedString(this.rules)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

