/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.jaxrs;

import com.fasterxml.jackson.databind.JavaType;
import com.google.common.base.Defaults;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.Parameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.ws.rs.BeanParam;
import org.apache.servicecomb.swagger.generator.ParameterGenerator;
import org.apache.servicecomb.swagger.generator.core.AbstractSwaggerGenerator;
import org.apache.servicecomb.swagger.generator.core.model.HttpParameterType;
import org.apache.servicecomb.swagger.generator.rest.RestOperationGenerator;

public class JaxrsOperationGenerator
extends RestOperationGenerator {
    public JaxrsOperationGenerator(AbstractSwaggerGenerator swaggerGenerator, Method method) {
        super(swaggerGenerator, method);
    }

    protected void initMethodParameterGenerators(Map<String, List<Annotation>> methodAnnotationMap) {
        super.initMethodParameterGenerators(methodAnnotationMap);
        this.parameterGenerators.stream().filter(pg -> pg.getHttpParameterType() == null).forEach(pg -> pg.setHttpParameterType(HttpParameterType.BODY));
    }

    protected boolean isAggregatedParameter(ParameterGenerator parameterGenerator, java.lang.reflect.Parameter methodParameter) {
        return methodParameter.getAnnotation(BeanParam.class) != null;
    }

    protected void fillParameter(Swagger swagger, Parameter parameter, String parameterName, JavaType type, List<Annotation> annotations) {
        super.fillParameter(swagger, parameter, parameterName, type, annotations);
        if (!(parameter instanceof AbstractSerializableParameter)) {
            return;
        }
        if (!type.isPrimitive()) {
            return;
        }
        AbstractSerializableParameter serializableParameter = (AbstractSerializableParameter)parameter;
        if (serializableParameter.getDefault() == null && !parameter.getRequired()) {
            serializableParameter.setDefaultValue(String.valueOf(Defaults.defaultValue((Class)type.getRawClass())));
        }
    }
}

