/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.version;

import com.google.common.base.Strings;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.constant.CommonConstants;
import org.apache.shardingsphere.database.protocol.constant.DatabaseProtocolServerInfo;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.version.ShardingSphereVersion;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.database.DatabaseServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShardingSphereProxyVersion {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShardingSphereProxyVersion.class);

    public static void setVersion(ContextManager contextManager) {
        CommonConstants.PROXY_VERSION.set(ShardingSphereProxyVersion.getProxyVersion());
        contextManager.getMetaDataContexts().getMetaData().getAllDatabases().forEach(ShardingSphereProxyVersion::setDatabaseVersion);
    }

    private static String getProxyVersion() {
        String result = ShardingSphereVersion.VERSION;
        if (!ShardingSphereVersion.IS_SNAPSHOT || Strings.isNullOrEmpty((String)ShardingSphereVersion.BUILD_COMMIT_ID_ABBREV)) {
            return result;
        }
        result = result + (ShardingSphereVersion.BUILD_DIRTY ? "-dirty" : "");
        result = result + "-" + ShardingSphereVersion.BUILD_COMMIT_ID_ABBREV;
        return result;
    }

    private static void setDatabaseVersion(ShardingSphereDatabase database) {
        Optional<DataSource> dataSource = ShardingSphereProxyVersion.findDataSourceByProtocolType(database);
        if (!dataSource.isPresent()) {
            return;
        }
        DatabaseServerInfo databaseServerInfo = new DatabaseServerInfo(dataSource.get());
        log.info("{}, database name is `{}`", (Object)databaseServerInfo, (Object)database.getName());
        DatabaseProtocolServerInfo.setProtocolVersion((String)database.getName(), (String)databaseServerInfo.getDatabaseVersion());
    }

    private static Optional<DataSource> findDataSourceByProtocolType(ShardingSphereDatabase database) {
        Optional<String> dataSourceName = database.getResourceMetaData().getStorageUnits().entrySet().stream().filter(entry -> ((StorageUnit)entry.getValue()).getStorageType().equals(database.getProtocolType())).map(Map.Entry::getKey).findFirst();
        Map dataSources = database.getResourceMetaData().getStorageUnits().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StorageUnit)entry.getValue()).getDataSource(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
        return dataSourceName.flatMap(optional -> Optional.ofNullable((DataSource)dataSources.get(optional)));
    }

    @Generated
    private ShardingSphereProxyVersion() {
    }
}

