/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.statement.type;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlValuesOperator;
import org.apache.calcite.sql.fun.SqlRowOperator;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.ColumnAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.InsertStatement;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.expression.ExpressionConverter;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.expression.impl.ColumnConverter;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.from.TableConverter;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.statement.SQLStatementConverter;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.statement.type.SelectStatementConverter;

public final class InsertStatementConverter
implements SQLStatementConverter<InsertStatement, SqlNode> {
    @Override
    public SqlNode convert(InsertStatement insertStatement) {
        return this.convertInsert(insertStatement);
    }

    private SqlInsert convertInsert(InsertStatement insertStatement) {
        SqlNode table = (SqlNode)insertStatement.getTable().flatMap(TableConverter::convert).orElseThrow(IllegalStateException::new);
        SqlNode source = this.convertSource(insertStatement);
        SqlNodeList columns = this.convertColumn(insertStatement);
        return new SqlInsert(SqlParserPos.ZERO, SqlNodeList.EMPTY, table, source, columns);
    }

    private SqlNode convertSource(InsertStatement insertStatement) {
        if (insertStatement.getInsertSelect().isPresent()) {
            return new SelectStatementConverter().convert(((SubquerySegment)insertStatement.getInsertSelect().get()).getSelect());
        }
        if (insertStatement.getSetAssignment().isPresent()) {
            return this.convertSetAssignment((SetAssignmentSegment)insertStatement.getSetAssignment().get());
        }
        return this.convertValues(insertStatement.getValues());
    }

    private SqlNode convertSetAssignment(SetAssignmentSegment setAssignment) {
        ArrayList<SqlBasicCall> operands = new ArrayList<SqlBasicCall>();
        ArrayList<SqlNode> values = new ArrayList<SqlNode>();
        for (ColumnAssignmentSegment each : setAssignment.getAssignments()) {
            values.add(this.convertExpression(each.getValue()));
        }
        operands.add(new SqlBasicCall((SqlOperator)new SqlRowOperator("ROW"), values, SqlParserPos.ZERO));
        return new SqlBasicCall((SqlOperator)new SqlValuesOperator(), operands, SqlParserPos.ZERO);
    }

    private SqlNode convertValues(Collection<InsertValuesSegment> insertValuesSegments) {
        ArrayList<SqlBasicCall> operands = new ArrayList<SqlBasicCall>();
        for (InsertValuesSegment each : insertValuesSegments) {
            ArrayList<SqlNode> values = new ArrayList<SqlNode>();
            for (ExpressionSegment value : each.getValues()) {
                values.add(this.convertExpression(value));
            }
            operands.add(new SqlBasicCall((SqlOperator)new SqlRowOperator("ROW"), values, SqlParserPos.ZERO));
        }
        return new SqlBasicCall((SqlOperator)new SqlValuesOperator(), operands, SqlParserPos.ZERO);
    }

    private SqlNodeList convertColumn(InsertStatement insertStatement) {
        ArrayList<SqlIdentifier> columns = new ArrayList<SqlIdentifier>();
        insertStatement.getSetAssignment().ifPresent(optional -> columns.addAll(this.convertSetAssignmentColumns((SetAssignmentSegment)optional)));
        for (ColumnSegment each : insertStatement.getColumns()) {
            columns.add(ColumnConverter.convert(each));
        }
        return columns.isEmpty() ? null : new SqlNodeList(columns, SqlParserPos.ZERO);
    }

    private Collection<SqlNode> convertSetAssignmentColumns(SetAssignmentSegment setAssignment) {
        ArrayList<SqlNode> result = new ArrayList<SqlNode>();
        for (ColumnAssignmentSegment each : setAssignment.getAssignments()) {
            for (ColumnSegment column : each.getColumns()) {
                result.add((SqlNode)ColumnConverter.convert(column));
            }
        }
        return result;
    }

    private SqlNode convertExpression(ExpressionSegment expressionSegment) {
        return ExpressionConverter.convert(expressionSegment).orElseThrow(IllegalStateException::new);
    }
}

