/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.calculator;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.DataConsistencyCheckUtils;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.result.RecordTableInventoryCheckCalculatedResult;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.result.TableInventoryCheckCalculatedResult;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.column.InventoryColumnValueReaderEngine;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.StreamingRangeType;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.calculator.AbstractRecordTableInventoryCalculator;

public final class RecordTableInventoryCheckCalculator
extends AbstractRecordTableInventoryCalculator<TableInventoryCheckCalculatedResult, Map<String, Object>> {
    public RecordTableInventoryCheckCalculator(int chunkSize, int streamingChunkCount, StreamingRangeType streamingRangeType) {
        super(chunkSize, streamingChunkCount, streamingRangeType);
    }

    public RecordTableInventoryCheckCalculator(int chunkSize, StreamingRangeType streamingRangeType) {
        super(chunkSize, streamingRangeType);
    }

    @Override
    protected Map<String, Object> readRecord(ResultSet resultSet, ResultSetMetaData resultSetMetaData, InventoryColumnValueReaderEngine columnValueReaderEngine) throws SQLException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        int columnCount = resultSetMetaData.getColumnCount();
        for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
            result.put(resultSetMetaData.getColumnLabel(columnIndex), columnValueReaderEngine.read(resultSet, resultSetMetaData, columnIndex));
        }
        return result;
    }

    @Override
    protected Object getFirstUniqueKeyValue(Map<String, Object> record, String firstUniqueKey) {
        return DataConsistencyCheckUtils.getFirstUniqueKeyValue(record, firstUniqueKey);
    }

    @Override
    protected TableInventoryCheckCalculatedResult convertRecordsToResult(List<Map<String, Object>> records, Object maxUniqueKeyValue) {
        return new RecordTableInventoryCheckCalculatedResult(maxUniqueKeyValue, records);
    }
}

