/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query;

import java.math.BigInteger;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.Range;

public final class IntegerRangeSplittingIterator
implements Iterator<Range<BigInteger>> {
    private final BigInteger upperBound;
    private final BigInteger stepSize;
    private BigInteger current;

    public IntegerRangeSplittingIterator(BigInteger lowerBound, BigInteger upperBound, BigInteger stepSize) {
        if (lowerBound.compareTo(upperBound) > 0) {
            throw new IllegalArgumentException("lower bound greater than upper bound");
        }
        if (stepSize.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("step size is less than zero");
        }
        this.upperBound = upperBound;
        this.stepSize = stepSize;
        this.current = lowerBound;
    }

    @Override
    public boolean hasNext() {
        return this.current.compareTo(this.upperBound) <= 0;
    }

    @Override
    public Range<BigInteger> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("");
        }
        BigInteger upperLimit = this.min(this.upperBound, this.current.add(this.stepSize));
        Range<BigInteger> result = Range.closed(this.current, upperLimit);
        this.current = upperLimit.add(BigInteger.ONE);
        return result;
    }

    private BigInteger min(BigInteger one, BigInteger another) {
        return one.compareTo(another) < 0 ? one : another;
    }
}

