/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.core.job.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.job.config.PipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobIdUtils;
import org.apache.shardingsphere.data.pipeline.core.job.progress.TransmissionJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobConfigurationManager;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobItemManager;
import org.apache.shardingsphere.data.pipeline.core.job.type.PipelineJobType;
import org.apache.shardingsphere.data.pipeline.core.pojo.PipelineJobTarget;
import org.apache.shardingsphere.data.pipeline.core.pojo.TransmissionJobItemInfo;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;

public final class TransmissionJobManager {
    private final PipelineJobType jobType;

    public Collection<TransmissionJobItemInfo> getJobItemInfos(String jobId) {
        Object jobConfig = new PipelineJobConfigurationManager(this.jobType.getOption()).getJobConfiguration(jobId);
        long startTimeMillis = Long.parseLong(Optional.ofNullable(PipelineJobIdUtils.getElasticJobConfigurationPOJO(jobId).getProps().getProperty("start_time_millis")).orElse("0"));
        Map<Integer, TransmissionJobItemProgress> jobProgress = this.getJobProgress((PipelineJobConfiguration)jobConfig);
        LinkedList<TransmissionJobItemInfo> result = new LinkedList<TransmissionJobItemInfo>();
        PipelineJobTarget jobTarget = this.jobType.getJobTarget(jobConfig);
        for (Map.Entry<Integer, TransmissionJobItemProgress> entry : jobProgress.entrySet()) {
            int shardingItem = entry.getKey();
            TransmissionJobItemProgress jobItemProgress = entry.getValue();
            String errorMessage = PipelineAPIFactory.getPipelineGovernanceFacade(PipelineJobIdUtils.parseContextKey(jobId)).getJobItemFacade().getErrorMessage().load(jobId, shardingItem);
            if (null == jobItemProgress) {
                result.add(new TransmissionJobItemInfo(shardingItem, jobTarget.getTableName(), null, startTimeMillis, 0, errorMessage));
                continue;
            }
            int inventoryFinishedPercentage = TransmissionJobManager.getInventoryFinishedPercentage(jobItemProgress);
            result.add(new TransmissionJobItemInfo(shardingItem, jobTarget.getTableName(), jobItemProgress, startTimeMillis, inventoryFinishedPercentage, errorMessage));
        }
        return result;
    }

    public static int getInventoryFinishedPercentage(TransmissionJobItemProgress jobItemProgress) {
        if (JobStatus.EXECUTE_INCREMENTAL_TASK == jobItemProgress.getStatus() || JobStatus.FINISHED == jobItemProgress.getStatus()) {
            return 100;
        }
        if (0L != jobItemProgress.getProcessedRecordsCount() && 0L != jobItemProgress.getInventoryRecordsCount()) {
            return (int)Math.min(100L, jobItemProgress.getProcessedRecordsCount() * 100L / jobItemProgress.getInventoryRecordsCount());
        }
        return 0;
    }

    public Map<Integer, TransmissionJobItemProgress> getJobProgress(PipelineJobConfiguration jobConfig) {
        PipelineJobItemManager jobItemManager = new PipelineJobItemManager(this.jobType.getOption().getYamlJobItemProgressSwapper());
        String jobId = jobConfig.getJobId();
        JobConfigurationPOJO jobConfigPOJO = PipelineJobIdUtils.getElasticJobConfigurationPOJO(jobId);
        return IntStream.range(0, jobConfig.getJobShardingCount()).boxed().collect(LinkedHashMap::new, (map, each) -> {
            Optional<TransmissionJobItemProgress> jobItemProgress = jobItemManager.getProgress(jobId, (int)each);
            jobItemProgress.ifPresent(optional -> optional.setActive(!jobConfigPOJO.isDisabled()));
            map.put(each, jobItemProgress.orElse(null));
        }, HashMap::putAll);
    }

    @Generated
    public TransmissionJobManager(PipelineJobType jobType) {
        this.jobType = jobType;
    }
}

