/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.postgresql.packet.command;

import java.util.EnumSet;
import java.util.Set;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.packet.command.CommandPacketType;
import org.apache.shardingsphere.database.protocol.postgresql.exception.PostgreSQLProtocolException;
import org.apache.shardingsphere.database.protocol.postgresql.packet.identifier.PostgreSQLIdentifierTag;

public enum PostgreSQLCommandPacketType implements CommandPacketType,
PostgreSQLIdentifierTag
{
    PASSWORD('p'),
    SIMPLE_QUERY('Q'),
    PARSE_COMMAND('P'),
    BIND_COMMAND('B'),
    DESCRIBE_COMMAND('D'),
    EXECUTE_COMMAND('E'),
    SYNC_COMMAND('S'),
    CLOSE_COMMAND('C'),
    FLUSH_COMMAND('H'),
    TERMINATE('X');

    private static final Set<PostgreSQLCommandPacketType> EXTENDED_PROTOCOL_PACKET_TYPES;
    private final char value;

    public static PostgreSQLCommandPacketType valueOf(int value) {
        for (PostgreSQLCommandPacketType each : PostgreSQLCommandPacketType.values()) {
            if (value != each.value) continue;
            return each;
        }
        throw new PostgreSQLProtocolException("Can not find `%s` in PostgreSQL command packet type.", value);
    }

    public static boolean isExtendedProtocolPacketType(CommandPacketType commandPacketType) {
        return EXTENDED_PROTOCOL_PACKET_TYPES.contains(commandPacketType);
    }

    @Generated
    private PostgreSQLCommandPacketType(char value) {
        this.value = value;
    }

    @Override
    @Generated
    public char getValue() {
        return this.value;
    }

    static {
        EXTENDED_PROTOCOL_PACKET_TYPES = EnumSet.of(PARSE_COMMAND, new PostgreSQLCommandPacketType[]{BIND_COMMAND, DESCRIBE_COMMAND, EXECUTE_COMMAND, SYNC_COMMAND, CLOSE_COMMAND, FLUSH_COMMAND});
    }
}

