/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rule.changed;

import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.mode.spi.rule.RuleChangedItemType;
import org.apache.shardingsphere.mode.spi.rule.RuleItemConfigurationChangedProcessor;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class DefaultShardingColumnChangedProcessor
implements RuleItemConfigurationChangedProcessor<ShardingRuleConfiguration, String> {
    public String swapRuleItemConfiguration(String itemName, String yamlContent) {
        return yamlContent;
    }

    public ShardingRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findSingleRule(ShardingRule.class).map(ShardingRule::getConfiguration).orElseGet(ShardingRuleConfiguration::new);
    }

    public void changeRuleItemConfiguration(String itemName, ShardingRuleConfiguration currentRuleConfig, String toBeChangedItemConfig) {
        currentRuleConfig.setDefaultShardingColumn(toBeChangedItemConfig);
    }

    public void dropRuleItemConfiguration(String itemName, ShardingRuleConfiguration currentRuleConfig) {
        currentRuleConfig.setDefaultShardingColumn(null);
    }

    public RuleChangedItemType getType() {
        return new RuleChangedItemType("sharding", "default_sharding_column");
    }
}

