/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.migration;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.data.pipeline.api.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.type.ShardingSpherePipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.context.TransmissionJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.context.TransmissionProcessContext;
import org.apache.shardingsphere.data.pipeline.core.datanode.JobDataNodeEntry;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.core.importer.ImporterConfiguration;
import org.apache.shardingsphere.data.pipeline.core.importer.PipelineRequiredColumnsExtractor;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.incremental.IncrementalDumperContext;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.mapper.TableAndSchemaNameMapper;
import org.apache.shardingsphere.data.pipeline.core.job.executor.DistributedPipelineJobExecutorCallback;
import org.apache.shardingsphere.data.pipeline.core.job.progress.TransmissionJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.config.PipelineProcessConfiguration;
import org.apache.shardingsphere.data.pipeline.core.preparer.datasource.param.CreateTableConfiguration;
import org.apache.shardingsphere.data.pipeline.core.ratelimit.JobRateLimitAlgorithm;
import org.apache.shardingsphere.data.pipeline.core.task.runner.PipelineTasksRunner;
import org.apache.shardingsphere.data.pipeline.core.task.runner.TransmissionTasksRunner;
import org.apache.shardingsphere.data.pipeline.scenario.migration.config.MigrationJobConfiguration;
import org.apache.shardingsphere.data.pipeline.scenario.migration.config.MigrationTaskConfiguration;
import org.apache.shardingsphere.data.pipeline.scenario.migration.context.MigrationJobItemContext;
import org.apache.shardingsphere.data.pipeline.scenario.migration.ingest.dumper.MigrationIncrementalDumperContextCreator;
import org.apache.shardingsphere.data.pipeline.scenario.migration.preparer.MigrationJobPreparer;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.apache.shardingsphere.infra.metadata.identifier.ShardingSphereIdentifier;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlRuleConfiguration;

public final class MigrationJobExecutorCallback
implements DistributedPipelineJobExecutorCallback<MigrationJobConfiguration, MigrationJobItemContext, TransmissionJobItemProgress> {
    public MigrationJobItemContext buildJobItemContext(MigrationJobConfiguration jobConfig, int shardingItem, TransmissionJobItemProgress jobItemProgress, TransmissionProcessContext jobProcessContext, PipelineDataSourceManager dataSourceManager) {
        MigrationTaskConfiguration taskConfig = this.buildTaskConfiguration(jobConfig, shardingItem, jobProcessContext.getProcessConfiguration());
        return new MigrationJobItemContext(jobConfig, shardingItem, jobItemProgress, jobProcessContext, taskConfig, dataSourceManager);
    }

    private MigrationTaskConfiguration buildTaskConfiguration(MigrationJobConfiguration jobConfig, int jobShardingItem, PipelineProcessConfiguration processConfig) {
        Map<ShardingSphereIdentifier, Collection<String>> tableAndRequiredColumnsMap = this.getTableAndRequiredColumnsMap(jobConfig);
        IncrementalDumperContext incrementalDumperContext = new MigrationIncrementalDumperContextCreator(jobConfig).createDumperContext(jobConfig.getJobDataNodeLine(jobShardingItem));
        Collection<CreateTableConfiguration> createTableConfigs = this.buildCreateTableConfigurations(jobConfig, incrementalDumperContext.getCommonContext().getTableAndSchemaNameMapper());
        ImporterConfiguration importerConfig = this.buildImporterConfiguration(jobConfig, processConfig, tableAndRequiredColumnsMap, incrementalDumperContext.getCommonContext().getTableAndSchemaNameMapper());
        return new MigrationTaskConfiguration(incrementalDumperContext.getCommonContext().getDataSourceName(), createTableConfigs, incrementalDumperContext, importerConfig);
    }

    private Map<ShardingSphereIdentifier, Collection<String>> getTableAndRequiredColumnsMap(MigrationJobConfiguration jobConfig) {
        HashMap<ShardingSphereIdentifier, Collection<String>> result = new HashMap<ShardingSphereIdentifier, Collection<String>>();
        Collection yamlRuleConfigs = ((ShardingSpherePipelineDataSourceConfiguration)jobConfig.getTarget()).getRootConfig().getRules();
        Collection targetTableNames = jobConfig.getTargetTableNames().stream().map(ShardingSphereIdentifier::new).collect(Collectors.toSet());
        for (Map.Entry entry : OrderedSPILoader.getServices(PipelineRequiredColumnsExtractor.class, (Collection)yamlRuleConfigs).entrySet()) {
            result.putAll(((PipelineRequiredColumnsExtractor)entry.getValue()).getTableAndRequiredColumnsMap((YamlRuleConfiguration)entry.getKey(), targetTableNames));
        }
        return result;
    }

    private Collection<CreateTableConfiguration> buildCreateTableConfigurations(MigrationJobConfiguration jobConfig, TableAndSchemaNameMapper mapper) {
        return jobConfig.getTablesFirstDataNodes().getEntries().stream().map(each -> this.getCreateTableConfiguration(jobConfig, mapper, (JobDataNodeEntry)each)).collect(Collectors.toList());
    }

    private CreateTableConfiguration getCreateTableConfiguration(MigrationJobConfiguration jobConfig, TableAndSchemaNameMapper mapper, JobDataNodeEntry jobDataNodeEntry) {
        DataNode dataNode = (DataNode)jobDataNodeEntry.getDataNodes().get(0);
        PipelineDataSourceConfiguration sourceDataSourceConfig = jobConfig.getSources().get(dataNode.getDataSourceName());
        String sourceSchemaName = mapper.getSchemaName(jobDataNodeEntry.getLogicTableName());
        String targetSchemaName = new DatabaseTypeRegistry(jobConfig.getTargetDatabaseType()).getDialectDatabaseMetaData().getSchemaOption().isSchemaAvailable() ? sourceSchemaName : null;
        return new CreateTableConfiguration(sourceDataSourceConfig, new QualifiedTable(sourceSchemaName, dataNode.getTableName()), jobConfig.getTarget(), new QualifiedTable(targetSchemaName, jobDataNodeEntry.getLogicTableName()));
    }

    private ImporterConfiguration buildImporterConfiguration(MigrationJobConfiguration jobConfig, PipelineProcessConfiguration pipelineProcessConfig, Map<ShardingSphereIdentifier, Collection<String>> tableAndRequiredColumnsMap, TableAndSchemaNameMapper mapper) {
        int batchSize = pipelineProcessConfig.getWrite().getBatchSize();
        JobRateLimitAlgorithm writeRateLimitAlgorithm = new TransmissionProcessContext(jobConfig.getJobId(), pipelineProcessConfig).getWriteRateLimitAlgorithm();
        int retryTimes = jobConfig.getRetryTimes();
        int concurrency = jobConfig.getConcurrency();
        return new ImporterConfiguration(jobConfig.getTarget(), tableAndRequiredColumnsMap, mapper, batchSize, writeRateLimitAlgorithm, retryTimes, concurrency);
    }

    public PipelineTasksRunner buildTasksRunner(MigrationJobItemContext jobItemContext) {
        return new TransmissionTasksRunner((TransmissionJobItemContext)jobItemContext);
    }

    public void prepare(MigrationJobItemContext jobItemContext) throws SQLException {
        new MigrationJobPreparer().prepare(jobItemContext);
    }
}

