/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.segment.select.pagination.engine;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.option.pagination.DialectPaginationOption;
import org.apache.shardingsphere.infra.binder.context.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.ExpressionExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.PaginationValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.rownum.ExpressionRowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.rownum.NumberLiteralRowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.rownum.ParameterMarkerRowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.rownum.RowNumberValueSegment;

public final class RowNumberPaginationContextEngine {
    private final DialectPaginationOption option;

    public PaginationContext createPaginationContext(Collection<ExpressionSegment> expressions, ProjectionsContext projectionsContext, List<Object> params) {
        Optional<String> rowNumberAlias = this.findRowNumberAlias(projectionsContext);
        if (!rowNumberAlias.isPresent()) {
            return new PaginationContext(null, null, params);
        }
        Collection allExpressions = expressions.stream().flatMap(each -> ExpressionExtractor.extractAllExpressions((ExpressionSegment)each).stream()).collect(Collectors.toList());
        Collection<BinaryOperationExpression> rowNumberExpressions = this.getRowNumberExpressions(allExpressions, rowNumberAlias.get());
        return rowNumberExpressions.isEmpty() ? new PaginationContext(null, null, params) : this.createPaginationWithRowNumber(rowNumberExpressions, params);
    }

    private Collection<BinaryOperationExpression> getRowNumberExpressions(Collection<ExpressionSegment> allExpressions, String rowNumberAlias) {
        LinkedList<BinaryOperationExpression> result = new LinkedList<BinaryOperationExpression>();
        for (ExpressionSegment each : allExpressions) {
            if (!this.isRowNumberColumn(each, rowNumberAlias) || !this.isCompareCondition(each)) continue;
            result.add((BinaryOperationExpression)each);
        }
        return result;
    }

    private Optional<String> findRowNumberAlias(ProjectionsContext projectionsContext) {
        String rowNumberColumnName = this.option.getRowNumberColumnName();
        if (Strings.isNullOrEmpty((String)rowNumberColumnName)) {
            return Optional.empty();
        }
        Optional<String> result = projectionsContext.findAlias(rowNumberColumnName);
        return result.isPresent() ? result : Optional.of(rowNumberColumnName);
    }

    private boolean isRowNumberColumn(ExpressionSegment predicate, String rowNumberAlias) {
        if (predicate instanceof BinaryOperationExpression) {
            ExpressionSegment left = ((BinaryOperationExpression)predicate).getLeft();
            if (left instanceof ColumnSegment) {
                String leftColumnValue = ((ColumnSegment)left).getIdentifier().getValue();
                return leftColumnValue.equalsIgnoreCase(this.option.getRowNumberColumnName()) || leftColumnValue.equalsIgnoreCase(rowNumberAlias);
            }
            return false;
        }
        return false;
    }

    private boolean isCompareCondition(ExpressionSegment predicate) {
        if (predicate instanceof BinaryOperationExpression) {
            String operator = ((BinaryOperationExpression)predicate).getOperator();
            return "<".equals(operator) || "<=".equals(operator) || ">".equals(operator) || ">=".equals(operator);
        }
        return false;
    }

    private PaginationContext createPaginationWithRowNumber(Collection<BinaryOperationExpression> rowNumberPredicates, List<Object> params) {
        RowNumberValueSegment offset = null;
        RowNumberValueSegment rowCount = null;
        for (BinaryOperationExpression each : rowNumberPredicates) {
            String operator;
            switch (operator = each.getOperator()) {
                case ">": {
                    offset = this.createRowNumberValueSegment(each.getRight(), false);
                    break;
                }
                case ">=": {
                    offset = this.createRowNumberValueSegment(each.getRight(), true);
                    break;
                }
                case "<": {
                    rowCount = this.createRowNumberValueSegment(each.getRight(), false);
                    break;
                }
                case "<=": {
                    rowCount = this.createRowNumberValueSegment(each.getRight(), true);
                    break;
                }
            }
        }
        return new PaginationContext((PaginationValueSegment)offset, (PaginationValueSegment)rowCount, params);
    }

    private RowNumberValueSegment createRowNumberValueSegment(ExpressionSegment expression, boolean boundOpened) {
        int startIndex = expression.getStartIndex();
        int stopIndex = expression.getStopIndex();
        if (expression instanceof LiteralExpressionSegment) {
            return new NumberLiteralRowNumberValueSegment(startIndex, stopIndex, Long.valueOf(Long.parseLong(((LiteralExpressionSegment)expression).getLiterals().toString())), boundOpened);
        }
        if (expression instanceof ParameterMarkerExpressionSegment) {
            return new ParameterMarkerRowNumberValueSegment(startIndex, stopIndex, ((ParameterMarkerExpressionSegment)expression).getParameterMarkerIndex(), boundOpened);
        }
        return new ExpressionRowNumberValueSegment(startIndex, stopIndex, expression, boundOpened);
    }

    @Generated
    public RowNumberPaginationContextEngine(DialectPaginationOption option) {
        this.option = option;
    }
}

