/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.statement.type.dml;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.database.exception.core.exception.syntax.database.NoDatabaseSelectedException;
import org.apache.shardingsphere.database.exception.core.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.ColumnAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.InsertStatement;

public final class InsertStatementBaseContext
implements SQLStatementContext {
    private final ShardingSphereMetaData metaData;
    private final ShardingSphereSchema schema;
    private final InsertStatement sqlStatement;
    private final TablesContext tablesContext;
    private final String currentDatabaseName;
    private final Map<String, Integer> insertColumnNamesAndIndexes;
    private final List<List<ExpressionSegment>> valueExpressions;
    private final List<String> columnNames;

    public InsertStatementBaseContext(InsertStatement sqlStatement, ShardingSphereMetaData metaData, String currentDatabaseName) {
        this.metaData = metaData;
        this.sqlStatement = sqlStatement;
        this.currentDatabaseName = currentDatabaseName;
        this.valueExpressions = this.getAllValueExpressions(sqlStatement);
        Collection<TableSegment> tableSegments = this.getAllSimpleTableSegments();
        this.tablesContext = new TablesContext(tableSegments);
        List insertColumnNames = this.getInsertColumnNames();
        this.schema = this.getSchema(metaData, currentDatabaseName);
        this.columnNames = this.containsInsertColumns() ? insertColumnNames : sqlStatement.getTable().map(optional -> this.schema.getVisibleColumnNames(optional.getTableName().getIdentifier().getValue())).orElseGet(Collections::emptyList);
        this.insertColumnNamesAndIndexes = this.createInsertColumnNamesAndIndexes(insertColumnNames);
    }

    private Map<String, Integer> createInsertColumnNamesAndIndexes(List<String> insertColumnNames) {
        if (this.containsInsertColumns()) {
            CaseInsensitiveMap result = new CaseInsensitiveMap(insertColumnNames.size(), 1.0f);
            int index = 0;
            for (String each : insertColumnNames) {
                result.put(each, index++);
            }
            return result;
        }
        return Collections.emptyMap();
    }

    private ShardingSphereSchema getSchema(ShardingSphereMetaData metaData, String currentDatabaseName) {
        String databaseName = this.tablesContext.getDatabaseName().orElse(currentDatabaseName);
        ShardingSpherePreconditions.checkNotNull((Object)databaseName, NoDatabaseSelectedException::new);
        ShardingSphereDatabase database = metaData.getDatabase(databaseName);
        ShardingSpherePreconditions.checkNotNull((Object)database, () -> new UnknownDatabaseException(databaseName));
        String defaultSchema = new DatabaseTypeRegistry(this.sqlStatement.getDatabaseType()).getDefaultSchemaName(databaseName);
        return this.tablesContext.getSchemaName().map(arg_0 -> ((ShardingSphereDatabase)database).getSchema(arg_0)).orElseGet(() -> database.getSchema(defaultSchema));
    }

    private Collection<TableSegment> getAllSimpleTableSegments() {
        TableExtractor tableExtractor = new TableExtractor();
        tableExtractor.extractTablesFromInsert(this.sqlStatement);
        return new LinkedList<TableSegment>(tableExtractor.getRewriteTables());
    }

    public Iterator<String> getDescendingColumnNames() {
        return new LinkedList<String>(this.columnNames).descendingIterator();
    }

    public boolean containsInsertColumns() {
        InsertStatement insertStatement = this.sqlStatement;
        return !insertStatement.getColumns().isEmpty() || insertStatement.getSetAssignment().isPresent();
    }

    public int getValueListCount() {
        InsertStatement insertStatement = this.sqlStatement;
        return insertStatement.getSetAssignment().isPresent() ? 1 : insertStatement.getValues().size();
    }

    public List<String> getInsertColumnNames() {
        return this.sqlStatement.getSetAssignment().map(this::getColumnNamesForSetAssignment).orElseGet(() -> this.getColumnNamesForInsertColumns(this.sqlStatement.getColumns()));
    }

    private List<String> getColumnNamesForSetAssignment(SetAssignmentSegment setAssignment) {
        LinkedList<String> result = new LinkedList<String>();
        for (ColumnAssignmentSegment each : setAssignment.getAssignments()) {
            result.add(((ColumnSegment)each.getColumns().get(0)).getIdentifier().getValue().toLowerCase());
        }
        return result;
    }

    private List<String> getColumnNamesForInsertColumns(Collection<ColumnSegment> columns) {
        LinkedList<String> result = new LinkedList<String>();
        for (ColumnSegment each : columns) {
            result.add(each.getIdentifier().getValue().toLowerCase());
        }
        return result;
    }

    private List<List<ExpressionSegment>> getAllValueExpressions(InsertStatement insertStatement) {
        Optional setAssignment = insertStatement.getSetAssignment();
        return setAssignment.map(optional -> Collections.singletonList(this.getAllValueExpressionsFromSetAssignment((SetAssignmentSegment)optional))).orElseGet(() -> this.getAllValueExpressionsFromValues(insertStatement.getValues()));
    }

    private List<ExpressionSegment> getAllValueExpressionsFromSetAssignment(SetAssignmentSegment setAssignment) {
        ArrayList<ExpressionSegment> result = new ArrayList<ExpressionSegment>(setAssignment.getAssignments().size());
        for (ColumnAssignmentSegment each : setAssignment.getAssignments()) {
            result.add(each.getValue());
        }
        return result;
    }

    private List<List<ExpressionSegment>> getAllValueExpressionsFromValues(Collection<InsertValuesSegment> values) {
        ArrayList<List<ExpressionSegment>> result = new ArrayList<List<ExpressionSegment>>(values.size());
        for (InsertValuesSegment each : values) {
            result.add(each.getValues());
        }
        return result;
    }

    @Generated
    public ShardingSphereMetaData getMetaData() {
        return this.metaData;
    }

    @Generated
    public ShardingSphereSchema getSchema() {
        return this.schema;
    }

    @Generated
    public InsertStatement getSqlStatement() {
        return this.sqlStatement;
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }

    @Generated
    public String getCurrentDatabaseName() {
        return this.currentDatabaseName;
    }

    @Generated
    public Map<String, Integer> getInsertColumnNamesAndIndexes() {
        return this.insertColumnNamesAndIndexes;
    }

    @Generated
    public List<List<ExpressionSegment>> getValueExpressions() {
        return this.valueExpressions;
    }

    @Generated
    public List<String> getColumnNames() {
        return this.columnNames;
    }
}

