/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.statement.ddl;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.type.SimpleTableSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementCopyUtils;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.AlterIndexStatement;

public final class AlterIndexStatementBinder
implements SQLStatementBinder<AlterIndexStatement> {
    @Override
    public AlterIndexStatement bind(AlterIndexStatement sqlStatement, SQLStatementBinderContext binderContext) {
        if (!sqlStatement.getSimpleTable().isPresent()) {
            return sqlStatement;
        }
        SimpleTableSegment boundTable = SimpleTableSegmentBinder.bind((SimpleTableSegment)sqlStatement.getSimpleTable().get(), binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)LinkedHashMultimap.create());
        return this.copy(sqlStatement, boundTable);
    }

    private AlterIndexStatement copy(AlterIndexStatement sqlStatement, SimpleTableSegment boundTable) {
        AlterIndexStatement result = new AlterIndexStatement(sqlStatement.getDatabaseType());
        sqlStatement.getIndex().ifPresent(arg_0 -> ((AlterIndexStatement)result).setIndex(arg_0));
        sqlStatement.getRenameIndex().ifPresent(arg_0 -> ((AlterIndexStatement)result).setRenameIndex(arg_0));
        result.setSimpleTable(boundTable);
        SQLStatementCopyUtils.copyAttributes((SQLStatement)sqlStatement, (SQLStatement)result);
        return result;
    }
}

