/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.mysql.packet.command.query.binary.execute.protocol;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.mysql.packet.command.query.binary.execute.protocol.MySQLBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLDateBinaryProtocolValue
implements MySQLBinaryProtocolValue {
    private static final long NANOS_PER_SECOND = 1000000000L;

    @Override
    public Object read(MySQLPacketPayload payload, boolean unsigned) throws SQLException {
        int length = payload.readInt1();
        switch (length) {
            case 0: {
                throw new SQLFeatureNotSupportedException("Can not support date format if year, month, day is absent.");
            }
            case 4: {
                return this.getTimestampForDate(payload);
            }
            case 7: {
                return this.getTimestampForDatetime(payload);
            }
            case 11: {
                Timestamp result = this.getTimestampForDatetime(payload);
                result.setNanos(payload.readInt4() * 1000);
                return result;
            }
        }
        throw new SQLFeatureNotSupportedException(String.format("Wrong length `%d` of MYSQL_TYPE_TIME", length));
    }

    private Timestamp getTimestampForDate(MySQLPacketPayload payload) {
        return Timestamp.valueOf(LocalDate.of(payload.readInt2(), payload.readInt1(), payload.readInt1()).atStartOfDay());
    }

    private Timestamp getTimestampForDatetime(MySQLPacketPayload payload) {
        return Timestamp.valueOf(LocalDateTime.of(payload.readInt2(), payload.readInt1(), payload.readInt1(), payload.readInt1(), payload.readInt1(), payload.readInt1()));
    }

    @Override
    public void write(MySQLPacketPayload payload, Object value) {
        boolean isNanosAbsent;
        LocalDateTime dateTime = value instanceof LocalDate ? ((LocalDate)value).atStartOfDay() : (value instanceof LocalDateTime ? (LocalDateTime)value : new Timestamp(((Date)value).getTime()).toLocalDateTime());
        DateTimeValues values = this.buildDateTimeValues(dateTime);
        boolean isTimeAbsent = 0 == values.hours && 0 == values.minutes && 0 == values.seconds;
        boolean bl = isNanosAbsent = 0 == values.nanos;
        if (isTimeAbsent && isNanosAbsent) {
            payload.writeInt1(4);
            this.writeDate(payload, values.year, values.month, values.dayOfMonth);
            return;
        }
        if (isNanosAbsent) {
            payload.writeInt1(7);
            this.writeDate(payload, values.year, values.month, values.dayOfMonth);
            this.writeTime(payload, values.hours, values.minutes, values.seconds);
            return;
        }
        payload.writeInt1(11);
        this.writeDate(payload, values.year, values.month, values.dayOfMonth);
        this.writeTime(payload, values.hours, values.minutes, values.seconds);
        this.writeNanos(payload, values.nanos);
    }

    private void writeDate(MySQLPacketPayload payload, int year, int month, int dayOfMonth) {
        payload.writeInt2(year);
        payload.writeInt1(month);
        payload.writeInt1(dayOfMonth);
    }

    private void writeTime(MySQLPacketPayload payload, int hourOfDay, int minutes, int seconds) {
        payload.writeInt1(hourOfDay);
        payload.writeInt1(minutes);
        payload.writeInt1(seconds);
    }

    private void writeNanos(MySQLPacketPayload payload, int nanos) {
        payload.writeInt4(nanos / 1000);
    }

    private DateTimeValues buildDateTimeValues(LocalDateTime dateTime) {
        int year = dateTime.getYear();
        int month = dateTime.getMonthValue();
        int dayOfMonth = dateTime.getDayOfMonth();
        int hours = dateTime.getHour();
        int minutes = dateTime.getMinute();
        int seconds = dateTime.getSecond();
        int nanos = dateTime.getNano();
        if ((long)nanos >= 1000000000L) {
            long overflowNanos = nanos;
            seconds = (int)((long)seconds + overflowNanos / 1000000000L);
            nanos = (int)(overflowNanos % 1000000000L);
            if (seconds >= 60) {
                LocalDateTime normalized = dateTime.plusSeconds(seconds - dateTime.getSecond());
                year = normalized.getYear();
                month = normalized.getMonthValue();
                dayOfMonth = normalized.getDayOfMonth();
                hours = normalized.getHour();
                minutes = normalized.getMinute();
                seconds = normalized.getSecond();
            }
        }
        return new DateTimeValues(year, month, dayOfMonth, hours, minutes, seconds, nanos);
    }

    private static class DateTimeValues {
        private final int year;
        private final int month;
        private final int dayOfMonth;
        private final int hours;
        private final int minutes;
        private final int seconds;
        private final int nanos;

        @Generated
        public DateTimeValues(int year, int month, int dayOfMonth, int hours, int minutes, int seconds, int nanos) {
            this.year = year;
            this.month = month;
            this.dayOfMonth = dayOfMonth;
            this.hours = hours;
            this.minutes = minutes;
            this.seconds = seconds;
            this.nanos = nanos;
        }
    }
}

