/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.segment.generic;

import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.statement.core.segment.SQLSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;

public final class PivotSegment
implements SQLSegment {
    private final int startIndex;
    private final int stopIndex;
    private final Collection<ColumnSegment> pivotForColumns;
    private final Collection<ColumnSegment> pivotInColumns;
    private final boolean isUnPivot;
    private Collection<ColumnSegment> unpivotColumns;

    public PivotSegment(int startIndex, int stopIndex, Collection<ColumnSegment> pivotForColumns, Collection<ColumnSegment> pivotInColumns) {
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.pivotForColumns = pivotForColumns;
        this.pivotInColumns = pivotInColumns;
        this.isUnPivot = false;
    }

    public Collection<String> getPivotColumnNames() {
        HashSet<ColumnSegment> result = new HashSet<ColumnSegment>(this.pivotInColumns);
        result.addAll(this.pivotForColumns);
        if (null != this.unpivotColumns) {
            result.addAll(this.unpivotColumns);
        }
        return result.stream().map(each -> each.getIdentifier().getValue()).collect(Collectors.toList());
    }

    @Generated
    public PivotSegment(int startIndex, int stopIndex, Collection<ColumnSegment> pivotForColumns, Collection<ColumnSegment> pivotInColumns, boolean isUnPivot) {
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.pivotForColumns = pivotForColumns;
        this.pivotInColumns = pivotInColumns;
        this.isUnPivot = isUnPivot;
    }

    @Override
    @Generated
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    @Generated
    public int getStopIndex() {
        return this.stopIndex;
    }

    @Generated
    public Collection<ColumnSegment> getPivotForColumns() {
        return this.pivotForColumns;
    }

    @Generated
    public Collection<ColumnSegment> getPivotInColumns() {
        return this.pivotInColumns;
    }

    @Generated
    public boolean isUnPivot() {
        return this.isUnPivot;
    }

    @Generated
    public Collection<ColumnSegment> getUnpivotColumns() {
        return this.unpivotColumns;
    }

    @Generated
    public void setUnpivotColumns(Collection<ColumnSegment> unpivotColumns) {
        this.unpivotColumns = unpivotColumns;
    }
}

