/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.SQLStatementAttributes;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.TableSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.UpdateStatement;

public final class PrepareStatement
extends DDLStatement {
    private SelectStatement select;
    private InsertStatement insert;
    private UpdateStatement update;
    private DeleteStatement delete;
    private SQLStatementAttributes attributes;

    public PrepareStatement(DatabaseType databaseType) {
        super(databaseType);
    }

    public Optional<SelectStatement> getSelect() {
        return Optional.ofNullable(this.select);
    }

    public Optional<InsertStatement> getInsert() {
        return Optional.ofNullable(this.insert);
    }

    public Optional<UpdateStatement> getUpdate() {
        return Optional.ofNullable(this.update);
    }

    public Optional<DeleteStatement> getDelete() {
        return Optional.ofNullable(this.delete);
    }

    @Override
    public void buildAttributes() {
        TableExtractor tableExtractor = new TableExtractor();
        Optional.ofNullable(this.select).ifPresent(tableExtractor::extractTablesFromSelect);
        Optional.ofNullable(this.insert).ifPresent(tableExtractor::extractTablesFromInsert);
        Optional.ofNullable(this.update).ifPresent(tableExtractor::extractTablesFromUpdate);
        Optional.ofNullable(this.delete).ifPresent(tableExtractor::extractTablesFromDelete);
        this.attributes = new SQLStatementAttributes(new TableSQLStatementAttribute(tableExtractor.getRewriteTables()));
    }

    @Override
    @Generated
    public SQLStatementAttributes getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setSelect(SelectStatement select) {
        this.select = select;
    }

    @Generated
    public void setInsert(InsertStatement insert) {
        this.insert = insert;
    }

    @Generated
    public void setUpdate(UpdateStatement update) {
        this.update = update;
    }

    @Generated
    public void setDelete(DeleteStatement delete) {
        this.delete = delete;
    }

    @Generated
    public void setAttributes(SQLStatementAttributes attributes) {
        this.attributes = attributes;
    }
}

