/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.firebird.authentication;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.netty.channel.ChannelHandlerContext;
import java.util.Arrays;
import java.util.Optional;
import org.apache.shardingsphere.authentication.AuthenticatorFactory;
import org.apache.shardingsphere.authentication.AuthenticatorType;
import org.apache.shardingsphere.authentication.result.AuthenticationResult;
import org.apache.shardingsphere.authentication.result.AuthenticationResultBuilder;
import org.apache.shardingsphere.authority.rule.AuthorityRule;
import org.apache.shardingsphere.database.exception.core.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.database.protocol.constant.CommonConstants;
import org.apache.shardingsphere.database.protocol.firebird.constant.FirebirdAuthenticationMethod;
import org.apache.shardingsphere.database.protocol.firebird.constant.FirebirdConstant;
import org.apache.shardingsphere.database.protocol.firebird.constant.protocol.FirebirdConnectionProtocolVersion;
import org.apache.shardingsphere.database.protocol.firebird.exception.FirebirdProtocolException;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.FirebirdCommandPacketType;
import org.apache.shardingsphere.database.protocol.firebird.packet.generic.FirebirdGenericResponsePacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.handshake.FirebirdAcceptPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.handshake.FirebirdAttachPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.handshake.FirebirdConnectPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.handshake.FirebirdSRPAuthenticationData;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;
import org.apache.shardingsphere.database.protocol.payload.PacketPayload;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.firebird.handler.admin.executor.variable.charset.FirebirdCharacterSets;
import org.apache.shardingsphere.proxy.frontend.authentication.AuthenticationEngine;
import org.apache.shardingsphere.proxy.frontend.connection.ConnectionIdGenerator;
import org.apache.shardingsphere.proxy.frontend.firebird.authentication.authenticator.FirebirdAuthenticatorType;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.blob.FirebirdBlobIdGenerator;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.blob.upload.FirebirdBlobUploadCache;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.statement.FirebirdStatementIdGenerator;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.statement.fetch.FirebirdFetchStatementCache;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.transaction.FirebirdTransactionIdGenerator;

public final class FirebirdAuthenticationEngine
implements AuthenticationEngine {
    private FirebirdSRPAuthenticationData authData;
    private AuthenticationResult currentAuthResult;
    private int connectionId;

    public int handshake(ChannelHandlerContext context) {
        this.connectionId = ConnectionIdGenerator.getInstance().nextId();
        FirebirdTransactionIdGenerator.getInstance().registerConnection(this.connectionId);
        FirebirdStatementIdGenerator.getInstance().registerConnection(this.connectionId);
        FirebirdBlobIdGenerator.getInstance().registerConnection(this.connectionId);
        FirebirdBlobUploadCache.getInstance().registerConnection(this.connectionId);
        FirebirdFetchStatementCache.getInstance().registerConnection(this.connectionId);
        return this.connectionId;
    }

    public AuthenticationResult authenticate(ChannelHandlerContext context, PacketPayload payload) {
        payload.getByteBuf().resetReaderIndex();
        AuthorityRule rule = (AuthorityRule)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getSingleRule(AuthorityRule.class);
        FirebirdPacketPayload fdbPacketPayload = (FirebirdPacketPayload)payload;
        FirebirdCommandPacketType type = FirebirdCommandPacketType.valueOf((int)fdbPacketPayload.readInt4());
        switch (type) {
            case CONNECT: {
                return this.processConnect(context, fdbPacketPayload, rule);
            }
            case ATTACH: {
                return this.processAttach(context, fdbPacketPayload, rule);
            }
        }
        throw new FirebirdProtocolException("Wrong operation %s during authentication phase", new Object[]{type.name()});
    }

    private AuthenticationResult processAttach(ChannelHandlerContext context, FirebirdPacketPayload payload, AuthorityRule rule) {
        FirebirdAttachPacket attachPacket = new FirebirdAttachPacket(payload);
        context.channel().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).set((Object)FirebirdCharacterSets.findCharacterSet((String)attachPacket.getEncoding()));
        this.login(this.currentAuthResult.getDatabase(), this.currentAuthResult.getUsername(), attachPacket, rule);
        context.writeAndFlush((Object)new FirebirdGenericResponsePacket());
        return AuthenticationResultBuilder.finished((String)this.currentAuthResult.getUsername(), (String)"", (String)this.currentAuthResult.getDatabase());
    }

    private void login(String databaseName, String username, FirebirdAttachPacket attachPacket, AuthorityRule rule) {
        ShardingSpherePreconditions.checkState((Strings.isNullOrEmpty((String)databaseName) || ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().containsDatabase(databaseName) ? 1 : 0) != 0, () -> new UnknownDatabaseException(databaseName));
        Grantee grantee = new Grantee(username, "");
        Optional user = rule.findUser(grantee);
        user.ifPresent(shardingSphereUser -> new AuthenticatorFactory(FirebirdAuthenticatorType.class, rule).newInstance(shardingSphereUser).authenticate(shardingSphereUser, new Object[]{attachPacket.getEncPassword(), this.authData, attachPacket.getAuthData()}));
    }

    private AuthenticationResult processConnect(ChannelHandlerContext context, FirebirdPacketPayload payload, AuthorityRule rule) {
        FirebirdConnectPacket connectPacket = new FirebirdConnectPacket(payload);
        FirebirdAcceptPacket acceptPacket = new FirebirdAcceptPacket(connectPacket.getUserProtocols());
        context.channel().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).set((Object)FirebirdCharacterSets.findCharacterSet((String)"NONE"));
        FirebirdConnectionProtocolVersion.getInstance().setProtocolVersion(this.connectionId, acceptPacket.getProtocol().getVersion());
        context.channel().attr(FirebirdConstant.CONNECTION_PROTOCOL_VERSION).set((Object)acceptPacket.getProtocol().getVersion());
        String username = connectPacket.getLogin();
        Grantee grantee = new Grantee(username, "");
        Optional user = rule.findUser(grantee);
        Preconditions.checkState((boolean)user.isPresent());
        FirebirdAuthenticationMethod plugin = FirebirdAuthenticationMethod.valueOf((String)this.getPluginName(rule, (ShardingSphereUser)user.get()));
        FirebirdAuthenticationMethod userPlugin = connectPacket.getPlugin();
        if (plugin != userPlugin) {
            acceptPacket.setAcceptDataPacket(new byte[0], "", plugin, 0, "");
        } else if (plugin != FirebirdAuthenticationMethod.LEGACY_AUTH) {
            this.authData = new FirebirdSRPAuthenticationData(plugin.getHashAlgorithm(), username, ((ShardingSphereUser)user.get()).getPassword(), connectPacket.getAuthData());
            acceptPacket.setAcceptDataPacket(this.authData.getSalt(), this.authData.getPublicKeyHex(), plugin, 0, "");
        }
        context.writeAndFlush((Object)acceptPacket);
        this.currentAuthResult = AuthenticationResultBuilder.continued((String)username, (String)connectPacket.getHost(), (String)connectPacket.getDatabase());
        return this.currentAuthResult;
    }

    private String getPluginName(AuthorityRule rule, ShardingSphereUser user) {
        String pluginName = rule.getAuthenticatorType(user);
        return pluginName.isEmpty() ? Arrays.stream((FirebirdAuthenticatorType[])FirebirdAuthenticatorType.class.getEnumConstants()).filter(AuthenticatorType::isDefault).findAny().orElseThrow(IllegalArgumentException::new).name() : pluginName;
    }
}

