/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.executor.engine.pushdown.raw;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.driver.jdbc.core.resultset.ShardingSphereResultSetFactory;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.connection.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupReportContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.RawExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.RawSQLExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.callback.RawSQLExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.raw.RawExecutionPrepareEngine;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;

public final class DriverRawPushDownExecuteQueryExecutor {
    private final ConnectionContext connectionContext;
    private final String processId;
    private final ShardingSphereMetaData metaData;
    private final ConfigurationProperties props;
    private final RawExecutor rawExecutor;

    public DriverRawPushDownExecuteQueryExecutor(ShardingSphereConnection connection, ShardingSphereMetaData metaData, RawExecutor rawExecutor) {
        this.connectionContext = connection.getDatabaseConnectionManager().getConnectionContext();
        this.processId = connection.getProcessId();
        this.metaData = metaData;
        this.props = metaData.getProps();
        this.rawExecutor = rawExecutor;
    }

    public ResultSet executeQuery(ShardingSphereDatabase database, QueryContext queryContext, Statement statement, Map<String, Integer> columnLabelAndIndexMap) throws SQLException {
        List<QueryResult> queryResults = this.getQueryResults(database, queryContext);
        return new ShardingSphereResultSetFactory(this.connectionContext, this.metaData, this.props, Collections.emptyList()).newInstance(database, queryContext, queryResults, statement, columnLabelAndIndexMap);
    }

    private List<QueryResult> getQueryResults(ShardingSphereDatabase database, QueryContext queryContext) throws SQLException {
        ExecutionContext executionContext = new KernelProcessor().generateExecutionContext(queryContext, this.metaData.getGlobalRuleMetaData(), this.props);
        return this.rawExecutor.execute(this.createRawExecutionGroupContext(database, executionContext), queryContext, new RawSQLExecutorCallback()).stream().map(QueryResult.class::cast).collect(Collectors.toList());
    }

    private ExecutionGroupContext<RawSQLExecutionUnit> createRawExecutionGroupContext(ShardingSphereDatabase database, ExecutionContext executionContext) throws SQLException {
        int maxConnectionsSizePerQuery = (Integer)this.props.getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        return new RawExecutionPrepareEngine(maxConnectionsSizePerQuery, database.getRuleMetaData().getRules()).prepare(database.getName(), executionContext, executionContext.getExecutionUnits(), new ExecutionGroupReportContext(this.processId, database.getName(), this.connectionContext.getGrantee()));
    }
}

