/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import com.cedarsoftware.util.CaseInsensitiveSet;
import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.type.DatabaseRuleDropExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorCurrentRuleRequired;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.InUsedRuleException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableReferenceRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.handler.update.UnusedAlgorithmFinder;
import org.apache.shardingsphere.sharding.distsql.statement.DropShardingTableRuleStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

@DistSQLExecutorCurrentRuleRequired(value=ShardingRule.class)
public final class DropShardingTableRuleExecutor
implements DatabaseRuleDropExecutor<DropShardingTableRuleStatement, ShardingRule, ShardingRuleConfiguration> {
    private ShardingSphereDatabase database;
    private ShardingRule rule;

    public void checkBeforeUpdate(DropShardingTableRuleStatement sqlStatement) {
        if (!sqlStatement.isIfExists()) {
            this.checkToBeDroppedShardingTableNames(sqlStatement);
        }
        if (null != this.rule) {
            this.checkBindingTables(sqlStatement);
        }
    }

    private void checkToBeDroppedShardingTableNames(DropShardingTableRuleStatement sqlStatement) {
        Collection<String> currentShardingTableNames = this.getCurrentShardingTableNames();
        Collection notExistedTableNames = this.getToBeDroppedShardingTableNames(sqlStatement).stream().filter(each -> !currentShardingTableNames.contains(each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkMustEmpty((Collection)notExistedTableNames, () -> new MissingRequiredRuleException("sharding", this.database.getName(), notExistedTableNames));
    }

    private Collection<String> getToBeDroppedShardingTableNames(DropShardingTableRuleStatement sqlStatement) {
        return sqlStatement.getTableNames().stream().map(each -> each.getIdentifier().getValue()).collect(Collectors.toList());
    }

    private Collection<String> getCurrentShardingTableNames() {
        CaseInsensitiveSet result = new CaseInsensitiveSet();
        result.addAll(this.rule.getConfiguration().getTables().stream().map(ShardingTableRuleConfiguration::getLogicTable).collect(Collectors.toList()));
        result.addAll(this.rule.getConfiguration().getAutoTables().stream().map(ShardingAutoTableRuleConfiguration::getLogicTable).collect(Collectors.toList()));
        return result;
    }

    private void checkBindingTables(DropShardingTableRuleStatement sqlStatement) {
        Collection<String> bindingTables = this.getBindingTables();
        Collection usedTableNames = this.getToBeDroppedShardingTableNames(sqlStatement).stream().filter(bindingTables::contains).collect(Collectors.toList());
        if (!usedTableNames.isEmpty()) {
            throw new InUsedRuleException("Sharding", this.database.getName(), usedTableNames, "sharding table reference");
        }
    }

    private Collection<String> getBindingTables() {
        CaseInsensitiveSet result = new CaseInsensitiveSet();
        this.rule.getConfiguration().getBindingTableGroups().forEach(arg_0 -> DropShardingTableRuleExecutor.lambda$getBindingTables$3((Collection)result, arg_0));
        return result;
    }

    public boolean hasAnyOneToBeDropped(DropShardingTableRuleStatement sqlStatement) {
        LinkedList currentTableNames = new LinkedList();
        currentTableNames.addAll(this.rule.getConfiguration().getTables().stream().map(ShardingTableRuleConfiguration::getLogicTable).collect(Collectors.toSet()));
        currentTableNames.addAll(this.rule.getConfiguration().getAutoTables().stream().map(ShardingAutoTableRuleConfiguration::getLogicTable).collect(Collectors.toSet()));
        return !Collections.disjoint(currentTableNames, sqlStatement.getTableNames().stream().map(each -> each.getIdentifier().getValue()).collect(Collectors.toSet()));
    }

    public ShardingRuleConfiguration buildToBeDroppedRuleConfiguration(DropShardingTableRuleStatement sqlStatement) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        Collection<String> toBeDroppedShardingTableNames = this.getToBeDroppedShardingTableNames(sqlStatement);
        for (String each2 : toBeDroppedShardingTableNames) {
            result.getTables().addAll(this.rule.getConfiguration().getTables().stream().filter(table -> each2.equalsIgnoreCase(table.getLogicTable())).collect(Collectors.toList()));
            result.getAutoTables().addAll(this.rule.getConfiguration().getAutoTables().stream().filter(table -> each2.equalsIgnoreCase(table.getLogicTable())).collect(Collectors.toList()));
            this.dropShardingTable(this.rule.getConfiguration(), each2);
        }
        UnusedAlgorithmFinder.findUnusedShardingAlgorithm(this.rule.getConfiguration()).forEach(each -> result.getShardingAlgorithms().put(each, (AlgorithmConfiguration)this.rule.getConfiguration().getShardingAlgorithms().get(each)));
        UnusedAlgorithmFinder.findUnusedKeyGenerator(this.rule.getConfiguration()).forEach(each -> result.getKeyGenerators().put(each, (AlgorithmConfiguration)this.rule.getConfiguration().getKeyGenerators().get(each)));
        UnusedAlgorithmFinder.findUnusedAuditor(this.rule.getConfiguration()).forEach(each -> result.getAuditors().put(each, (AlgorithmConfiguration)this.rule.getConfiguration().getAuditors().get(each)));
        return result;
    }

    private void dropShardingTable(ShardingRuleConfiguration currentRuleConfig, String tableName) {
        currentRuleConfig.getTables().removeAll(currentRuleConfig.getTables().stream().filter(each -> tableName.equalsIgnoreCase(each.getLogicTable())).collect(Collectors.toList()));
        currentRuleConfig.getAutoTables().removeAll(currentRuleConfig.getAutoTables().stream().filter(each -> tableName.equalsIgnoreCase(each.getLogicTable())).collect(Collectors.toList()));
    }

    public Class<ShardingRule> getRuleClass() {
        return ShardingRule.class;
    }

    public Class<DropShardingTableRuleStatement> getType() {
        return DropShardingTableRuleStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(ShardingRule rule) {
        this.rule = rule;
    }

    private static /* synthetic */ void lambda$getBindingTables$3(Collection result, ShardingTableReferenceRuleConfiguration each) {
        result.addAll(Splitter.on((String)",").splitToList((CharSequence)each.getReference()));
    }
}

