/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.config;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlGlobalRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.proxy.backend.config.YamlProxyConfiguration;
import org.apache.shardingsphere.proxy.backend.config.checker.YamlProxyConfigurationChecker;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyDatabaseConfiguration;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyServerConfiguration;

public final class ProxyConfigurationLoader {
    private static final String GLOBAL_CONFIG_FILE = "global.yaml";
    private static final Pattern DATABASE_CONFIG_FILE_PATTERN = Pattern.compile("database-.+\\.yaml");
    @Deprecated
    private static final String COMPATIBLE_GLOBAL_CONFIG_FILE = "server.yaml";
    @Deprecated
    private static final Pattern COMPATIBLE_DATABASE_CONFIG_FILE_PATTERN = Pattern.compile("config-.+\\.yaml");

    public static YamlProxyConfiguration load(String path) throws IOException {
        YamlProxyServerConfiguration serverConfig = ProxyConfigurationLoader.loadServerConfiguration(ProxyConfigurationLoader.getGlobalConfigFile(path));
        File configPath = ProxyConfigurationLoader.getResourceFile(path);
        Collection<YamlProxyDatabaseConfiguration> databaseConfigs = ProxyConfigurationLoader.loadDatabaseConfigurations(configPath);
        YamlProxyConfigurationChecker.checkDataSources(serverConfig.getDataSources(), databaseConfigs);
        return new YamlProxyConfiguration(serverConfig, databaseConfigs.stream().collect(Collectors.toMap(YamlProxyDatabaseConfiguration::getDatabaseName, each -> each, (oldValue, currentValue) -> oldValue, LinkedHashMap::new)));
    }

    private static File getGlobalConfigFile(String path) {
        File result = ProxyConfigurationLoader.getResourceFile(String.join((CharSequence)"/", path, GLOBAL_CONFIG_FILE));
        return result.exists() ? result : ProxyConfigurationLoader.getResourceFile(String.join((CharSequence)"/", path, COMPATIBLE_GLOBAL_CONFIG_FILE));
    }

    private static File getResourceFile(String path) {
        URL url = ProxyConfigurationLoader.class.getResource(path);
        return null == url ? new File(path) : new File(url.toURI().getPath());
    }

    private static YamlProxyServerConfiguration loadServerConfiguration(File yamlFile) throws IOException {
        YamlProxyServerConfiguration result = (YamlProxyServerConfiguration)YamlEngine.unmarshal((File)yamlFile, YamlProxyServerConfiguration.class);
        return ProxyConfigurationLoader.rebuildGlobalRuleConfiguration(result);
    }

    private static YamlProxyServerConfiguration rebuildGlobalRuleConfiguration(YamlProxyServerConfiguration serverConfig) {
        serverConfig.getRules().removeIf(YamlGlobalRuleConfiguration.class::isInstance);
        if (null != serverConfig.getAuthority()) {
            serverConfig.getRules().add((YamlRuleConfiguration)serverConfig.getAuthority());
        }
        if (null != serverConfig.getTransaction()) {
            serverConfig.getRules().add((YamlRuleConfiguration)serverConfig.getTransaction());
        }
        if (null != serverConfig.getGlobalClock()) {
            serverConfig.getRules().add((YamlRuleConfiguration)serverConfig.getGlobalClock());
        }
        if (null != serverConfig.getSqlParser()) {
            serverConfig.getRules().add((YamlRuleConfiguration)serverConfig.getSqlParser());
        }
        if (null != serverConfig.getSqlTranslator()) {
            serverConfig.getRules().add((YamlRuleConfiguration)serverConfig.getSqlTranslator());
        }
        if (null != serverConfig.getSqlFederation()) {
            serverConfig.getRules().add((YamlRuleConfiguration)serverConfig.getSqlFederation());
        }
        return serverConfig;
    }

    private static Collection<YamlProxyDatabaseConfiguration> loadDatabaseConfigurations(File configPath) throws IOException {
        File[] ruleConfigFiles = ProxyConfigurationLoader.findRuleConfigurationFiles(configPath);
        HashSet loadedDatabaseNames = new HashSet(ruleConfigFiles.length);
        LinkedList<YamlProxyDatabaseConfiguration> result = new LinkedList<YamlProxyDatabaseConfiguration>();
        for (File each : ruleConfigFiles) {
            ProxyConfigurationLoader.loadDatabaseConfiguration(each).ifPresent(optional -> {
                Preconditions.checkState((boolean)loadedDatabaseNames.add(optional.getDatabaseName()), (String)"Database name `%s` must unique at all database configurations.", (Object)optional.getDatabaseName());
                result.add((YamlProxyDatabaseConfiguration)optional);
            });
        }
        return result;
    }

    private static Optional<YamlProxyDatabaseConfiguration> loadDatabaseConfiguration(File yamlFile) throws IOException {
        YamlProxyDatabaseConfiguration result = (YamlProxyDatabaseConfiguration)YamlEngine.unmarshal((File)yamlFile, YamlProxyDatabaseConfiguration.class);
        if (result.isEmpty()) {
            return Optional.empty();
        }
        Preconditions.checkNotNull((Object)result.getDatabaseName(), (String)"Property `databaseName` in file `%s` is required.", (Object)yamlFile.getName());
        ProxyConfigurationLoader.checkDuplicateRule(result.getRules(), yamlFile);
        return Optional.of(result);
    }

    private static void checkDuplicateRule(Collection<YamlRuleConfiguration> ruleConfigs, File yamlFile) {
        if (ruleConfigs.isEmpty()) {
            return;
        }
        Map<Class, Long> ruleConfigTypeCountMap = ruleConfigs.stream().collect(Collectors.groupingBy(YamlRuleConfiguration::getRuleConfigurationType, Collectors.counting()));
        Optional<Map.Entry> duplicateRuleConfig = ruleConfigTypeCountMap.entrySet().stream().filter(each -> (Long)each.getValue() > 1L).findFirst();
        if (duplicateRuleConfig.isPresent()) {
            throw new IllegalStateException(String.format("Duplicate rule tag `!%s` in file `%s`", ProxyConfigurationLoader.getDuplicateRuleTagName((Class)duplicateRuleConfig.get().getKey()), yamlFile.getName()));
        }
    }

    private static Object getDuplicateRuleTagName(Class<? extends RuleConfiguration> ruleConfigClass) {
        Optional<YamlRuleConfigurationSwapper> result = ShardingSphereServiceLoader.getServiceInstances(YamlRuleConfigurationSwapper.class).stream().filter(each -> ruleConfigClass.equals(each.getTypeClass())).findFirst();
        return result.orElseThrow(() -> new IllegalStateException("Not find rule tag name of class " + ruleConfigClass));
    }

    private static File[] findRuleConfigurationFiles(File path) {
        return path.listFiles(each -> DATABASE_CONFIG_FILE_PATTERN.matcher(each.getName()).matches() || COMPATIBLE_DATABASE_CONFIG_FILE_PATTERN.matcher(each.getName()).matches());
    }

    @Generated
    private ProxyConfigurationLoader() {
    }
}

