/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql;

import java.sql.SQLException;
import org.apache.shardingsphere.distsql.handler.engine.DistSQLConnectionContext;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecuteEngine;
import org.apache.shardingsphere.distsql.statement.DistSQLStatement;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DatabaseConnectionManager;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.handler.distsql.DistSQLProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public final class DistSQLUpdateProxyBackendHandler
implements DistSQLProxyBackendHandler {
    private final DistSQLStatement sqlStatement;
    private final DistSQLUpdateExecuteEngine engine;

    public DistSQLUpdateProxyBackendHandler(DistSQLStatement sqlStatement, QueryContext queryContext, ConnectionSession connectionSession, ContextManager contextManager) {
        this.sqlStatement = sqlStatement;
        DistSQLConnectionContext distsqlConnectionContext = new DistSQLConnectionContext(queryContext, connectionSession.getDatabaseConnectionManager().getConnectionSize(), connectionSession.getProtocolType(), (DatabaseConnectionManager)connectionSession.getDatabaseConnectionManager(), connectionSession.getStatementManager());
        this.engine = new DistSQLUpdateExecuteEngine(sqlStatement, connectionSession.getUsedDatabaseName(), contextManager, distsqlConnectionContext);
    }

    @Override
    public ResponseHeader execute() throws SQLException {
        this.engine.executeUpdate();
        return new UpdateResponseHeader((SQLStatement)this.sqlStatement);
    }
}

