/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.updatable.imports;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.statement.type.ral.updatable.ImportDatabaseConfigurationStatement;
import org.apache.shardingsphere.infra.exception.generic.FileIOException;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyDatabaseConfiguration;
import org.apache.shardingsphere.proxy.backend.util.MetaDataImportExecutor;

public final class ImportDatabaseConfigurationExecutor
implements DistSQLUpdateExecutor<ImportDatabaseConfigurationStatement> {
    public void executeUpdate(ImportDatabaseConfigurationStatement sqlStatement, ContextManager contextManager) {
        YamlProxyDatabaseConfiguration yamlConfig = this.getYamlProxyDatabaseConfiguration(sqlStatement);
        new MetaDataImportExecutor(contextManager).importDatabaseConfigurations(Collections.singletonList(yamlConfig));
    }

    private YamlProxyDatabaseConfiguration getYamlProxyDatabaseConfiguration(ImportDatabaseConfigurationStatement sqlStatement) {
        File file = new File(sqlStatement.getFilePath());
        try {
            return (YamlProxyDatabaseConfiguration)YamlEngine.unmarshal((File)file, YamlProxyDatabaseConfiguration.class);
        }
        catch (IOException ignore) {
            throw new FileIOException(file);
        }
    }

    public Class<ImportDatabaseConfigurationStatement> getType() {
        return ImportDatabaseConfigurationStatement.class;
    }
}

