/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.opengauss.err;

import com.google.common.base.Strings;
import java.sql.SQLException;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.exception.core.SQLExceptionTransformEngine;
import org.apache.shardingsphere.database.exception.postgresql.vendor.PostgreSQLVendorError;
import org.apache.shardingsphere.database.protocol.opengauss.packet.command.generic.OpenGaussErrorResponsePacket;
import org.apache.shardingsphere.infra.exception.external.sql.sqlstate.XOpenSQLState;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.opengauss.util.PSQLException;
import org.opengauss.util.ServerErrorMessage;

public final class OpenGaussErrorPacketFactory {
    private static final DatabaseType DATABASE_TYPE = (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"PostgreSQL");

    public static OpenGaussErrorResponsePacket newInstance(Exception cause) {
        Optional<ServerErrorMessage> serverErrorMessage = OpenGaussErrorPacketFactory.findServerErrorMessage(cause);
        return serverErrorMessage.map(OpenGaussErrorResponsePacket::new).orElseGet(() -> OpenGaussErrorPacketFactory.createErrorResponsePacket(SQLExceptionTransformEngine.toSQLException((Exception)cause, (DatabaseType)DATABASE_TYPE)));
    }

    private static Optional<ServerErrorMessage> findServerErrorMessage(Exception cause) {
        return cause instanceof PSQLException ? Optional.ofNullable(((PSQLException)cause).getServerErrorMessage()) : Optional.empty();
    }

    private static OpenGaussErrorResponsePacket createErrorResponsePacket(SQLException cause) {
        String sqlState = Strings.isNullOrEmpty((String)cause.getSQLState()) || XOpenSQLState.GENERAL_ERROR.getValue().equals(cause.getSQLState()) ? PostgreSQLVendorError.SYSTEM_ERROR.getSqlState().getValue() : cause.getSQLState();
        String message = Strings.isNullOrEmpty((String)cause.getMessage()) ? cause.toString() : cause.getMessage();
        return new OpenGaussErrorResponsePacket("ERROR", sqlState, message);
    }

    @Generated
    private OpenGaussErrorPacketFactory() {
    }
}

