/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.algorithm.assisted;

import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithmMetaData;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.context.AlgorithmSQLContext;
import org.apache.shardingsphere.infra.algorithm.messagedigest.spi.MessageDigestAlgorithm;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.infra.util.props.PropertiesBuilder;

public final class MD5AssistedEncryptAlgorithm
implements EncryptAlgorithm {
    private static final String SALT_KEY = "salt";
    private final EncryptAlgorithmMetaData metaData = new EncryptAlgorithmMetaData(false, true, false);
    private Properties props;
    private MessageDigestAlgorithm digestAlgorithm;

    public void init(Properties props) {
        this.props = props;
        this.digestAlgorithm = (MessageDigestAlgorithm)TypedSPILoader.getService(MessageDigestAlgorithm.class, (Object)this.getType(), (Properties)props);
    }

    public String encrypt(Object plainValue, AlgorithmSQLContext algorithmSQLContext) {
        return this.digestAlgorithm.digest(plainValue);
    }

    public Object decrypt(Object cipherValue, AlgorithmSQLContext algorithmSQLContext) {
        throw new UnsupportedOperationException(String.format("Algorithm `%s` is unsupported to decrypt", this.getType()));
    }

    public AlgorithmConfiguration toConfiguration() {
        return new AlgorithmConfiguration(this.getType(), PropertiesBuilder.build((PropertiesBuilder.Property[])new PropertiesBuilder.Property[]{new PropertiesBuilder.Property(SALT_KEY, (Object)this.props.getProperty(SALT_KEY, ""))}));
    }

    public String getType() {
        return "MD5";
    }

    @Generated
    public EncryptAlgorithmMetaData getMetaData() {
        return this.metaData;
    }
}

