/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.engine.processor.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableInterpretable;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.runtime.Bindable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.DialectDatabaseMetaData;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereStatistics;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sqlfederation.compiler.SQLFederationExecutionPlan;
import org.apache.shardingsphere.sqlfederation.compiler.context.CompilerContext;
import org.apache.shardingsphere.sqlfederation.compiler.exception.SQLFederationSchemaNotFoundException;
import org.apache.shardingsphere.sqlfederation.compiler.implementor.ScanImplementor;
import org.apache.shardingsphere.sqlfederation.compiler.metadata.schema.SQLFederationTable;
import org.apache.shardingsphere.sqlfederation.compiler.rel.converter.SQLFederationRelConverter;
import org.apache.shardingsphere.sqlfederation.context.SQLFederationContext;
import org.apache.shardingsphere.sqlfederation.engine.processor.SQLFederationProcessor;
import org.apache.shardingsphere.sqlfederation.executor.context.ExecutorBindContext;
import org.apache.shardingsphere.sqlfederation.executor.context.ExecutorContext;
import org.apache.shardingsphere.sqlfederation.executor.enumerable.implementor.EnumerableScanImplementor;
import org.apache.shardingsphere.sqlfederation.resultset.SQLFederationResultSet;

public final class StandardSQLFederationProcessor
implements SQLFederationProcessor {
    private final ShardingSphereStatistics statistics;
    private final JDBCExecutor jdbcExecutor;
    private ExecutorContext executorContext;

    @Override
    public void prepare(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutorCallback<? extends ExecuteResult> queryCallback, String currentDatabaseName, String currentSchemaName, SQLFederationContext federationContext, CompilerContext compilerContext, SchemaPlus schemaPlus) {
        if (null == schemaPlus) {
            return;
        }
        this.executorContext = new ExecutorContext(prepareEngine, this.jdbcExecutor, queryCallback, this.statistics, currentDatabaseName, currentSchemaName, federationContext.isPreview(), federationContext.getProcessId());
        EnumerableScanImplementor scanImplementor = new EnumerableScanImplementor(federationContext.getQueryContext(), compilerContext, this.executorContext);
        SQLStatementContext sqlStatementContext = federationContext.getQueryContext().getSqlStatementContext();
        Collection simpleTables = sqlStatementContext.getTablesContext().getSimpleTables();
        for (SimpleTableSegment each : simpleTables) {
            Table table = this.getTable(currentDatabaseName, currentSchemaName, schemaPlus, each, sqlStatementContext.getSqlStatement().getDatabaseType(), federationContext.getQueryContext().getSql());
            if (!(table instanceof SQLFederationTable)) continue;
            ((SQLFederationTable)table).setScanImplementor((ScanImplementor)scanImplementor);
        }
    }

    private Table getTable(String currentDatabaseName, String currentSchemaName, SchemaPlus schemaPlus, SimpleTableSegment tableSegment, DatabaseType databaseType, String sql) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
        String originalDatabase = tableSegment.getTableName().getTableBoundInfo().map(optional -> optional.getOriginalDatabase().getValue()).orElse(currentDatabaseName);
        String originalScheme = tableSegment.getTableName().getTableBoundInfo().map(optional -> optional.getOriginalSchema().getValue()).orElse(currentSchemaName);
        SchemaPlus currentSchemaPlus = dialectDatabaseMetaData.getSchemaOption().getDefaultSchema().isPresent() ? this.getNestedSchemaPlus(schemaPlus, originalDatabase, originalScheme, sql) : this.getSchemaPlus(schemaPlus, originalDatabase, sql);
        return (Table)currentSchemaPlus.tables().get(tableSegment.getTableName().getIdentifier().getValue());
    }

    private SchemaPlus getNestedSchemaPlus(SchemaPlus schemaPlus, String databaseName, String schemaName, String sql) {
        SchemaPlus databaseSchema = this.getSchemaPlus(schemaPlus, databaseName, sql);
        return this.getSchemaPlus(databaseSchema, schemaName, sql);
    }

    private SchemaPlus getSchemaPlus(SchemaPlus schemaPlus, String schemaName, String sql) {
        SchemaPlus result = (SchemaPlus)schemaPlus.subSchemas().get(schemaName);
        ShardingSpherePreconditions.checkNotNull((Object)result, () -> new SQLFederationSchemaNotFoundException(schemaName, sql));
        return result;
    }

    @Override
    public void release(String currentDatabaseName, String currentSchemaName, QueryContext queryContext, SchemaPlus schemaPlus) {
        Collection simpleTables = queryContext.getSqlStatementContext().getTablesContext().getSimpleTables();
        for (SimpleTableSegment each : simpleTables) {
            Table table = this.getTable(currentDatabaseName, currentSchemaName, schemaPlus, each, queryContext.getSqlStatementContext().getSqlStatement().getDatabaseType(), queryContext.getSql());
            if (!(table instanceof SQLFederationTable)) continue;
            ((SQLFederationTable)table).clearScanImplementor();
        }
    }

    @Override
    public ResultSet executePlan(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutorCallback<? extends ExecuteResult> queryCallback, SQLFederationExecutionPlan executionPlan, SQLFederationRelConverter converter, SQLFederationContext federationContext, SchemaPlus schemaPlus) {
        Bindable executablePlan = EnumerableInterpretable.toBindable(Collections.emptyMap(), null, (EnumerableRel)((EnumerableRel)executionPlan.getPhysicalPlan()), (EnumerableRel.Prefer)EnumerableRel.Prefer.ARRAY);
        Map<String, Object> params = this.createParameters(federationContext.getQueryContext().getParameters());
        Enumerator enumerator = executablePlan.bind((DataContext)new ExecutorBindContext(converter, params)).enumerator();
        SelectStatementContext selectStatementContext = (SelectStatementContext)federationContext.getQueryContext().getSqlStatementContext();
        List expandProjections = selectStatementContext.getProjectionsContext().getExpandProjections();
        SQLFederationResultSet result = new SQLFederationResultSet(enumerator, (Schema)schemaPlus, expandProjections, selectStatementContext.getSqlStatement().getDatabaseType(), executionPlan.getResultColumnType(), federationContext.getProcessId());
        if (federationContext.isPreview()) {
            federationContext.getPreviewExecutionUnits().addAll(this.executorContext.getPreviewExecutionUnits());
        }
        return result;
    }

    private Map<String, Object> createParameters(List<Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>(params.size(), 1.0f);
        int index = 0;
        for (Object each : params) {
            result.put("?" + index++, each);
        }
        return result;
    }

    @Override
    public Convention getConvention() {
        return EnumerableConvention.INSTANCE;
    }

    @Generated
    public StandardSQLFederationProcessor(ShardingSphereStatistics statistics, JDBCExecutor jdbcExecutor) {
        this.statistics = statistics;
        this.jdbcExecutor = jdbcExecutor;
    }
}

