/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.firebird.handler.admin.executor.variable.charset;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.apache.shardingsphere.database.exception.core.exception.data.InvalidParameterValueException;
import org.apache.shardingsphere.proxy.backend.firebird.handler.admin.executor.variable.charset.FirebirdCharacterSets;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.variable.charset.CharsetVariableProvider;

public final class FirebirdCharsetVariableProvider
implements CharsetVariableProvider {
    public Collection<String> getCharsetVariables() {
        return Collections.singleton("names");
    }

    public Charset parseCharset(String variableValue) {
        String formattedValue = variableValue.trim().toLowerCase(Locale.ROOT);
        try {
            return "default".equals(formattedValue) ? Charset.defaultCharset() : FirebirdCharacterSets.findCharacterSet(formattedValue);
        }
        catch (IllegalArgumentException ignored) {
            throw new InvalidParameterValueException("names", formattedValue);
        }
    }

    public String getDatabaseType() {
        return "Firebird";
    }
}

