/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.select;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.exception.core.exception.syntax.database.NoDatabaseSelectedException;
import org.apache.shardingsphere.database.exception.core.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.engine.SQLBindEngine;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.EmptyStorageUnitException;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultColumnMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.type.RawMemoryQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.type.memory.row.MemoryQueryResultDataRow;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.hint.SQLHintUtils;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.transparent.TransparentMergedResult;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.proxy.backend.connector.DatabaseProxyConnector;
import org.apache.shardingsphere.proxy.backend.connector.DatabaseProxyConnectorFactory;
import org.apache.shardingsphere.proxy.backend.connector.ProxyDatabaseConnectionManager;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;

public final class UnicastResourceShowExecutor
implements DatabaseAdminQueryExecutor {
    private final SelectStatement sqlStatement;
    private final String sql;
    private DatabaseProxyConnector databaseProxyConnector;
    private ResponseHeader responseHeader;
    private MergedResult mergedResult;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ConnectionSession connectionSession, ShardingSphereMetaData metaData) throws SQLException {
        String originDatabase = connectionSession.getUsedDatabaseName();
        String databaseName = null == originDatabase ? this.getFirstDatabaseName(metaData) : originDatabase;
        ShardingSpherePreconditions.checkState((boolean)metaData.containsDatabase(databaseName), () -> new UnknownDatabaseException(databaseName));
        ShardingSpherePreconditions.checkState((boolean)metaData.getDatabase(databaseName).containsDataSource(), () -> new EmptyStorageUnitException(databaseName));
        HintValueContext hintValueContext = SQLHintUtils.extractHint((String)this.sql);
        try {
            connectionSession.setCurrentDatabaseName(databaseName);
            SQLStatementContext sqlStatementContext = new SQLBindEngine(metaData, connectionSession.getCurrentDatabaseName(), hintValueContext).bind((SQLStatement)this.sqlStatement);
            this.databaseProxyConnector = DatabaseProxyConnectorFactory.newInstance((QueryContext)new QueryContext(sqlStatementContext, this.sql, Collections.emptyList(), hintValueContext, connectionSession.getConnectionContext(), metaData), (ProxyDatabaseConnectionManager)connectionSession.getDatabaseConnectionManager(), (boolean)false);
            this.responseHeader = this.databaseProxyConnector.execute();
            this.mergedResult = new TransparentMergedResult(this.createQueryResult());
        }
        finally {
            connectionSession.setCurrentDatabaseName(originDatabase);
            this.databaseProxyConnector.close();
        }
    }

    private String getFirstDatabaseName(ShardingSphereMetaData metaData) {
        Collection databases = metaData.getAllDatabases();
        if (databases.isEmpty()) {
            throw new NoDatabaseSelectedException();
        }
        Optional<ShardingSphereDatabase> result = databases.stream().filter(ShardingSphereDatabase::containsDataSource).findFirst();
        ShardingSpherePreconditions.checkState((boolean)result.isPresent(), EmptyStorageUnitException::new);
        return result.get().getName();
    }

    public QueryResultMetaData getQueryResultMetaData() {
        List columns = ((QueryResponseHeader)this.responseHeader).getQueryHeaders().stream().map(QueryHeader::getColumnLabel).map(each -> new RawQueryResultColumnMetaData("", each, each, 12, "VARCHAR", 100, 0)).collect(Collectors.toList());
        return new RawQueryResultMetaData(columns);
    }

    private QueryResult createQueryResult() throws SQLException {
        LinkedList<MemoryQueryResultDataRow> rows = new LinkedList<MemoryQueryResultDataRow>();
        while (this.databaseProxyConnector.next()) {
            List data = this.databaseProxyConnector.getRowData().getData();
            rows.add(new MemoryQueryResultDataRow(data));
        }
        return new RawMemoryQueryResult(this.getQueryResultMetaData(), rows);
    }

    @Generated
    public UnicastResourceShowExecutor(SelectStatement sqlStatement, String sql) {
        this.sqlStatement = sqlStatement;
        this.sql = sql;
    }

    @Generated
    public MergedResult getMergedResult() {
        return this.mergedResult;
    }
}

