/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.calcite.linq4j.Nullness;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class TryThreadLocal<T>
extends ThreadLocal<T> {
    public static <S> TryThreadLocal<S> of(S initialValue) {
        return new FixedTryThreadLocal<S>(initialValue);
    }

    public static <S> TryThreadLocal<@NonNull S> ofNonNull(S initialValue) {
        return new NonNullFixedTryThreadLocal(Objects.requireNonNull(initialValue, "initialValue"));
    }

    public static <S> TryThreadLocal<@NonNull S> withInitial(Supplier<? extends @NonNull S> supplier) {
        return new SuppliedTryThreadLocal<S>(supplier);
    }

    @Override
    public T get() {
        return (T)Nullness.castNonNull(super.get());
    }

    public Memo push(T value) {
        T previous = this.get();
        this.set(value);
        return () -> this.restoreTo(previous);
    }

    protected abstract void restoreTo(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void letIn(T t, Runnable runnable) {
        T previous = this.get();
        if (previous == t) {
            runnable.run();
        } else {
            try {
                this.set(t);
                runnable.run();
            }
            finally {
                this.restoreTo(previous);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R letIn(T t, Supplier<R> supplier) {
        T previous = this.get();
        if (previous == t) {
            return supplier.get();
        }
        try {
            this.set(t);
            R r = supplier.get();
            return r;
        }
        finally {
            this.restoreTo(previous);
        }
    }

    private static class SuppliedTryThreadLocal<T>
    extends TryThreadLocal<T> {
        private final Supplier<? extends @NonNull T> supplier;

        SuppliedTryThreadLocal(Supplier<? extends @NonNull T> supplier) {
            this.supplier = Objects.requireNonNull(supplier, "supplier");
        }

        @Override
        protected @NonNull T initialValue() {
            return Objects.requireNonNull(this.supplier.get(), "supplier returned null");
        }

        @Override
        public void set(@Nullable T value) {
            super.set(Objects.requireNonNull(value, "value"));
        }

        @Override
        protected void restoreTo(T previous) {
            this.set(previous);
        }
    }

    private static class NonNullFixedTryThreadLocal<T>
    extends FixedTryThreadLocal<T> {
        private NonNullFixedTryThreadLocal(T initialValue) {
            super(Objects.requireNonNull(initialValue, "initialValue"));
        }

        @Override
        public void set(@Nullable T value) {
            super.set(Objects.requireNonNull(value, "value"));
        }

        @Override
        public T get() {
            return Objects.requireNonNull(super.get());
        }
    }

    private static class FixedTryThreadLocal<T>
    extends TryThreadLocal<T> {
        private final T initialValue;

        protected FixedTryThreadLocal(T initialValue) {
            this.initialValue = initialValue;
        }

        @Override
        protected final T initialValue() {
            return this.initialValue;
        }

        @Override
        protected void restoreTo(T previous) {
            if (previous == this.initialValue) {
                this.remove();
            } else {
                this.set(previous);
            }
        }
    }

    public static interface Memo
    extends AutoCloseable {
        @Override
        public void close();
    }
}

