/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.sharding;

import org.apache.shardingsphere.data.pipeline.core.datasource.yaml.PipelineYamlRuleConfigurationReviser;
import org.apache.shardingsphere.infra.algorithm.core.yaml.YamlAlgorithmConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.YamlShardingRuleConfiguration;

public final class ShardingPipelineYamlRuleConfigurationReviser
implements PipelineYamlRuleConfigurationReviser<YamlShardingRuleConfiguration> {
    public void revise(YamlShardingRuleConfiguration yamlRuleConfig) {
        this.enableRangeQueryForInline(yamlRuleConfig);
        this.removeAuditStrategy(yamlRuleConfig);
    }

    private void enableRangeQueryForInline(YamlShardingRuleConfiguration yamlRuleConfig) {
        for (YamlAlgorithmConfiguration each : yamlRuleConfig.getShardingAlgorithms().values()) {
            if (!"INLINE".equalsIgnoreCase(each.getType()) && !"COMPLEX_INLINE".equalsIgnoreCase(each.getType())) continue;
            each.getProps().setProperty("allow-range-query-with-inline-sharding", Boolean.TRUE.toString());
        }
    }

    private void removeAuditStrategy(YamlShardingRuleConfiguration yamlRuleConfig) {
        yamlRuleConfig.setDefaultAuditStrategy(null);
        yamlRuleConfig.setAuditors(null);
        if (null != yamlRuleConfig.getTables()) {
            yamlRuleConfig.getTables().forEach((key, value) -> value.setAuditStrategy(null));
        }
        if (null != yamlRuleConfig.getAutoTables()) {
            yamlRuleConfig.getAutoTables().forEach((key, value) -> value.setAuditStrategy(null));
        }
    }

    public int getOrder() {
        return 0;
    }

    public Class<YamlShardingRuleConfiguration> getTypeClass() {
        return YamlShardingRuleConfiguration.class;
    }
}

