/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.constant.protocol;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public enum FirebirdProtocolVersion {
    PROTOCOL_VERSION10(10),
    PROTOCOL_VERSION11(32779),
    PROTOCOL_VERSION12(32780),
    PROTOCOL_VERSION13(32781),
    PROTOCOL_VERSION14(32782),
    PROTOCOL_VERSION15(32783),
    PROTOCOL_VERSION16(32784),
    PROTOCOL_VERSION17(32785),
    PROTOCOL_VERSION18(32786),
    PROTOCOL_VERSION19(32787);

    private static final Map<Integer, FirebirdProtocolVersion> FIREBIRD_PROTOCOL_VERSION_CACHE;
    private static final int FB_PROTOCOL_FLAG = 32768;
    private static final int FB_PROTOCOL_MASK = Short.MAX_VALUE;
    private final int code;

    public static FirebirdProtocolVersion valueOf(int code) {
        FirebirdProtocolVersion result = FIREBIRD_PROTOCOL_VERSION_CACHE.get(code);
        Preconditions.checkNotNull((Object)((Object)result), (String)"Cannot find '%s' in arch type", (int)code);
        return result;
    }

    @Generated
    private FirebirdProtocolVersion(int code) {
        this.code = code;
    }

    @Generated
    public int getCode() {
        return this.code;
    }

    static {
        FIREBIRD_PROTOCOL_VERSION_CACHE = new HashMap<Integer, FirebirdProtocolVersion>();
        for (FirebirdProtocolVersion each : FirebirdProtocolVersion.values()) {
            FIREBIRD_PROTOCOL_VERSION_CACHE.put(each.code, each);
        }
    }
}

