/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.type.sql;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public enum FirebirdSQLInfoReturnValue {
    SELECT(1, true, true),
    INSERT(2, false, true),
    UPDATE(3, false, true),
    DELETE(4, false, true),
    DDL(5),
    GET_SEGMENT(6),
    PUT_SEGMENT(7),
    EXEC_PROCEDURE(8, true, true),
    START_TRANS(9),
    COMMIT(10),
    ROLLBACK(11),
    SELECT_FOR_UPD(12),
    SET_GENERATOR(13),
    SAVEPOINT(14);

    private static final Map<Integer, FirebirdSQLInfoReturnValue> FIREBIRD_DATABASE_INFO_RETURN_VALUES_CACHE;
    private final int code;
    private final boolean selectDescribable;
    private final boolean bindDescribable;

    private FirebirdSQLInfoReturnValue(int code) {
        this.code = code;
        this.selectDescribable = false;
        this.bindDescribable = false;
    }

    public static FirebirdSQLInfoReturnValue valueOf(int code) {
        return FIREBIRD_DATABASE_INFO_RETURN_VALUES_CACHE.get(code);
    }

    @Generated
    private FirebirdSQLInfoReturnValue(int code, boolean selectDescribable, boolean bindDescribable) {
        this.code = code;
        this.selectDescribable = selectDescribable;
        this.bindDescribable = bindDescribable;
    }

    @Generated
    public int getCode() {
        return this.code;
    }

    @Generated
    public boolean isSelectDescribable() {
        return this.selectDescribable;
    }

    @Generated
    public boolean isBindDescribable() {
        return this.bindDescribable;
    }

    static {
        FIREBIRD_DATABASE_INFO_RETURN_VALUES_CACHE = new HashMap<Integer, FirebirdSQLInfoReturnValue>();
        for (FirebirdSQLInfoReturnValue each : FirebirdSQLInfoReturnValue.values()) {
            FIREBIRD_DATABASE_INFO_RETURN_VALUES_CACHE.put(each.code, each);
        }
    }
}

