/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mask.distsql.handler.update;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.type.DatabaseRuleAlterExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorCurrentRuleRequired;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.mask.config.MaskRuleConfiguration;
import org.apache.shardingsphere.mask.config.rule.MaskColumnRuleConfiguration;
import org.apache.shardingsphere.mask.config.rule.MaskTableRuleConfiguration;
import org.apache.shardingsphere.mask.distsql.handler.converter.MaskRuleStatementConverter;
import org.apache.shardingsphere.mask.distsql.segment.MaskRuleSegment;
import org.apache.shardingsphere.mask.distsql.statement.AlterMaskRuleStatement;
import org.apache.shardingsphere.mask.rule.MaskRule;

@DistSQLExecutorCurrentRuleRequired(value=MaskRule.class)
public final class AlterMaskRuleExecutor
implements DatabaseRuleAlterExecutor<AlterMaskRuleStatement, MaskRule, MaskRuleConfiguration> {
    private ShardingSphereDatabase database;
    private MaskRule rule;

    public void checkBeforeUpdate(AlterMaskRuleStatement sqlStatement) {
        this.checkToBeAlteredRules(sqlStatement);
    }

    private void checkToBeAlteredRules(AlterMaskRuleStatement sqlStatement) {
        Collection currentMaskTableNames = this.rule.getConfiguration().getTables().stream().map(MaskTableRuleConfiguration::getName).collect(Collectors.toList());
        Collection notExistedMaskTableNames = this.getToBeAlteredMaskTableNames(sqlStatement).stream().filter(each -> !currentMaskTableNames.contains(each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkMustEmpty((Collection)notExistedMaskTableNames, () -> new MissingRequiredRuleException("Mask", this.database.getName(), notExistedMaskTableNames));
    }

    private Collection<String> getToBeAlteredMaskTableNames(AlterMaskRuleStatement sqlStatement) {
        return sqlStatement.getRules().stream().map(MaskRuleSegment::getTableName).collect(Collectors.toList());
    }

    public MaskRuleConfiguration buildToBeAlteredRuleConfiguration(AlterMaskRuleStatement sqlStatement) {
        return MaskRuleStatementConverter.convert(sqlStatement.getRules());
    }

    public MaskRuleConfiguration buildToBeDroppedRuleConfiguration(MaskRuleConfiguration toBeAlteredRuleConfig) {
        Collection toBeAlteredTableNames = toBeAlteredRuleConfig.getTables().stream().map(MaskTableRuleConfiguration::getName).collect(Collectors.toList());
        Collection columns = this.rule.getConfiguration().getTables().stream().filter(each -> !toBeAlteredTableNames.contains(each.getName())).flatMap(each -> each.getColumns().stream()).collect(Collectors.toList());
        columns.addAll(toBeAlteredRuleConfig.getTables().stream().flatMap(each -> each.getColumns().stream()).collect(Collectors.toList()));
        Collection inUsedAlgorithmNames = columns.stream().map(MaskColumnRuleConfiguration::getMaskAlgorithm).collect(Collectors.toSet());
        HashMap<String, AlgorithmConfiguration> toBeDroppedAlgorithms = new HashMap<String, AlgorithmConfiguration>(this.rule.getConfiguration().getMaskAlgorithms().size(), 1.0f);
        for (String each2 : this.rule.getConfiguration().getMaskAlgorithms().keySet()) {
            if (inUsedAlgorithmNames.contains(each2)) continue;
            toBeDroppedAlgorithms.put(each2, (AlgorithmConfiguration)this.rule.getConfiguration().getMaskAlgorithms().get(each2));
        }
        return new MaskRuleConfiguration(Collections.emptyList(), toBeDroppedAlgorithms);
    }

    public Class<MaskRule> getRuleClass() {
        return MaskRule.class;
    }

    public Class<AlterMaskRuleStatement> getType() {
        return AlterMaskRuleStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(MaskRule rule) {
        this.rule = rule;
    }
}

