/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.oracle.metadata.database.option;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.option.schema.DefaultSchemaOption;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.option.schema.DialectSchemaOption;

public final class OracleSchemaOption
implements DialectSchemaOption {
    private final DialectSchemaOption delegate = new DefaultSchemaOption(false, null);

    public boolean isSchemaAvailable() {
        return this.delegate.isSchemaAvailable();
    }

    public String getSchema(Connection connection) {
        try {
            return Optional.ofNullable(connection.getMetaData().getUserName()).map(String::toUpperCase).orElse(null);
        }
        catch (SQLException ignored) {
            return null;
        }
    }

    public Optional<String> getDefaultSchema() {
        return this.delegate.getDefaultSchema();
    }

    public Optional<String> getDefaultSystemSchema() {
        return this.delegate.getDefaultSystemSchema();
    }
}

