/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import java.util.LinkedList;
import java.util.List;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import org.apache.sling.testing.mock.jcr.MockNodeDefinitionTemplate;
import org.apache.sling.testing.mock.jcr.MockPropertyDefinitionTemplate;

class MockNodeTypeTemplate
implements NodeTypeTemplate {
    private String name;
    private String[] superTypeNames;
    private String primaryItemName;
    private boolean abstractStatus;
    private boolean queryable;
    private boolean mixin;
    private boolean orderableChildNodes;
    private List<NodeDefinitionTemplate> nodeDefinitionTemplates;
    private List<PropertyDefinitionTemplate> propertyDefinitionTemplates;

    public MockNodeTypeTemplate() {
    }

    public MockNodeTypeTemplate(NodeTypeDefinition def, NodeTypeManager ntMgr) {
        PropertyDefinition[] propDefs;
        this.name = def.getName();
        this.superTypeNames = def.getDeclaredSupertypeNames();
        this.primaryItemName = def.getPrimaryItemName();
        this.abstractStatus = def.isAbstract();
        this.mixin = def.isMixin();
        this.queryable = def.isQueryable();
        this.orderableChildNodes = def.hasOrderableChildNodes();
        NodeDefinition[] nodeDefs = def.getDeclaredChildNodeDefinitions();
        if (nodeDefs != null) {
            List<NodeDefinitionTemplate> list = this.getNodeDefinitionTemplates();
            for (NodeDefinition nodeDef : nodeDefs) {
                list.add(new MockNodeDefinitionTemplate(this.name, ntMgr, nodeDef));
            }
        }
        if ((propDefs = def.getDeclaredPropertyDefinitions()) != null) {
            List<PropertyDefinitionTemplate> list = this.getPropertyDefinitionTemplates();
            for (PropertyDefinition propDef : propDefs) {
                list.add(new MockPropertyDefinitionTemplate(this.name, ntMgr, propDef));
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String[] getDeclaredSupertypeNames() {
        return this.superTypeNames;
    }

    public boolean isAbstract() {
        return this.abstractStatus;
    }

    public boolean isMixin() {
        return this.mixin;
    }

    public boolean hasOrderableChildNodes() {
        return this.orderableChildNodes;
    }

    public boolean isQueryable() {
        return this.queryable;
    }

    public String getPrimaryItemName() {
        return this.primaryItemName;
    }

    public PropertyDefinition[] getDeclaredPropertyDefinitions() {
        if (this.propertyDefinitionTemplates == null) {
            return null;
        }
        return this.propertyDefinitionTemplates.toArray(new PropertyDefinition[this.propertyDefinitionTemplates.size()]);
    }

    public NodeDefinition[] getDeclaredChildNodeDefinitions() {
        if (this.nodeDefinitionTemplates == null) {
            return null;
        }
        return this.nodeDefinitionTemplates.toArray(new NodeDefinition[this.nodeDefinitionTemplates.size()]);
    }

    public void setName(String name) throws ConstraintViolationException {
        this.name = name;
    }

    public void setDeclaredSuperTypeNames(String[] names) throws ConstraintViolationException {
        this.superTypeNames = names;
    }

    public void setAbstract(boolean abstractStatus) {
        this.abstractStatus = abstractStatus;
    }

    public void setMixin(boolean mixin) {
        this.mixin = mixin;
    }

    public void setOrderableChildNodes(boolean orderable) {
        this.orderableChildNodes = orderable;
    }

    public void setPrimaryItemName(String name) throws ConstraintViolationException {
        this.primaryItemName = name;
    }

    public void setQueryable(boolean queryable) {
        this.queryable = queryable;
    }

    public List<PropertyDefinitionTemplate> getPropertyDefinitionTemplates() {
        if (this.propertyDefinitionTemplates == null) {
            this.propertyDefinitionTemplates = new LinkedList<PropertyDefinitionTemplate>();
        }
        return this.propertyDefinitionTemplates;
    }

    public List<NodeDefinitionTemplate> getNodeDefinitionTemplates() {
        if (this.nodeDefinitionTemplates == null) {
            this.nodeDefinitionTemplates = new LinkedList<NodeDefinitionTemplate>();
        }
        return this.nodeDefinitionTemplates;
    }
}

