/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.impl.AbstractContextDescriptor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tools.registry.ToolsRegistry;
import org.jkiss.utils.CommonUtils;

public class ToolGroupDescriptor
extends AbstractContextDescriptor {
    private final String id;
    private final String label;
    private final String description;
    private final DBPImage icon;
    private final ToolGroupDescriptor parent;

    public ToolGroupDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.icon = this.iconToImage(config.getAttribute("icon"));
        String parentId = config.getAttribute("parent");
        this.parent = CommonUtils.isEmpty((String)parentId) ? null : ToolsRegistry.getInstance().getToolGroup(parentId);
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public ToolGroupDescriptor getParent() {
        return this.parent;
    }

    @Nullable
    protected Object adaptType(@NotNull DBPObject object) {
        if (object instanceof DBSObject) {
            return ((DBSObject)object).getDataSource();
        }
        return super.adaptType(object);
    }
}

