define(["exports","./events.js","./../common/servicelocator.js","./../common/querystring.js","./../common/qualitydetection.js"],function(_exports,_events,_servicelocator,_querystring,_qualitydetection){var globalize,userSettings;function loadGlobalize(){return globalize?Promise.resolve(globalize):Emby.importModule("./modules/common/globalize.js").then(function(globalizeModule){return globalize=globalizeModule})}function loadUserSettings(){return userSettings?Promise.resolve(userSettings):Emby.importModule("./modules/common/usersettings/usersettings.js").then(function(userSettingsModule){return userSettings=userSettingsModule})}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;function isLocalId(str){return str&&str.startsWith("local")}function isNotLocalId(id){return!isLocalId(id)}function replaceAll(originalString,strReplace,strWith){strReplace=new RegExp(strReplace,"ig");return originalString.replace(strReplace,strWith)}function getFetchPromise(instance,request,signal){var err,fetchRequest,timeoutSignal;return signal&&signal.aborted?Promise.reject(((err=new Error("AbortError")).name="AbortError",err)):(err=request.headers||{},"json"===request.dataType&&(err.accept="application/json"),fetchRequest={headers:err,method:request.type,credentials:"same-origin"},request.timeout&&(timeoutSignal=AbortSignal.timeout(request.timeout),signal=signal?AbortSignal.any([signal,timeoutSignal]):timeoutSignal),signal&&(fetchRequest.signal=signal),timeoutSignal=request.contentType,request.data&&("string"==typeof request.data?fetchRequest.body=request.data:(fetchRequest.body=_querystring.default.paramsToString(request.data),timeoutSignal=timeoutSignal||"application/x-www-form-urlencoded; charset=UTF-8")),signal=request.url,"application/json"===timeoutSignal&&(timeoutSignal="text/plain",signal=signal+(signal.includes("?")?"&":"?")+"reqformat=json"),timeoutSignal&&(err["Content-Type"]=timeoutSignal),fetch(signal,fetchRequest))}function setServerAddress(instance,address){instance._serverAddress=address,_events.default.trigger(instance,"serveraddresschanged",[{apiClient:instance,address:address}])}function onNetworkChanged(instance,resetAddress){resetAddress&&(instance.connected=!1,(resetAddress=getAddresses(instance.serverInfo())).length)&&setServerAddress(instance,resetAddress[0].url),instance._endPointInfo=null}function getAddresses(serverInfo){var address,addresses=[],addressesStrings=[];return!serverInfo.ManualAddress||!(address=serverInfo.ManualAddress).includes("://127.0.0.1")&&!address.toLowerCase().includes("://localhost")||addressesStrings.includes(serverInfo.ManualAddress.toLowerCase())||(addresses.push({url:serverInfo.ManualAddress}),addressesStrings.push(addresses[addresses.length-1].url.toLowerCase())),serverInfo.LocalAddress&&!addressesStrings.includes(serverInfo.LocalAddress.toLowerCase())&&(addresses.push({url:serverInfo.LocalAddress}),addressesStrings.push(addresses[addresses.length-1].url.toLowerCase())),serverInfo.ManualAddress&&!addressesStrings.includes(serverInfo.ManualAddress.toLowerCase())&&(addresses.push({url:serverInfo.ManualAddress}),addressesStrings.push(addresses[addresses.length-1].url.toLowerCase())),serverInfo.RemoteAddress&&!addressesStrings.includes(serverInfo.RemoteAddress.toLowerCase())&&(addresses.push({url:serverInfo.RemoteAddress}),addressesStrings.push(addresses[addresses.length-1].url.toLowerCase())),console.log("getAddresses: "+addressesStrings.join("|")),addresses}function setTimeoutPromise(timeout){return new Promise(function(resolve){setTimeout(resolve,timeout)})}function tryReconnectInternal(instance,signal){var addresses=getAddresses(instance.serverInfo());if(!addresses.length)return Promise.reject();if(1===addresses.length)return Promise.resolve(addresses[0].url);for(var abortController=new AbortController,boundAbort=abortController.abort.bind(abortController),promises=(signal&&signal.addEventListener("abort",boundAbort),signal=abortController.signal,[]),i=0,length=addresses.length;i<length;i++)promises.push(function(instance,url,delay,signal){return console.log("tryReconnectToUrl: "+url),setTimeoutPromise(delay).then(function(){return getFetchPromise(0,{url:instance.getUrl("system/info/public",null,url),type:"GET",dataType:"json",timeout:15e3},signal).then(function(){return url})})}(instance,addresses[i].url,200*i,signal));return Promise.any(promises).then(function(url){return instance.serverAddress(url),abortController.abort(),Promise.resolve(url)})}function tryReconnect(instance,signal,argument_2){var retryCount=2<arguments.length&&void 0!==argument_2?argument_2:0,promise=tryReconnectInternal(instance,signal);return 2<=retryCount?promise:promise.catch(function(err){return console.log("error in tryReconnectInternal: "+(err||"")),setTimeoutPromise(500).then(function(){return tryReconnect(instance,signal,retryCount+1)})})}function getUserCacheKey(userId,serverId){return"user-"+userId+"-"+serverId}function getCachedUser(instance,userId){instance=instance.serverId();return instance&&(userId=_servicelocator.appStorage.getItem(getUserCacheKey(userId,instance)))?((userId=JSON.parse(userId))&&setUserProperties(userId,instance),userId):null}function saveUserInCache(instance,user,forceSave){setUserProperties(user,instance.serverId()),(forceSave||function(instance,userId){var _instance$_serverInfo;if(instance._userAuthInfo){for(var allUsers=(null==(_instance$_serverInfo=instance._serverInfo)?void 0:_instance$_serverInfo.Users)||[],i=0,length=allUsers.length;i<length;i++)if(allUsers[i].UserId===userId)return 1;return userId===instance.getCurrentUserId()}}(instance,user.Id))&&(user.DateLastFetched=Date.now(),_servicelocator.appStorage.setItem(getUserCacheKey(user.Id,user.ServerId),JSON.stringify(user)))}function updateCachedUser(instance,userId){return instance.getUser(userId,!1)}var messageIdsReceived={};function onMessageReceivedInternal(instance,msg){var messageId=msg.MessageId;if(messageId){if(messageIdsReceived[messageId])return;messageIdsReceived[messageId]=!0}var user,messageId=msg.MessageType;"UserUpdated"===messageId||"UserConfigurationUpdated"===messageId||"UserPolicyUpdated"===messageId?(user=msg.Data).Id===instance.getCurrentUserId()&&(saveUserInCache(instance,user),instance._userViewsPromise=null):"LibraryChanged"===messageId&&(instance._userViewsPromise=null),_events.default.trigger(instance,"message",[msg])}function detectBitrateWithEndpointInfo(instance,endpointInfo){endpointInfo=endpointInfo.NetworkType;if("lan"!==endpointInfo){instance=instance.getCurrentUserCached();if(null!=instance&&instance.Policy.AutoRemoteQuality)return Promise.resolve(instance.Policy.AutoRemoteQuality)}return _qualitydetection.default.getDefaultQuality(endpointInfo)}function getRemoteImagePrefix(instance,options){var urlPrefix="Items/"+options.itemId;return delete options.itemId,urlPrefix}function setUsersProperties(items,serverId){for(var i=0,length=items.length;i<length;i++)setUserProperties(items[i],serverId);Promise.resolve(items)}function setUserProperties(user,serverId){user.Type="User",user.ServerId=serverId}function normalizeImageOptions(_ref,options){var _ref=_ref._devicePixelRatio;!1!==options.adjustForPixelRatio&&(_ref=_ref||1)&&(options.width&&(options.width=Math.round(options.width*_ref)),options.height&&(options.height=Math.round(options.height*_ref)),options.maxWidth&&(options.maxWidth=Math.round(options.maxWidth*_ref)),options.maxHeight)&&(options.maxHeight=Math.round(options.maxHeight*_ref)),delete options.adjustForPixelRatio,!1===options.keepAnimation&&delete options.keepAnimation,options.quality||("Backdrop"===options.type?options.quality=70:options.quality=90)}function mapToId(i){return i.Id}function mapToAccessToken(i){return i.AccessToken}function removeItemAll(arr,value){for(var i=0;i<arr.length;)arr[i]===value?arr.splice(i,1):++i;return arr}var startingPlaySession=Date.now();function onUserDataUpdated(userData){var instance=this.instance,itemId=this.itemId,userId=this.userId;return userData.ItemId=itemId,_events.default.trigger(instance,"message",[{MessageType:"UserDataChanged",Data:{UserId:userId,UserDataList:[userData],IsLocalEvent:!0}}]),userData}function onUserNotificationsDeleted(result){var instance=this.instance;return _events.default.trigger(instance,"message",[{MessageType:"UserNotificationsDeleted",Data:{Ids:[],IsLocalEvent:!0}}]),result}function onItemUpdated(result){var instance=this.instance,itemId=this.itemId;return _events.default.trigger(instance,"message",[{MessageType:"LibraryChanged",Data:{ItemsAdded:[],ItemsRemoved:[],ItemsUpdated:[itemId],IsLocalEvent:!0}}]),result}function onItemsDeleted(result){for(var instance=this.instance,items=this.items,foldersRemovedFrom=[],itemsRemoved=[],i=0,length=items.length;i<length;i++){var item=items[i];item.ParentId&&foldersRemovedFrom.push(item.ParentId),itemsRemoved.push(item.Id)}return _events.default.trigger(instance,"message",[{MessageType:"LibraryChanged",Data:{ItemsAdded:[],ItemsRemoved:itemsRemoved,ItemsUpdated:[],FoldersRemovedFrom:foldersRemovedFrom,IsLocalEvent:!0}}]),result}function getCachedWakeOnLanInfo(instance){instance=instance.serverId(),instance=_servicelocator.appStorage.getItem("server-"+instance+"-wakeonlaninfo");return instance?JSON.parse(instance):[]}function setScheduledTaskProperties(item,apiClient){for(var serverId=apiClient.serverId(),triggers=(item.Type="ScheduledTask",item.ServerId=serverId,item.Triggers||[]),i=0,length=triggers.length;i<length;i++){var trigger=triggers[i];trigger.ScheduledTaskId=item.Id,trigger.TriggerIndex=i,trigger.TriggerType=trigger.Type,trigger.Type="ScheduledTaskTrigger",trigger.ServerId=serverId}}function getUrl(name,params,serverAddress){if(!name)throw new Error("Url name cannot be empty");var lowered,serverAddress=serverAddress||this._serverAddress;if(serverAddress)return(lowered=(serverAddress=serverAddress.endsWith("/")?serverAddress.substring(0,serverAddress.length-1):serverAddress).toLowerCase()).endsWith("/emby")||lowered.endsWith("/mediabrowser")||(serverAddress+="/emby"),name&&(name.startsWith("/")||(serverAddress+="/"),serverAddress+=name),(params=params&&_querystring.default.paramsToString(params))&&(serverAddress+="?"+params),serverAddress;throw new Error("serverAddress is yet not set")}function normalizeFields(options){var fields;null!=options&&options.fields&&!_servicelocator.appHost.supports("sync")&&(fields=removeItemAll(fields=options.fields.split(","),"SyncStatus"),fields=removeItemAll(fields,"ContainerSyncStatus"),options.fields=fields.join(",")),null!=options&&options.Fields&&!_servicelocator.appHost.supports("sync")&&(fields=removeItemAll(fields=options.Fields.split(","),"SyncStatus"),fields=removeItemAll(fields,"ContainerSyncStatus"),options.Fields=fields.join(","))}function formatCountryDisplayNames(result){return loadGlobalize().then(function(globalize){for(var displayNames=new Intl.DisplayNames(globalize.getCurrentLocales(),{type:"region",fallback:"none"}),i=0,length=result.length;i<length;i++){var country=result[i],code=country.TwoLetterISORegionName;if(code)try{var displayName=displayNames.of(code);displayName&&(country.DisplayName=displayName)}catch(err){console.log("error thrown by Intl.DisplayNames: "+err+". Code: "+code)}}return result})}var StandardWidths=[480,720,1280,1920,2560,3840];function ApiClient(serverAddress,appName,appVersion,deviceName,deviceId,devicePixelRatio){if(!serverAddress)throw new Error("Must supply a serverAddress");if(!appName)throw new Error("Must supply a appName");if(!appVersion)throw new Error("Must supply a appVersion");if(!deviceName)throw new Error("Must supply a deviceName");if(!deviceId)throw new Error("Must supply a deviceId");console.log("ApiClient serverAddress: "+serverAddress),console.log("ApiClient appName: "+appName),console.log("ApiClient appVersion: "+appVersion),console.log("ApiClient deviceName: "+deviceName),console.log("ApiClient deviceId: "+deviceId),this._serverInfo={},this._userAuthInfo={},this._serverAddress=serverAddress,this._deviceId=deviceId,this._deviceName=deviceName,this._appName=appName,this._appVersion=appVersion,this._devicePixelRatio=devicePixelRatio}function setTimerProperties(item){item.Type="Timer"}function expandSectionBlock(instance,section,allSectionIds,options){var name,collectionType,cardSizeOffset,viewType,includeNextUp,result=[],monitor=[],sectionType=section;switch(section){case"latestmedia":return function(instance,options){var user=options.user,result=[];return instance.getUserViews({},user.Id).then(function(userViewsResult){for(var userViews=userViewsResult.Items,excludeViewTypes=["playlists","livetv","boxsets","channels"],i=0,length=userViews.length;i<length;i++){var collectionType,monitor,item=userViews[i];user.Configuration.LatestItemsExcludes.includes(item.Id)||item.Guid&&user.Configuration.LatestItemsExcludes.includes(item.Guid)||(collectionType=item.CollectionType,excludeViewTypes.includes(collectionType))||(monitor=["markplayed"],"music"!==collectionType&&"audiobooks"!==collectionType&&monitor.push("videoplayback"),result.push({Id:"latestmedia_"+item.Id,SectionType:"latestmedia",Name:globalize.translate("LatestFromLibrary",item.Name),ParentItem:item,CollectionType:item.CollectionType,Monitor:monitor}))}return result})}(instance,options);case"smalllibrarytiles":sectionType="userviews",name=globalize.translate("HeaderMyMedia"),cardSizeOffset=-1;break;case"librarybuttons":sectionType="userviews",name=globalize.translate("HeaderMyMedia"),viewType="buttons";break;case"resume":name=globalize.translate("HeaderContinueWatching"),monitor.push("videoplayback"),monitor.push("markplayed"),includeNextUp=!allSectionIds.includes("nextup")&&null;break;case"resumeaudio":name=globalize.translate("HeaderContinueListening"),monitor.push("audioplayback"),monitor.push("markplayed");break;case"latestmoviereleases":name=globalize.translate("RecentlyReleasedMovies"),collectionType="movies";break;case"playlists":name=globalize.translate("Playlists"),collectionType="playlists";break;case"collections":name=globalize.translate("Collections"),collectionType="boxsets";break;case"activerecordings":name=globalize.translate("HeaderActiveRecordings"),monitor.push("RecordingStarted"),monitor.push("RecordingEnded");break;case"nextup":name=globalize.translate("HeaderNextUp"),monitor.push("videoplayback"),monitor.push("markplayed"),collectionType="tvshows";break;case"onnow":case"livetv":return function(options){var result=[];return options.user.Policy.EnableLiveTvAccess&&result.push({Id:"onnow",SectionType:"onnow",Name:globalize.translate("HeaderOnNow"),CollectionType:"livetv",PremiumFeature:"livetv",PremiumMessage:globalize.translate("DvrSubscriptionRequired","",""),RefreshInterval:3e5}),Promise.resolve(result)}(options);default:return Promise.resolve(result)}return result.push({Id:section,SectionType:sectionType,Name:name,CollectionType:collectionType,Monitor:monitor,CardSizeOffset:cardSizeOffset,ViewType:viewType,IncludeNextUp:includeNextUp}),Promise.resolve(result)}function enableServerHomeSections(apiClient){apiClient.isMinServerVersion("4.9.1.20")}ApiClient.prototype.appName=function(){return this._appName},ApiClient.prototype.setAuthorizationInfoIntoRequest=function(request,includeAccessToken){var authValues={},appName=this._appName,includeAccessToken=(appName&&(authValues["X-Emby-Client"]=appName),this._deviceName&&(authValues["X-Emby-Device-Name"]=this._deviceName),this._deviceId&&(authValues["X-Emby-Device-Id"]=this._deviceId),this._appVersion&&(authValues["X-Emby-Client-Version"]=this._appVersion),!1!==includeAccessToken&&(appName=this.accessToken())&&(authValues["X-Emby-Token"]=appName),this.getCurrentLocale()),appName=(includeAccessToken&&(authValues["X-Emby-Language"]=includeAccessToken),new URLSearchParams(authValues).toString());appName&&(includeAccessToken=request.url,includeAccessToken+=includeAccessToken.includes("?")?"&":"?",request.url=includeAccessToken+=appName)},ApiClient.prototype.appVersion=function(){return this._appVersion},ApiClient.prototype.deviceName=function(){return this._deviceName},ApiClient.prototype.deviceId=function(){return this._deviceId},ApiClient.prototype.serverAddress=function(val){if(null!=val){if(!val.toLowerCase().startsWith("http"))throw new Error("Invalid url: "+val);setServerAddress(this,val),onNetworkChanged(this)}return this._serverAddress},ApiClient.prototype.onNetworkChanged=function(){onNetworkChanged(this,!0)},ApiClient.prototype.fetchWithFailover=function(request,enableReconnection,signal){console.log("apiclient.fetchWithFailover "+request.url),request.timeout=3e4;var instance=this;return getFetchPromise(0,request,signal).then(function(response){return instance.connected=!0,response.status<400?"json"===request.dataType||"application/json"===request.headers.accept?response.json():"text"===request.dataType||(response.headers.get("Content-Type")||"").toLowerCase().startsWith("text/")||204===response.status?response.text():response:Promise.reject(response)},function(error){var previousServerAddress;if(error?"AbortError"===error.name?console.log("AbortError: "+request.url):console.log("Request failed to "+request.url+" "+(error.status||"")+" "+error.toString()):console.log("Request timed out to "+request.url),error&&error.status||!enableReconnection)throw console.log("Reporting request failure"),error;return console.log("Attempting reconnection"),previousServerAddress=instance.serverAddress(),tryReconnect(instance,signal,null).then(function(newServerAddress){return console.log("Reconnect succeeded to "+newServerAddress),instance.connected=!0,instance.enableWebSocketAutoConnect&&instance.ensureWebSocket(),request.url=request.url.replace(previousServerAddress,newServerAddress),console.log("Retrying request with new url: "+request.url),instance.fetchWithFailover(request,!1,signal)})})},ApiClient.prototype.fetch=function(request,includeAccessToken,signal){if(request)return request.headers=request.headers||{},this.setAuthorizationInfoIntoRequest(request,includeAccessToken),!1===this.enableAutomaticNetworking||"GET"!==request.type?getFetchPromise(0,request,signal).then(function(response){return response.status<400?"json"===request.dataType||"application/json"===request.headers.accept?response.json():"text"===request.dataType||(response.headers.get("Content-Type")||"").toLowerCase().startsWith("text/")||204===response.status?response.text():response:Promise.reject(response)}):this.fetchWithFailover(request,!0,signal);throw new Error("Request cannot be null")},ApiClient.prototype.setAuthenticationInfo=function(userAuthInfo){this._userAuthInfo.UserId!==(userAuthInfo=userAuthInfo||{}).UserId&&(this._userViewsPromise=null),this._userAuthInfo=userAuthInfo},ApiClient.prototype.serverInfo=function(info){var currentUserId;return info&&(currentUserId=this.getCurrentUserId(),this._serverInfo=info,currentUserId!==this.getCurrentUserId())&&(this._userViewsPromise=null),this._serverInfo},ApiClient.prototype.getCurrentUserName=function(){var userId=this.getCurrentUserId();return!userId||null==(userId=getCachedUser(this,userId))?null:userId.Name},ApiClient.prototype.getCurrentUserId=function(){return this._userAuthInfo.UserId},ApiClient.prototype.accessToken=function(){return this._userAuthInfo.AccessToken},ApiClient.prototype.serverId=function(){return this.serverInfo().Id},ApiClient.prototype.serverName=function(){return this.serverInfo().Name},ApiClient.prototype.ajax=function(request,includeAccessToken){if(request)return this.fetch(request,includeAccessToken,request.signal);throw new Error("Request cannot be null")},ApiClient.prototype.getCurrentUser=function(options){var userId=this.getCurrentUserId();return userId?this.getUser(userId,(options=options||{}).enableCache,options.signal):Promise.reject()},ApiClient.prototype.isLoggedIn=function(){var info=this._userAuthInfo;return!!(info&&info.UserId&&info.AccessToken)},ApiClient.prototype.logout=function(){function done(){return _this.clearAuthenticationInfo(),Promise.resolve()}var url,_this=this;this.closeWebSocket();return this.isLoggedIn()?(url=this.getUrl("Sessions/Logout"),this.ajax({type:"POST",url:url,timeout:1e4}).then(done,done)):done()},ApiClient.prototype.authenticateUserByName=function(name,password){var url,instance;return name?(url=this.getUrl("Users/authenticatebyname"),(instance=this).ajax({type:"POST",url:url,data:{Username:name,Pw:password||""},dataType:"json"}).then(function(result){instance._userViewsPromise=null,saveUserInCache(instance,result.User,!0);function afterOnAuthenticated(){return instance.getSystemInfo(),result}return instance.onAuthenticated?instance.onAuthenticated(instance,result).then(afterOnAuthenticated):(afterOnAuthenticated(),result)})):Promise.reject()},ApiClient.prototype.ensureWebSocket=function(){if(this.connected&&!this.isWebSocketOpenOrConnecting()&&this.isWebSocketSupported())try{this.openWebSocket()}catch(err){console.log("Error opening web socket: "+(err||""))}},ApiClient.prototype.openWebSocket=function(){var accessToken=this.accessToken();if(!accessToken)throw new Error("Cannot open web socket without access token.");var apiClient,socket,serverUrl=this._serverAddress||"",url=(serverUrl=serverUrl.endsWith("/")?serverUrl.substring(0,serverUrl.length-1):serverUrl).toLowerCase().endsWith("/emby")?this.getUrl("embywebsocket"):replaceAll(url=this.getUrl("socket"),"emby/socket","embywebsocket"),serverUrl=(url=replaceAll(url,"https:","wss:"),url=replaceAll(url,"http:","ws:"),url=(url+="?api_key="+accessToken)+("&deviceId="+this.deviceId()),console.log("opening web socket with url: "+url),new WebSocket(url));serverUrl.onmessage=function(msg){onMessageReceivedInternal(this,msg=JSON.parse(msg.data))}.bind(this),serverUrl.onopen=function(){console.log("web socket connection opened"),_events.default.trigger(this,"websocketopen");var list=this.messageListeners;if(list)for(var i=0,length=(list=list.slice(0)).length;i<length;i++){var listener=list[i];this.startMessageListener(listener.name,listener.options)}}.bind(this),serverUrl.onerror=function(){_events.default.trigger(this,"websocketerror")}.bind(this),apiClient=this,(socket=serverUrl).onclose=function(){console.log("web socket closed"),apiClient._webSocket===socket&&(console.log("nulling out web socket"),apiClient._webSocket=null),setTimeout(function(){_events.default.trigger(apiClient,"websocketclose")},0)},this._webSocket=serverUrl},ApiClient.prototype.closeWebSocket=function(){var socket=this._webSocket;socket&&socket.readyState===WebSocket.OPEN&&socket.close()},ApiClient.prototype.sendWebSocketMessage=function(name,data){console.log("Sending web socket message: "+name);name={MessageType:name};data&&(name.Data=data),name=JSON.stringify(name),this._webSocket.send(name)},ApiClient.prototype.startMessageListener=function(name,options){console.log("apiclient starting message listener "+name+" with options "+options),this.sendMessage(name+"Start",options);var list=this.messageListeners;list||(this.messageListeners=list=[]);for(var i=0,length=list.length;i<length;i++)if(list[i].name===name)return;list.push({name:name,options:options})},ApiClient.prototype.stopMessageListener=function(name){var list=this.messageListeners;list&&(this.messageListeners=list.filter(function(n){return n.name!==name})),console.log("apiclient stopping message listener "+name),this.sendMessage(name+"Stop")},ApiClient.prototype.sendMessage=function(name,data){this.isWebSocketOpen()&&this.sendWebSocketMessage(name,data)},ApiClient.prototype.isMessageChannelOpen=function(){return this.isWebSocketOpen()},ApiClient.prototype.isWebSocketOpen=function(){var socket=this._webSocket;return!!socket&&socket.readyState===WebSocket.OPEN},ApiClient.prototype.isWebSocketOpenOrConnecting=function(){var socket=this._webSocket;return!!socket&&(socket.readyState===WebSocket.OPEN||socket.readyState===WebSocket.CONNECTING)},ApiClient.prototype.get=function(url){return this.ajax({type:"GET",url:url})},ApiClient.prototype.getJSON=function(url,signal){return this.fetch({url:url,type:"GET",dataType:"json"},null,signal)},ApiClient.prototype.getText=function(url,signal){return this.fetch({url:url,type:"GET",dataType:"text"},null,signal)},ApiClient.prototype.updateServerInfo=function(server,serverUrl){if(null==server)throw new Error("server cannot be null");if(this.serverInfo(server),!serverUrl)throw new Error("serverUrl cannot be null. serverInfo: "+JSON.stringify(server));console.log("Setting server address to "+serverUrl),this.serverAddress(serverUrl)},ApiClient.prototype.isWebSocketSupported=function(){try{return null!=WebSocket}catch(err){return!1}},ApiClient.prototype.clearAuthenticationInfo=function(){this.setAuthenticationInfo(null)},ApiClient.prototype.encodeName=function(name){name=(name=(name=name.split("/").join("-")).split("&").join("-")).split("?").join("-");name=new URLSearchParams({name:name}).toString();return name.substring(name.indexOf("=")+1).replace("'","%27")},ApiClient.prototype.getProductNews=function(){var url=this.getUrl("News/Product",0<arguments.length&&void 0!==arguments[0]?arguments[0]:{});return this.getJSON(url)},ApiClient.prototype.detectBitrate=function(signal){var instance=this;return instance.getEndpointInfo(signal).then(function(info){return detectBitrateWithEndpointInfo(instance,info)},function(err){return console.log("error in getEndpointInfo: "+(err||"")),detectBitrateWithEndpointInfo(instance,{})})},ApiClient.prototype.getItem=function(userId,itemId,options,signal){if(!itemId)throw new Error("null itemId");normalizeFields(options);userId=userId?this.getUrl("Users/"+userId+"/Items/"+itemId,options):this.getUrl("Items/"+itemId,options);return this.getJSON(userId,signal)},ApiClient.prototype.getRootFolder=function(userId){if(userId)return userId=this.getUrl("Users/"+userId+"/Items/Root"),this.getJSON(userId);throw new Error("null userId")},ApiClient.prototype.getCurrentLocale=function(){return this.currentLocale},ApiClient.prototype.setCurrentLocale=function(value){this.currentLocale=value},ApiClient.prototype.getNotificationTypes=function(options){return this.getJSON(this.getUrl("Notifications/Types",options="string"==typeof options?{}:options))},ApiClient.prototype.sendTestUserNotification=function(options){var url=this.getUrl("Notifications/Services/Test");return this.ajax({type:"POST",url:url,data:JSON.stringify(options),contentType:"application/json"})},ApiClient.prototype.saveUserNotification=function(options){var url=this.getUrl("Notifications/Services/Configured");return this.ajax({type:"POST",url:url,data:JSON.stringify(options),contentType:"application/json"}).then(function(result){var instance=this.instance;return _events.default.trigger(instance,"message",[{MessageType:"UserNotificationsSaved",Data:{Ids:[],IsLocalEvent:!0}}]),result}.bind({instance:this,items:[]}))},ApiClient.prototype.deleteUserNotifications=function(items){var instance=this;return Promise.all(items.map(function(item){return instance.ajax({url:instance.getUrl("Notifications/Services/Configured",{Id:item.Id,UserId:item.UserId}),type:"DELETE"})})).then(onUserNotificationsDeleted.bind({instance:this,items:items}),onUserNotificationsDeleted.bind({instance:this,items:items}))},ApiClient.prototype.getFeatures=function(query){return this.isMinServerVersion("4.8.0.20")?this.getJSON(this.getUrl("Features",query)):Promise.resolve([])},ApiClient.prototype.getRemoteImageProviders=function(options){var urlPrefix;if(options)return urlPrefix=getRemoteImagePrefix(0,options),urlPrefix=this.getUrl(urlPrefix+"/RemoteImages/Providers",options),this.getJSON(urlPrefix);throw new Error("null options")},ApiClient.prototype.getAvailableRemoteImages=function(options){var urlPrefix;if(options)return urlPrefix=getRemoteImagePrefix(0,options),urlPrefix=this.getUrl(urlPrefix+"/RemoteImages",options),this.getJSON(urlPrefix);throw new Error("null options")},ApiClient.prototype.downloadRemoteImage=function(options){var itemId,urlPrefix;if(options)return itemId=options.itemId,urlPrefix=getRemoteImagePrefix(0,options),urlPrefix=this.getUrl(urlPrefix+"/RemoteImages/Download",options),this.ajax({type:"POST",url:urlPrefix}).then(onItemUpdated.bind({instance:this,itemId:itemId}));throw new Error("null options")},ApiClient.prototype.getRecordingFolders=function(userId){userId=this.getUrl("LiveTv/Recordings/Folders",{userId:userId});return this.getJSON(userId)},ApiClient.prototype.getLiveTvInfo=function(options){options=this.getUrl("LiveTv/Info",options||{});return this.getJSON(options)},ApiClient.prototype.getLiveTvGuideInfo=function(options){options=this.getUrl("LiveTv/GuideInfo",options||{});return this.getJSON(options)},ApiClient.prototype.getLiveTvChannel=function(id,userId){var options;if(id)return options={},userId&&(options.userId=userId),userId=this.getUrl("LiveTv/Channels/"+id,options),this.getJSON(userId);throw new Error("null id")},ApiClient.prototype.getLiveTvChannelsForManagement=function(query,signal){query=this.getUrl("LiveTv/Manage/Channels",query);return this.getJSON(query,signal)},ApiClient.prototype.setChannelDisabled=function(item,disabled){var id=item.Id,item=this.getUrl("LiveTv/Manage/Channels/"+id+"/Disabled",{ManagementId:item.ManagementId,Disabled:disabled});return this.ajax({type:"POST",url:item,contentType:"application/json",dataType:"json"}).then(function(result){var instance=this.instance,id=this.id;return _events.default.trigger(instance,"message",[{MessageType:"ChannelManagementInfoUpdated",Data:{Channel:result,Id:id,IsLocalEvent:!0}}]),result}.bind({instance:this,id:id}))},ApiClient.prototype.setChannelSortIndex=function(item,newIndex){var id=item.Id,item=this.getUrl("LiveTv/Manage/Channels/"+id+"/SortIndex",{ManagementId:item.ManagementId,NewIndex:newIndex});return this.ajax({type:"POST",url:item}).then(function(result){var instance=this.instance,id=this.id;return _events.default.trigger(instance,"message",[{MessageType:"ChannelManagementInfoUpdated",Data:{Id:id,IsLocalEvent:!0}}]),result}.bind({instance:this,id:id}))},ApiClient.prototype.getLiveTvChannels=function(options,signal){options=this.getUrl("LiveTv/Channels",options||{});return this.getJSON(options,signal)},ApiClient.prototype.getLiveTvPrograms=function(){var options=0<arguments.length&&void 0!==arguments[0]?arguments[0]:{};return options&&options.LibrarySeriesId&&isLocalId(options.LibrarySeriesId)?Promise.resolve({Items:[],TotalRecordCount:0}):options.channelIds&&1800<options.channelIds.length?this.ajax({type:"POST",url:this.getUrl("LiveTv/Programs"),data:JSON.stringify(options),contentType:"application/json",dataType:"json"}):this.getJSON(this.getUrl("LiveTv/Programs",options))},ApiClient.prototype.getEpg=function(){var options=0<arguments.length&&void 0!==arguments[0]?arguments[0]:{},signal=1<arguments.length?arguments[1]:void 0;return options.AddCurrentProgram=!1,options.EnableUserData=!1,options.EnableImageTypes="Primary",options.UserId=this.getCurrentUserId(),0!==options.Limit||this.isMinServerVersion("4.8.0.46")||(options.Limit=1),this.getJSON(this.getUrl("LiveTv/EPG",options),signal).then(function(result){return result.Items.forEach(function(result){result.Type="EpgChannel",result.ServerId=this.serverId(),result.Id=result.Channel.Id}.bind(this)),result}.bind(this))},ApiClient.prototype.getLiveTvRecommendedPrograms=function(){return this.getJSON(this.getUrl("LiveTv/Programs/Recommended",0<arguments.length&&void 0!==arguments[0]?arguments[0]:{}))},ApiClient.prototype.getLiveTvRecordings=function(options,signal){options=this.getUrl("LiveTv/Recordings",options||{});return this.getJSON(options,signal)},ApiClient.prototype.getLiveTvRecordingSeries=function(options){options=this.getUrl("LiveTv/Recordings/Series",options||{});return this.getJSON(options)},ApiClient.prototype.getLiveTvRecording=function(id,userId){var options;if(id)return options={},userId&&(options.userId=userId),userId=this.getUrl("LiveTv/Recordings/"+id,options),this.getJSON(userId);throw new Error("null id")},ApiClient.prototype.getLiveTvProgram=function(id,userId){var options;if(id)return options={},userId&&(options.userId=userId),userId=this.getUrl("LiveTv/Programs/"+id,options),this.getJSON(userId);throw new Error("null id")},ApiClient.prototype.cancelLiveTvTimer=function(id){if(id)return id=this.getUrl("LiveTv/Timers/"+id+"/Delete"),this.ajax({type:"POST",url:id});throw new Error("null id")},ApiClient.prototype.getLiveTvTimers=function(options){options=this.getUrl("LiveTv/Timers",options||{});return this.getJSON(options).then(function(result){return result.Items.forEach(setTimerProperties),result})},ApiClient.prototype.getLiveTvTimer=function(id){if(id)return id=this.getUrl("LiveTv/Timers/"+id),this.getJSON(id).then(function(item){return item.Type="Timer",item});throw new Error("null id")},ApiClient.prototype.getNewLiveTvTimerDefaults=function(){var url=this.getUrl("LiveTv/Timers/Defaults",0<arguments.length&&void 0!==arguments[0]?arguments[0]:{});return this.getJSON(url)},ApiClient.prototype.createLiveTvTimer=function(item){var url;if(item)return url=this.getUrl("LiveTv/Timers"),this.ajax({type:"POST",url:url,data:JSON.stringify(item),contentType:"application/json"});throw new Error("null item")},ApiClient.prototype.updateLiveTvTimer=function(item){var url;if(item)return url=this.getUrl("LiveTv/Timers/"+item.Id),this.ajax({type:"POST",url:url,data:JSON.stringify(item),contentType:"application/json"});throw new Error("null item")},ApiClient.prototype.resetLiveTvTuner=function(id){if(id)return id=this.getUrl("LiveTv/Tuners/"+id+"/Reset"),this.ajax({type:"POST",url:id});throw new Error("null id")},ApiClient.prototype.getLiveTvSeriesTimers=function(query,signal){return this.getJSON(this.getUrl("LiveTv/SeriesTimers",query),signal)},ApiClient.prototype.getLiveTvSeriesTimer=function(id){if(id)return id=this.getUrl("LiveTv/SeriesTimers/"+id),this.getJSON(id);throw new Error("null id")},ApiClient.prototype.cancelLiveTvSeriesTimer=function(id){var url;if(id)return url=this.getUrl("LiveTv/SeriesTimers/"+id+"/Delete"),this.ajax({type:"POST",url:url}).then(function(result){var instance=this.instance,itemId=this.itemId;return _events.default.trigger(instance,"message",[{MessageType:"SeriesTimerCancelled",Data:{Id:itemId,IsLocalEvent:!0}}]),result}.bind({instance:this,itemId:id}));throw new Error("null id")},ApiClient.prototype.createLiveTvSeriesTimer=function(item){var url;if(item)return url=this.getUrl("LiveTv/SeriesTimers"),this.ajax({type:"POST",url:url,dataType:this.isMinServerVersion("4.9.0.13")?"json":null,data:JSON.stringify(item),contentType:"application/json"}).then(function(result){var instance=this.instance;return result=result||{},_events.default.trigger(instance,"message",[{MessageType:"SeriesTimerCreated",Data:Object.assign({IsLocalEvent:!0},result)}]),result}.bind({instance:this}));throw new Error("null item")},ApiClient.prototype.updateLiveTvSeriesTimer=function(item){var itemId,url;if(item)return itemId=item.Id,url=this.getUrl("LiveTv/SeriesTimers/"+itemId),this.ajax({type:"POST",url:url,data:JSON.stringify(item),contentType:"application/json"}).then(function(result){var instance=this.instance,itemId=this.itemId;return _events.default.trigger(instance,"message",[{MessageType:"SeriesTimerUpdated",Data:{Id:itemId,IsLocalEvent:!0}}]),result}.bind({instance:this,itemId:itemId}));throw new Error("null item")},ApiClient.prototype.getRegistrationInfo=function(feature){feature=this.getUrl("Registrations/"+feature);return this.getJSON(feature)},ApiClient.prototype.getSystemInfo=function(){var url=this.getUrl("System/Info"),instance=this;return this.getJSON(url).then(function(info){return instance.setSystemInfo(info),Promise.resolve(info)})},ApiClient.prototype.getSyncStatus=function(item){return isLocalId(item.Id)?Promise.resolve({}):item.SyncStatus||this.isMinServerVersion("4.8.0.53")?Promise.resolve({Status:item.SyncStatus}):(item=this.getUrl("Sync/"+item.Id+"/Status"),this.ajax({url:item,type:"POST",dataType:"json",contentType:"application/json",data:JSON.stringify({TargetId:this.deviceId()})}))},ApiClient.prototype.getPublicSystemInfo=function(){var url=this.getUrl("System/Info/Public"),instance=this;return this.getJSON(url).then(function(info){return instance.setSystemInfo(info),Promise.resolve(info)})},ApiClient.prototype.getInstantMixFromItem=function(itemId,options){return isLocalId(itemId)?Promise.resolve({Items:[],TotalRecordCount:0}):(itemId=this.getUrl("Items/"+itemId+"/InstantMix",options),this.getJSON(itemId))},ApiClient.prototype.getEpisodes=function(itemId,options,signal){var requiresStartItemIdPostProcess=!1,itemId=((options=options||{}).SeasonId||!options.StartItemId||this.isMinServerVersion("4.8.0.29")||(requiresStartItemIdPostProcess=!(options.Limit=null)),normalizeFields(options),this.getUrl("Shows/"+itemId+"/Episodes",options)),itemId=this.getJSON(itemId,signal);return requiresStartItemIdPostProcess?itemId.then(function(result){for(var index=-1,i=0,length=result.Items.length;i<length;i++)if(options.StartItemId===result.Items[i].Id){index=i;break}return-1!==index&&(result.Items=result.Items.slice(index),!1!==options.EnableTotalRecordCount)&&(result.TotalRecordCount=result.Items.length),result}):itemId},ApiClient.prototype.getDisplayPreferences=function(userId){var instance=this;return instance.isMinServerVersion("4.9.0.23")?instance.getJSON(instance.getUrl("usersettings/"+userId)):this.getJSON(this.getUrl("DisplayPreferences/usersettings",{userId:userId,client:"emby"})).then(function(result){return instance._displayPreferencesId=result.Id,result.CustomPrefs||{}})},ApiClient.prototype.updatePartialDisplayPreferences=function(obj,userId){if(this.isMinServerVersion("4.9.0.23"))return this.ajax({type:"POST",url:this.getUrl("usersettings/"+userId+"/Partial"),data:JSON.stringify(obj),contentType:"application/json"});throw new Error("unsupported server version")},ApiClient.prototype.updateDisplayPreferences=function(obj,userId){return this.isMinServerVersion("4.9.0.23")?this.ajax({type:"POST",url:this.getUrl("usersettings/"+userId),data:obj,contentType:"application/json"}):this.ajax({type:"POST",url:this.getUrl("DisplayPreferences/usersettings",{userId:userId,client:"emby"}),data:JSON.stringify({CustomPrefs:obj,Client:"emby",Id:this._displayPreferencesId||"3ce5b65de116d73165d1efc4a30ec35c"}),contentType:"application/json"})},ApiClient.prototype.getSeasons=function(itemId,options){itemId=this.getUrl("Shows/"+itemId+"/Seasons",options);return this.getJSON(itemId)},ApiClient.prototype.getSimilarItems=function(itemId,options){return isLocalId(itemId)?Promise.resolve({Items:[],TotalRecordCount:0}):(itemId=this.getUrl("Items/"+itemId+"/Similar",options),this.getJSON(itemId))},ApiClient.prototype.getCultures=function(){var url=this.getUrl("Localization/cultures");return this.getJSON(url)},ApiClient.prototype.getCountries=function(){var url=this.getUrl("Localization/countries");return this.getJSON(url).then(formatCountryDisplayNames)},ApiClient.prototype.getPlaybackInfo=function(itemId,options,deviceProfile,signal){deviceProfile={DeviceProfile:deviceProfile};return this.ajax({url:this.getUrl("Items/"+itemId+"/PlaybackInfo",options),type:"POST",data:JSON.stringify(deviceProfile),contentType:"application/json",dataType:"json",signal:signal})},ApiClient.prototype.getLiveStreamMediaInfo=function(liveStreamId){liveStreamId={LiveStreamId:liveStreamId};return this.ajax({url:this.getUrl("LiveStreams/MediaInfo"),type:"POST",data:JSON.stringify(liveStreamId),contentType:"application/json",dataType:"json"})},ApiClient.prototype.getIntros=function(itemId,options,signal){return isLocalId(itemId)?Promise.resolve({Items:[],TotalRecordCount:0}):this.getJSON(this.getUrl("Users/"+this.getCurrentUserId()+"/Items/"+itemId+"/Intros",options),signal)},ApiClient.prototype.getDirectoryContents=function(path,options){if(!path)throw new Error("null path");if("string"!=typeof path)throw new Error("invalid path");return(options=options||{}).path=path,this.isMinServerVersion("4.8.0.53")?this.ajax({type:"POST",data:JSON.stringify(options),contentType:"application/json",dataType:"json",url:this.getUrl("Environment/DirectoryContents")}):this.getJSON(this.getUrl("Environment/DirectoryContents",options))},ApiClient.prototype.getNetworkShares=function(path){var options;if(path)return(options={}).path=path,path=this.getUrl("Environment/NetworkShares",options),this.getJSON(path);throw new Error("null path")},ApiClient.prototype.getParentPath=function(path){var options;if(path)return(options={}).path=path,path=this.getUrl("Environment/ParentPath",options),this.ajax({type:"GET",url:path,dataType:"text"});throw new Error("null path")},ApiClient.prototype.getDrives=function(){var url=this.getUrl("Environment/Drives");return this.getJSON(url)},ApiClient.prototype.getNetworkDevices=function(){var url=this.getUrl("Environment/NetworkDevices");return this.getJSON(url)},ApiClient.prototype.getActivityLog=function(options,signal){var options=this.getUrl("System/ActivityLog/Entries",options||{}),serverId=this.serverId();return this.getJSON(options,signal).then(function(result){for(var items=result.Items,i=0,length=items.length;i<length;i++){var item=items[i];item.Type="ActivityLogEntry",item.ServerId=serverId}return result})},ApiClient.prototype.cancelPackageInstallation=function(installationId){if(installationId)return installationId=this.getUrl("Packages/Installing/"+installationId+"/Delete"),this.ajax({type:"POST",url:installationId});throw new Error("null installationId")},ApiClient.prototype.refreshItems=function(items,options){var instance;if(items)return instance=this,Promise.all(items.map(function(item){return instance.ajax({type:"POST",url:instance.getUrl("Items/"+item.Id+"/Refresh",options)})}));throw new Error("null items")},ApiClient.prototype.installPlugin=function(name,guid,updateClass,version){if(!name)throw new Error("null name");if(updateClass)return updateClass={updateClass:updateClass,AssemblyGuid:guid},version&&(updateClass.version=version),guid=this.getUrl("Packages/Installed/"+name,updateClass),this.ajax({type:"POST",url:guid});throw new Error("null updateClass")},ApiClient.prototype.restartServer=function(){var url=this.getUrl("System/Restart");return this.ajax({type:"POST",url:url})},ApiClient.prototype.shutdownServer=function(){var url=this.getUrl("System/Shutdown");return this.ajax({type:"POST",url:url})},ApiClient.prototype.getPackageInfo=function(name,guid){if(name)return name=this.getUrl("Packages/"+name,{AssemblyGuid:guid}),this.getJSON(name);throw new Error("null name")},ApiClient.prototype.getAvailableApplicationUpdate=function(){var url=this.getUrl("Packages/Updates",{PackageType:"System"});return this.getJSON(url)},ApiClient.prototype.getAvailablePluginUpdates=function(){var url=this.getUrl("Packages/Updates",{PackageType:"UserInstalled"});return this.getJSON(url)},ApiClient.prototype.getVirtualFolders=function(query,signal){var serverId=this.serverId();return this.getJSON(this.getUrl("Library/VirtualFolders/Query",query="string"==typeof query?{userId:query}:query),signal).then(function(result){for(var i=0,length=result.Items.length;i<length;i++){var item=result.Items[i];!function(item){item.Type="VirtualFolder",item.Id=item.ItemId,item.IsFolder=!0}(item),item.ServerId=serverId}return result})},ApiClient.prototype.getPhysicalPaths=function(){var url=this.getUrl("Library/PhysicalPaths");return this.getJSON(url)},ApiClient.prototype.getServerConfiguration=function(){var url=this.getUrl("System/Configuration");return this.getJSON(url)},ApiClient.prototype.getDevices=function(query,signal){var instance=this;return this.getJSON(this.getUrl("Devices",query),signal).then(function(result){for(var item,apiClient,iconUrl,i=0,length=result.Items.length;i<length;i++)item=result.Items[i],apiClient=instance,iconUrl=void 0,item.Type="Device",item.ServerId=apiClient.serverId(),item.PrimaryImageAspectRatio=1,(iconUrl=item.IconUrl)&&-1===iconUrl.indexOf("://")&&(iconUrl=apiClient.getUrl(iconUrl)),item.ImageUrl=iconUrl;return result})},ApiClient.prototype.getDevicesOptions=function(){var url=this.getUrl("System/Configuration/devices");return this.getJSON(url)},ApiClient.prototype.getContentUploadHistory=function(){var url=this.getUrl("Devices/CameraUploads",{DeviceId:this.deviceId()});return this.getJSON(url)},ApiClient.prototype.getNamedConfiguration=function(name){name=this.getUrl("System/Configuration/"+name);return this.getJSON(name)},ApiClient.prototype.getHardwareAccelerations=function(){var url=this.getUrl("Encoding/HardwareAccelerations");return this.getJSON(url)},ApiClient.prototype.getVideoCodecInformation=function(){var url=this.getUrl("Encoding/CodecInformation/Video");return this.getJSON(url)},ApiClient.prototype.getScheduledTasks=function(){var url=this.getUrl("ScheduledTasks",0<arguments.length&&void 0!==arguments[0]?arguments[0]:{}),instance=this;return this.getJSON(url).then(function(result){for(var i=0,length=result.length;i<length;i++)setScheduledTaskProperties(result[i],instance);return result})},ApiClient.prototype.startScheduledTask=function(id){if(id)return id=this.getUrl("ScheduledTasks/Running/"+id),this.ajax({type:"POST",url:id});throw new Error("null id")},ApiClient.prototype.getScheduledTask=function(id){var instance;if(id)return id=(instance=this).getUrl("ScheduledTasks/"+id),this.getJSON(id).then(function(result){return setScheduledTaskProperties(result,instance),result});throw new Error("null id")},ApiClient.prototype.getNextUpAudioBookItems=function(options,signal){return options.AlbumId&&isLocalId(options.AlbumId)?Promise.resolve({Items:[],TotalRecordCount:0}):(options=this.getUrl("AudioBooks/NextUp",options),this.getJSON(options,signal))},ApiClient.prototype.getResumableItemsFromAudioBook=function(options,signal){var albumId=options.AlbumId;return isLocalId(albumId)?Promise.resolve({Items:[],TotalRecordCount:0}):1===options.Limit&&this.isMinServerVersion("4.9.1")?(options.IncludeItemTypes="Audio",options.ParentId=albumId,options.AlbumId=null,this.getResumableItems(this.getCurrentUserId(),options,signal)):this.getNextUpAudioBookItems(options,signal)},ApiClient.prototype.getNextUpEpisodes=function(options,signal){return options.SeriesId&&isLocalId(options.SeriesId)?Promise.resolve({Items:[],TotalRecordCount:0}):(options=this.getUrl("Shows/NextUp",options),this.getJSON(options,signal))},ApiClient.prototype.getResumableItemsFromSeries=function(options,signal){var seriesId=options.SeriesId;return isLocalId(seriesId)?Promise.resolve({Items:[],TotalRecordCount:0}):1===options.Limit&&this.isMinServerVersion("4.9.1")?(options.IncludeItemTypes="Episode",options.ParentId=seriesId,options.SeriesId=null,this.getResumableItems(this.getCurrentUserId(),options,signal)):this.getNextUpEpisodes(options,signal)},ApiClient.prototype.stopScheduledTask=function(id){if(id)return id=this.getUrl("ScheduledTasks/Running/"+id+"/Delete"),this.ajax({type:"POST",url:id});throw new Error("null id")},ApiClient.prototype.getPluginConfiguration=function(id){if(id)return id=this.getUrl("Plugins/"+id+"/Configuration"),this.getJSON(id);throw new Error("null Id")},ApiClient.prototype.getAvailablePlugins=function(){var options=0<arguments.length&&void 0!==arguments[0]?arguments[0]:{},options=(options.PackageType="UserInstalled",this.getUrl("Packages",options));return this.getJSON(options)},ApiClient.prototype.uninstallPlugin=function(id){if(id)return this.uninstallPlugins([{Id:id}]);throw new Error("null Id")},ApiClient.prototype.uninstallPluginSingle=function(id){if(id)return id=this.getUrl("Plugins/"+id+"/Delete"),this.ajax({type:"POST",url:id});throw new Error("null Id")},ApiClient.prototype.uninstallPlugins=function(items){return Promise.all(items.map(mapToId).map(this.uninstallPluginSingle.bind(this))).then(function(result){var instance=this.instance;return _events.default.trigger(instance,"message",[{MessageType:"PluginsUninstalled",Data:{Ids:[],IsLocalEvent:!0}}]),result}.bind({instance:this,items:items}))},ApiClient.prototype.removeVirtualFolder=function(virtualFolder,refreshLibrary){var instance,id,url;if(virtualFolder)return id=virtualFolder.Id,url=(instance=this).getUrl(url="Library/VirtualFolders/Delete",{refreshLibrary:!!refreshLibrary,id:id,name:virtualFolder.Name}),this.ajax({type:"POST",url:url}).then(onItemsDeleted.bind({instance:this,items:[virtualFolder]})).then(function(){instance._userViewsPromise=null});throw new Error("null virtualFolder")},ApiClient.prototype.addVirtualFolder=function(name,type,refreshLibrary,libraryOptions){var options,instance;if(name)return options={},type&&(options.collectionType=type),options.refreshLibrary=!!refreshLibrary,options.name=name,type=this.getUrl(type="Library/VirtualFolders",options),(instance=this).ajax({type:"POST",url:type,data:JSON.stringify({LibraryOptions:libraryOptions}),contentType:"application/json"}).then(function(){instance._userViewsPromise=null});throw new Error("null name")},ApiClient.prototype.updateVirtualFolderOptions=function(id,libraryOptions){var url,instance;if(id)return url=this.getUrl(url="Library/VirtualFolders/LibraryOptions"),(instance=this).ajax({type:"POST",url:url,data:JSON.stringify({Id:id,LibraryOptions:libraryOptions}),contentType:"application/json"}).then(onItemUpdated.bind({instance:this,itemId:id})).then(function(){instance._userViewsPromise=null});throw new Error("null name")},ApiClient.prototype.renameVirtualFolder=function(virtualFolder,newName,refreshLibrary){var url,instance;if(virtualFolder)return url=this.getUrl(url="Library/VirtualFolders/Name",{refreshLibrary:!!refreshLibrary,newName:newName,name:virtualFolder.Name,Id:virtualFolder.Id}),(instance=this).ajax({type:"POST",url:url}).then(onItemUpdated.bind({instance:this,itemId:virtualFolder.Id})).then(function(){instance._userViewsPromise=null});throw new Error("null virtualFolder")},ApiClient.prototype.addMediaPath=function(virtualFolder,pathInfo,refreshLibrary){if(!virtualFolder)throw new Error("null virtualFolder");var url,instance;if(pathInfo)return url=this.getUrl(url="Library/VirtualFolders/Paths",{refreshLibrary:!!refreshLibrary}),(instance=this).ajax({type:"POST",url:url,data:JSON.stringify({Name:virtualFolder.Name,PathInfo:pathInfo,Id:virtualFolder.Id}),contentType:"application/json"}).then(function(){instance._userViewsPromise=null});throw new Error("null pathInfo")},ApiClient.prototype.updateMediaPath=function(virtualFolder,pathInfo){if(!virtualFolder)throw new Error("null virtualFolder");var url,instance;if(pathInfo)return url=this.getUrl(url="Library/VirtualFolders/Paths/Update"),(instance=this).ajax({type:"POST",url:url,data:JSON.stringify({Name:virtualFolder.Name,PathInfo:pathInfo,Id:virtualFolder.Id}),contentType:"application/json"}).then(function(){instance._userViewsPromise=null});throw new Error("null pathInfo")},ApiClient.prototype.removeMediaPath=function(virtualFolder,mediaPath,refreshLibrary){if(!virtualFolder)throw new Error("null virtualFolder");var instance,url;if(mediaPath)return url=(instance=this).getUrl(url="Library/VirtualFolders/Paths/Delete",{refreshLibrary:!!refreshLibrary,path:mediaPath,name:virtualFolder.Name,Id:virtualFolder.Id}),this.ajax({type:"POST",url:url}).then(function(){instance._userViewsPromise=null});throw new Error("null mediaPath")},ApiClient.prototype.deleteUserSingle=function(id){var serverId,instance,url;if(id)return serverId=this.serverId(),url=(instance=this).getUrl("Users/"+id+"/Delete"),this.ajax({type:"POST",url:url}).then(function(){!function(userId,serverId){_servicelocator.appStorage.removeItem(getUserCacheKey(userId,serverId))}(id,serverId),instance._userViewsPromise=null});throw new Error("null id")},ApiClient.prototype.deleteUsers=function(items){return Promise.all(items.map(mapToId).map(this.deleteUserSingle.bind(this))).then(function(result){var instance=this.instance;return _events.default.trigger(instance,"message",[{MessageType:"UsersDeleted",Data:{Ids:[],IsLocalEvent:!0}}]),result}.bind({instance:this,items:items}))},ApiClient.prototype.deleteUser=function(id){return this.deleteUser([{Id:id}])},ApiClient.prototype.deleteUserImage=function(userId,imageType,imageIndex){if(!userId)throw new Error("null userId");var instance;if(imageType)return imageType=this.getUrl("Users/"+userId+"/Images/"+imageType),null!=imageIndex&&(imageType+="/"+imageIndex),(instance=this).ajax({type:"POST",url:imageType+="/Delete"}).then(function(){return updateCachedUser(instance,userId)});throw new Error("null imageType")},ApiClient.prototype.deleteItemImage=function(itemId,imageType,imageIndex){var url;if(imageType)return url=this.getUrl("Items/"+itemId+"/Images"),url+="/"+imageType,null!=imageIndex&&(url+="/"+imageIndex),this.ajax({type:"POST",url:url+="/Delete"}).then(onItemUpdated.bind({instance:this,itemId:itemId}));throw new Error("null imageType")},ApiClient.prototype.deleteItems=function(items){return this.deleteItemsInternal(items).then(onItemsDeleted.bind({instance:this,items:items}))},ApiClient.prototype.deleteItemsInternal=function(items){if(items)return items=items.map(mapToId).filter(isNotLocalId),this.ajax({type:"POST",url:this.getUrl("Items/Delete",{Ids:items.join(",")})});throw new Error("null itemId")},ApiClient.prototype.stopActiveEncodings=function(playSessionId){var options={deviceId:this.deviceId()},playSessionId=(playSessionId&&(options.PlaySessionId=playSessionId),this.getUrl("Videos/ActiveEncodings/Delete",options));return this.ajax({type:"POST",url:playSessionId})},ApiClient.prototype.reportCapabilities=function(options){var url=this.getUrl("Sessions/Capabilities/Full");return this.ajax({type:"POST",url:url,data:JSON.stringify(options),contentType:"application/json"})},ApiClient.prototype.updateItemImageFromUrl=function(itemId,imageType,imageIndex,imageUrl){if(imageType)return this.ajax({type:"POST",url:this.getUrl("Items/"+itemId+"/Images/"+imageType+"/"+(imageIndex=imageIndex||0)+"/Url",{}),data:JSON.stringify({Url:imageUrl}),contentType:"application/json"}).then(onItemUpdated.bind({instance:this,itemId:itemId}));throw new Error("null imageType")},ApiClient.prototype.updateItemImageIndex=function(itemId,imageType,imageIndex,newIndex){if(imageType)return imageType=this.getUrl("Items/"+itemId+"/Images/"+imageType+"/"+(imageIndex=imageIndex||0)+"/Index",{newIndex:newIndex}),this.ajax({type:"POST",url:imageType}).then(onItemUpdated.bind({instance:this,itemId:itemId}));throw new Error("null imageType")},ApiClient.prototype.getItemImageInfos=function(itemId){itemId=this.getUrl("Items/"+itemId+"/Images");return this.getJSON(itemId)},ApiClient.prototype.getCriticReviews=function(itemId,options){if(itemId)return itemId=this.getUrl("Items/"+itemId+"/CriticReviews",options),this.getJSON(itemId);throw new Error("null itemId")},ApiClient.prototype.getItemDownloadUrl=function(itemId,mediaSourceId,serverAddress){if(itemId)return this.getUrl("Items/"+itemId+"/Download",{api_key:this.accessToken(),mediaSourceId:mediaSourceId},serverAddress);throw new Error("itemId cannot be empty")},ApiClient.prototype.getItemOriginalFileUrl=function(itemId,mediaSourceId,serverAddress){if(itemId)return this.getUrl("Items/"+itemId+"/File",{api_key:this.accessToken(),mediaSourceId:mediaSourceId},serverAddress);throw new Error("itemId cannot be empty")},ApiClient.prototype.getSessions=function(options){options=this.getUrl("Sessions",options);return this.getJSON(options)},ApiClient.prototype.uploadUserImage=function(userId,imageType,file){if(!userId)throw new Error("null userId");if(!imageType)throw new Error("null imageType");if(!file)throw new Error("File must be an image.");if("image/png"!==file.type&&"image/jpeg"!==file.type&&"image/jpeg"!==file.type)throw new Error("File must be an image.");var instance=this;return new Promise(function(resolve,reject){var reader=new FileReader;reader.onerror=function(){reject()},reader.onabort=function(){reject()},reader.onload=function(_ref2){var _ref2=_ref2.target.result.split(",")[1],url=instance.getUrl("Users/"+userId+"/Images/"+imageType);instance.ajax({type:"POST",url:url,data:_ref2,contentType:"image/"+file.name.substring(file.name.lastIndexOf(".")+1)}).then(function(){updateCachedUser(instance,userId).then(resolve,reject)},reject)},reader.readAsDataURL(file)})},ApiClient.prototype.uploadItemImage=function(itemId,imageType,imageIndex,file){if(!itemId)throw new Error("null itemId");if(!imageType)throw new Error("null imageType");if(!file)throw new Error("File must be an image.");if("image/png"!==file.type&&"image/jpeg"!==file.type&&"image/jpeg"!==file.type)throw new Error("File must be an image.");var url=this.getUrl("Items/"+itemId+"/Images"),instance=(url+="/"+imageType,this);return null!=imageIndex&&(url+="?Index="+imageIndex),new Promise(function(resolve,reject){var reader=new FileReader;reader.onerror=function(){reject()},reader.onabort=function(){reject()},reader.onload=function(_ref3){_ref3=_ref3.target.result.split(",")[1];instance.ajax({type:"POST",url:url,data:_ref3,contentType:"image/"+file.name.substring(file.name.lastIndexOf(".")+1)}).then(function(result){onItemUpdated.call({instance:instance,itemId:itemId}),resolve(result)},reject)},reader.readAsDataURL(file)})},ApiClient.prototype.getInstalledPlugins=function(){var url=this.getUrl("Plugins",{});return this.getJSON(url)},ApiClient.prototype.getCurrentUserCached=function(){return getCachedUser(this,this.getCurrentUserId())},ApiClient.prototype.getUser=function(id,enableCache,signal){var cachedUser,instance,url;if(id)return!1!==enableCache&&(cachedUser=getCachedUser(this,id))&&Date.now()-(cachedUser.DateLastFetched||0)<=6e4||(url=(instance=this).getUrl("Users/"+id),url=this.getJSON(url,signal).then(function(user){return saveUserInCache(instance,user),user},function(response){if((!signal||!signal.aborted)&&(!response||!response.status)&&instance.isLoggedIn()){var user=getCachedUser(instance,id);if(user)return Promise.resolve(user)}throw response}),!1!==enableCache&&cachedUser)?Promise.resolve(cachedUser):url;throw new Error("Must supply a userId")},ApiClient.prototype.getStudio=function(name,userId){var options;if(name)return options={},userId&&(options.userId=userId),userId=this.getUrl("Studios/"+this.encodeName(name),options),this.getJSON(userId);throw new Error("null name")},ApiClient.prototype.getGenre=function(name,userId){var options;if(name)return options={},userId&&(options.userId=userId),userId=this.getUrl("Genres/"+this.encodeName(name),options),this.getJSON(userId);throw new Error("null name")},ApiClient.prototype.getMusicGenre=function(name,userId){var options;if(name)return options={},userId&&(options.userId=userId),userId=this.getUrl("MusicGenres/"+this.encodeName(name),options),this.getJSON(userId);throw new Error("null name")},ApiClient.prototype.getGameGenre=function(name,userId){var options;if(name)return options={},userId&&(options.userId=userId),userId=this.getUrl("GameGenres/"+this.encodeName(name),options),this.getJSON(userId);throw new Error("null name")},ApiClient.prototype.getArtist=function(name,userId){var options;if(name)return options={},userId&&(options.userId=userId),userId=this.getUrl("Artists/"+this.encodeName(name),options),this.getJSON(userId);throw new Error("null name")},ApiClient.prototype.getPerson=function(name,userId){var options;if(name)return options={},userId&&(options.userId=userId),userId=this.getUrl("Persons/"+this.encodeName(name),options),this.getJSON(userId);throw new Error("null name")},ApiClient.prototype.getPublicUsersQueryResult=function(query,signal){var serverId=this.serverId(),url=this.getUrl("users/public");return this.ajax({type:"GET",url:url,dataType:"json",signal:signal},!1).then(function(users){return setUsersProperties(users,serverId),users}).then(function(users){var totalRecordCount=users.length;return query&&(users=users.slice(query.StartIndex||0),query.Limit)&&users.length>query.Limit&&(users.length=query.Limit),{Items:users,TotalRecordCount:totalRecordCount}})},ApiClient.prototype.getPublicUsers=function(){return this.getPublicUsersQueryResult({}).then(function(result){return result.Items})},ApiClient.prototype.getUsersQueryResult=function(query,signal){var serverId=this.serverId();return this.getJSON(this.getUrl("Users/Query",query),signal).then(function(result){return setUsersProperties(result.Items,serverId),result})},ApiClient.prototype.getUsersForItemAccess=function(query,signal){var serverId=this.serverId();return this.getJSON(this.getUrl("Users/ItemAccess",query),signal).then(function(result){return setUsersProperties(result.Items,serverId),result})},ApiClient.prototype.getUsers=function(query,signal){return this.getUsersQueryResult(query,signal).then(function(result){return result.Items})},ApiClient.prototype.getUserPrefixes=function(query,signal){return this.getJSON(this.getUrl("Users/Prefixes",query),signal)},ApiClient.prototype.getApiKeys=function(query,signal){var instance=this;return this.getJSON(this.getUrl("Auth/Keys",query),signal).then(function(result){return function(instance,response){for(var serverId=instance.serverId(),i=0,length=response.Items.length;i<length;i++){var log=response.Items[i];log.ServerId=serverId,log.Type="ApiKey",log.CanDelete=!0}}(instance,result),result})},ApiClient.prototype.getLogs=function(query,signal){var instance=this;return this.getJSON(this.getUrl("System/Logs/Query",query),signal).then(function(result){return function(instance,items){for(var serverId=instance.serverId(),canDownload=_servicelocator.appHost.supports("filedownload"),i=0,length=items.length;i<length;i++){var log=items[i];log.ServerId=serverId,log.Type="Log",log.Id=log.Name,log.CanDownload=canDownload,log.CanShare=!1}}(instance,result.Items),result})},ApiClient.prototype.getLogDownloadUrl=function(_ref4){var Name=_ref4.Name,Sanitize=_ref4.Sanitize,_ref4=_ref4.SetFilename;return this.getUrl("System/Logs/"+Name,{Sanitize:Sanitize,api_key:this.accessToken(),SetFilename:_ref4})},ApiClient.prototype.getLogLines=function(options,signal){var name=options.name,name=(options.name=null,this.getUrl("System/Logs/"+name+"/Lines",options||{}));return this.getJSON(name,signal)},ApiClient.prototype.getParentalRatings=function(){var url=this.getUrl("Localization/ParentalRatings");return this.getJSON(url)},ApiClient.prototype.getDefaultImageSizes=function(){return StandardWidths.slice(0)},ApiClient.prototype.getImageUrls=function(itemId,imageOptions,sourceOptions){for(var sources=[],originalImageOptions=imageOptions,widths=(null==sourceOptions?void 0:sourceOptions.widths)||StandardWidths,i=0,length=widths.length;i<length;i++)(imageOptions=Object.assign({},originalImageOptions)).adjustForPixelRatio=!1,imageOptions.maxWidth=widths[i],sources.push({url:this.getImageUrl(itemId,imageOptions),width:imageOptions.maxWidth});return sources},ApiClient.prototype.getImageUrl=function(itemId,options){if(itemId)return itemId="Items/"+itemId+"/Images/"+(options=options||{}).type,null!=options.index&&(itemId+="/"+options.index),normalizeImageOptions(this,options),delete options.type,delete options.index,this.getUrl(itemId,options);throw new Error("itemId cannot be empty")},ApiClient.prototype.getLogoImageUrl=function(item,options,preferredLogoImageTypes){for(var i=0,length=(preferredLogoImageTypes=preferredLogoImageTypes||["LogoLightColor","LogoLight","Logo"]).length;i<length;i++){var logoType=preferredLogoImageTypes[i];if(item.ImageTags&&item.ImageTags[logoType])return options.type=logoType,options.tag=item.ImageTags[logoType],this.getImageUrl(item.Id,options)}return item.ParentLogoImageTag?(options.tag=item.ParentLogoImageTag,options.type="Logo",this.getImageUrl(item.ParentLogoItemId,options)):("TvChannel"===item.Type||"ChannelManagementInfo"===item.Type)&&item.ImageTags&&item.ImageTags.Primary?(options.tag=item.ImageTags.Primary,options.type="Primary",this.getImageUrl(item.Id,options)):null},ApiClient.prototype.getUserImageUrl=function(userId,options){if(userId)return userId="Users/"+userId+"/Images/"+(options=options||{}).type,null!=options.index&&(userId+="/"+options.index),normalizeImageOptions(this,options),delete options.type,delete options.index,this.getUrl(userId,options);throw new Error("null userId")},ApiClient.prototype.getThumbImageUrl=function(item,options){if(item)return(options=options||{}).imageType="thumb",item.ImageTags&&item.ImageTags.Thumb?(options.tag=item.ImageTags.Thumb,this.getImageUrl(item.Id,options)):item.ParentThumbItemId?(options.tag=item.ImageTags.ParentThumbImageTag,this.getImageUrl(item.ParentThumbItemId,options)):null;throw new Error("null item")},ApiClient.prototype.updateUserPassword=function(userId,currentPassword,newPassword){var url,instance;return userId?(url=this.getUrl("Users/"+userId+"/Password"),(instance=this).ajax({type:"POST",url:url,data:{CurrentPw:currentPassword||"",NewPw:newPassword}}).then(function(){return updateCachedUser(instance,userId)})):Promise.reject()},ApiClient.prototype.updateProfilePin=function(userId,pin){return this.updatePartialUserConfiguration(userId,{ProfilePin:pin||null})},ApiClient.prototype.updateEasyPassword=function(userId,newPassword){var url,instance=this;return!instance.isMinServerVersion("4.8.0.40")&&userId?(url=this.getUrl("Users/"+userId+"/EasyPassword"),this.ajax({type:"POST",url:url,data:{NewPw:newPassword}}).then(function(){return updateCachedUser(instance,userId)})):Promise.reject()},ApiClient.prototype.resetUserPassword=function(userId){var url,instance;if(userId)return url=this.getUrl("Users/"+userId+"/Password"),(instance=this).ajax({type:"POST",url:url,data:{resetPassword:!0}}).then(function(){return updateCachedUser(instance,userId)});throw new Error("null userId")},ApiClient.prototype.resetEasyPassword=function(userId){var url,instance;if(userId)return url=this.getUrl("Users/"+userId+"/EasyPassword"),(instance=this).ajax({type:"POST",url:url,data:{resetPassword:!0}}).then(function(){return updateCachedUser(instance,userId)});throw new Error("null userId")},ApiClient.prototype.updateServerConfiguration=function(configuration){var url;if(configuration)return url=this.getUrl("System/Configuration"),this.ajax({type:"POST",url:url,data:JSON.stringify(configuration),contentType:"application/json"});throw new Error("null configuration")},ApiClient.prototype.updatePartialServerConfiguration=function(configuration){var url,instance=this;if(!instance.isMinServerVersion("4.8.8"))return instance.getServerConfiguration().then(function(serverConfiguration){return serverConfiguration=Object.assign(serverConfiguration,configuration),instance.updateServerConfiguration(serverConfiguration)});if(configuration)return url=this.getUrl("System/Configuration/Partial"),this.ajax({type:"POST",url:url,data:JSON.stringify(configuration),contentType:"application/json"});throw new Error("null configuration")},ApiClient.prototype.updateNamedConfiguration=function(name,configuration){if(configuration)return name=this.getUrl("System/Configuration/"+name),this.ajax({type:"POST",url:name,data:JSON.stringify(configuration),contentType:"application/json"});throw new Error("null configuration")},ApiClient.prototype.getTypedUserSettings=function(userId,key){userId=this.getUrl("Users/"+userId+"/TypedSettings/"+key);return this.getJSON(userId)},ApiClient.prototype.updateTypedUserSettings=function(userId,key,configuration){if(configuration)return userId=this.getUrl("Users/"+userId+"/TypedSettings/"+key),this.ajax({type:"POST",url:userId,data:JSON.stringify(configuration),contentType:"application/json"});throw new Error("null configuration")},ApiClient.prototype.getTunerHostConfiguration=function(id){return this.getNamedConfiguration("livetv").then(function(config){return config.TunerHosts.filter(function(i){return i.Id===id})[0]})},ApiClient.prototype.saveTunerHostConfiguration=function(tunerHostInfo){return this.ajax({type:"POST",url:this.getUrl("LiveTv/TunerHosts"),data:JSON.stringify(tunerHostInfo),contentType:"application/json",dataType:"json"})},ApiClient.prototype.getDefaultTunerHostConfiguration=function(type){return this.getJSON(this.getUrl("LiveTv/TunerHosts/Default/"+type))},ApiClient.prototype.updateItem=function(item){var url;if(item)return url=this.getUrl("Items/"+item.Id),this.ajax({type:"POST",url:url,data:JSON.stringify(item),contentType:"application/json"}).then(onItemUpdated.bind({instance:this,itemId:item.Id}));throw new Error("null item")},ApiClient.prototype.updatePluginSecurityInfo=function(info){var url=this.getUrl("Plugins/SecurityInfo");return this.ajax({type:"POST",url:url,data:JSON.stringify(info),contentType:"application/json"})},ApiClient.prototype.createUser=function(options){var url=this.getUrl("Users/New");return this.ajax({type:"POST",url:url,data:options,dataType:"json"})},ApiClient.prototype.updateUser=function(user){var url;if(user)return url=this.getUrl("Users/"+user.Id),this.ajax({type:"POST",url:url,data:JSON.stringify(user),contentType:"application/json"});throw new Error("null user")},ApiClient.prototype.updateUserPolicy=function(userId,policy){if(!userId)throw new Error("null userId");var url,instance;if(policy)return url=this.getUrl("Users/"+userId+"/Policy"),(instance=this).ajax({type:"POST",url:url,data:JSON.stringify(policy),contentType:"application/json"}).then(function(){return instance.getCurrentUserId()===userId&&(instance._userViewsPromise=null),updateCachedUser(instance,userId)});throw new Error("null policy")},ApiClient.prototype.updateUserConfiguration=function(userId,configuration){if(!userId)throw new Error("null userId");var url,instance;if(configuration)return url=this.getUrl("Users/"+userId+"/Configuration"),(instance=this).ajax({type:"POST",url:url,data:JSON.stringify(configuration),contentType:"application/json"}).then(function(){return instance.getCurrentUserId()===userId&&(instance._userViewsPromise=null),updateCachedUser(instance,userId)});throw new Error("null configuration")},ApiClient.prototype.updatePartialUserConfiguration=function(userId,configuration){var url,instance=this;if(!instance.isMinServerVersion("4.8.0.48"))return instance.getUser(userId).then(function(user){return user.Configuration=Object.assign(user.Configuration,configuration),instance.updateUserConfiguration(userId,user.Configuration)});if(!userId)throw new Error("null userId");if(configuration)return url=this.getUrl("Users/"+userId+"/Configuration/Partial"),this.ajax({type:"POST",url:url,data:JSON.stringify(configuration),contentType:"application/json"}).then(function(){return instance.getCurrentUserId()===userId&&(instance._userViewsPromise=null),function(instance,userId,config){var user=getCachedUser(instance,userId);return user?(user.Configuration=Object.assign(user.Configuration,config||{}),saveUserInCache(instance,user),Promise.resolve()):updateCachedUser(instance,userId)}(instance,userId,configuration)});throw new Error("null configuration")},ApiClient.prototype.updateScheduledTaskTriggers=function(id,triggers){if(!id)throw new Error("null id");if(!triggers)throw new Error("null triggers");for(var i=0,length=(triggers=JSON.parse(JSON.stringify(triggers))).length;i<length;i++){var trigger=triggers[i];trigger.TriggerType&&(trigger.Type=trigger.TriggerType)}id=this.getUrl("ScheduledTasks/"+id+"/Triggers");return this.ajax({type:"POST",url:id,data:JSON.stringify(triggers),contentType:"application/json"}).then(function(result){var instance=this.instance;return _events.default.trigger(instance,"message",[{MessageType:"ScheduledTaskTriggersUpdated",Data:{Ids:[],IsLocalEvent:!0}}]),result}.bind({instance:this,items:triggers}))},ApiClient.prototype.updatePluginConfiguration=function(id,configuration){if(!id)throw new Error("null Id");if(configuration)return id=this.getUrl("Plugins/"+id+"/Configuration"),this.ajax({type:"POST",url:id,data:JSON.stringify(configuration),contentType:"application/json"});throw new Error("null configuration")},ApiClient.prototype.getAncestorItems=function(itemId,userId){var options;if(itemId)return options={},userId&&(options.userId=userId),userId=this.getUrl("Items/"+itemId+"/Ancestors",options),this.getJSON(userId);throw new Error("null itemId")},ApiClient.prototype.getItems=function(userId,options,signal){return options&&null!=options.IsNewOrPremiere&&!this.isMinServerVersion("4.8.0.48")?Promise.resolve({Items:[],TotalRecordCount:0}):(normalizeFields(options),userId="string"===(typeof userId).toString().toLowerCase()?this.getUrl("Users/"+userId+"/Items",options):this.getUrl("Items",options),this.getJSON(userId,signal))},ApiClient.prototype.getLiveTvChannelTags=function(options,signal){(options=options||{}).UserId=this.getCurrentUserId();options=this.getUrl("LiveTv/ChannelTags",options);return this.getJSON(options,signal)},ApiClient.prototype.getLiveTvChannelTagPrefixes=function(options,signal){(options=options||{}).UserId=this.getCurrentUserId();options=this.getUrl("LiveTv/ChannelTags/Prefixes",options);return this.getJSON(options,signal)},ApiClient.prototype.getResumableItems=function(userId,options,signal){return this.getJSON(this.getUrl("Users/"+userId+"/Items/Resume",options),signal)},ApiClient.prototype.getMovieRecommendations=function(options,signal){return this.getJSON(this.getUrl("Movies/Recommendations",options),signal)},ApiClient.prototype.getUpcomingEpisodes=function(options,signal){return this.getJSON(this.getUrl("Shows/Upcoming",options),signal)},ApiClient.prototype.getMissingEpisodes=function(options,signal){return this.isMinServerVersion("4.8.0.59")?this.getJSON(this.getUrl("Shows/Missing",options),signal):Promise.resolve({Items:[],TotalRecordCount:0})},ApiClient.prototype.getUserViews=function(options,userId,signal){var self,currentUserId=this.getCurrentUserId(),currentUserId=!((userId=userId||currentUserId)!==currentUserId||options&&options.IncludeHidden);return currentUserId&&this._userViewsPromise?this._userViewsPromise:(userId=this.getUrl("Users/"+userId+"/Views",options),options=(self=this).getJSON(userId,signal).catch(function(err){return self._userViewsPromise=null,Promise.reject(err)}),currentUserId&&(this._userViewsPromise=options),options)},ApiClient.prototype.getArtists=function(userId,options,signal){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId,!options.ArtistType&&this.isMinServerVersion("4.9.0.43")&&(options.ArtistType="all");userId=this.getUrl("Artists",options);return this.getJSON(userId,signal)},ApiClient.prototype.getAlbumArtists=function(userId,options,signal){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("Artists/AlbumArtists",options);return this.getJSON(userId,signal)},ApiClient.prototype.getGenres=function(userId,options,signal){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("Genres",options);return this.getJSON(userId,signal)},ApiClient.prototype.getMusicGenres=function(userId,options,signal){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("MusicGenres",options);return this.getJSON(userId,signal)},ApiClient.prototype.getGameGenres=function(userId,options,signal){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("GameGenres",options);return this.getJSON(userId,signal)},ApiClient.prototype.getPeople=function(userId,options,signal){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("Persons",options);return this.getJSON(userId,signal)},ApiClient.prototype.getThumbnails=function(itemId,options){return isLocalId(itemId)?Promise.resolve({Thumbnails:[]}):(itemId=this.getUrl("Items/"+itemId+"/ThumbnailSet",options),this.getJSON(itemId))},ApiClient.prototype.getDeleteInfo=function(itemId,options){return isLocalId(itemId)?Promise.resolve({Paths:[]}):(itemId=this.getUrl("Items/"+itemId+"/DeleteInfo",options),this.getJSON(itemId))},ApiClient.prototype.getStudios=function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("Studios",options);return this.getJSON(userId)},ApiClient.prototype.getOfficialRatings=function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("OfficialRatings",options);return this.getJSON(userId)},ApiClient.prototype.getYears=function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("Years",options);return this.getJSON(userId)},ApiClient.prototype.getTags=function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("Tags",options),options=this.getJSON(userId),userId=function(result){for(var serverId=this.serverId(),items=result.Items||result,i=0,length=items.length;i<length;i++){var item=items[i];item.ServerId=serverId,item.Type="Tag"}return result}.bind(this);return options.then(userId)},ApiClient.prototype.getItemTypes=function(userId,options,signal){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("ItemTypes",options);return this.getJSON(userId,signal)},ApiClient.prototype.getContainers=function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("Containers",options);return this.getJSON(userId)},ApiClient.prototype.getAudioCodecs=function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("AudioCodecs",options);return this.getJSON(userId)},ApiClient.prototype.getAudioLayouts=function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("AudioLayouts",options),userId=this.getJSON(userId);return this.isMinServerVersion("4.8.0.23")?userId:function(promise,query){return promise.then(function(result){var outerIds=query.OuterIds?query.OuterIds.split(","):[];return outerIds.length&&(result.Items=result.Items.filter(function(i){return outerIds.includes(i.Id)})),result.TotalRecordCount||!1===query.EnableTotalRecordCount||(result.TotalRecordCount=result.Items.length),result})}(userId,options)},ApiClient.prototype.getStreamLanguages=function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("StreamLanguages",options);return this.getJSON(userId)},ApiClient.prototype.getVideoCodecs=function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("VideoCodecs",options);return this.getJSON(userId)},ApiClient.prototype.getExtendedVideoTypes=function(userId,options){if(!this.isMinServerVersion("4.8.0.47"))return Promise.resolve({Items:[],TotalRecordCount:0});if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("ExtendedVideoTypes",options);return this.getJSON(userId)},ApiClient.prototype.getSubtitleCodecs=function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("SubtitleCodecs",options);return this.getJSON(userId)},ApiClient.prototype.getPrefixes=function(userId,options){if(userId)return(options=options||{}).userId=userId,isLocalId(options.ParentId)||isLocalId(options.GenreIds)||isLocalId(options.ArtistIds)||isLocalId(options.StudioIds)?Promise.resolve([]):(userId=this.getUrl("Items/Prefixes",options),this.getJSON(userId));throw new Error("null userId")},ApiClient.prototype.getArtistPrefixes=function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("Artists/Prefixes",options);return this.getJSON(userId)},ApiClient.prototype.getLocalTrailers=function(userId,itemId){if(!userId)throw new Error("null userId");if(itemId)return userId=this.getUrl("Users/"+userId+"/Items/"+itemId+"/LocalTrailers"),this.getJSON(userId);throw new Error("null itemId")},ApiClient.prototype.getAllTrailers=function(query,item){return(item.LocalTrailerCount&&!1!==query.LocalTrailers?this.getLocalTrailers(this.getCurrentUserId(),item.Id):Promise.resolve([])).then(function(localTrailers){var trailers=localTrailers.splice(0);if(item.RemoteTrailers&&!1!==query.RemoteTrailers)for(var i=0,length=item.RemoteTrailers.length;i<length;i++)trailers.push(item.RemoteTrailers[i]);var localTrailers=(((item.MediaSources||[])[0]||{}).MediaStreams||[]).filter(function(i){return"Video"===i.Type})[0]||{},aspect=null;localTrailers.Width&&localTrailers.Height&&(aspect=localTrailers.Width/localTrailers.Height);for(var _i=0,_length=trailers.length;_i<_length;_i++){var trailer=trailers[_i];trailer.Name||(trailer.Name="Trailer: "+item.Name),trailer.Type||(trailer.Type="Trailer"),trailer.ServerId||(trailer.ServerId=item.ServerId),trailer.MediaType||(trailer.MediaType="Video"),trailer.PrimaryImageAspectRatio||(trailer.PrimaryImageAspectRatio=aspect),trailer.ImageTags&&trailer.ImageTags.Thumb||(item.ImageTags&&item.ImageTags.Thumb?(trailer.ParentThumbItemId=item.Id,trailer.ParentThumbImageTag=item.ImageTags.Thumb):(trailer.ParentThumbItemId=item.ParentThumbItemId,trailer.ParentThumbImageTag=item.ParentThumbImageTag)),trailer.ParentBackdropImageTags&&trailer.ParentBackdropImageTags.length||(trailer.ParentBackdropItemId=item.Id,trailer.ParentBackdropImageTags=item.BackdropImageTags)}localTrailers=trailers.length;return query&&(trailers=trailers.slice(query.StartIndex||0),query.Limit)&&trailers.length>query.Limit&&(trailers.length=query.Limit),Promise.resolve({Items:trailers,TotalRecordCount:localTrailers})})},ApiClient.prototype.getGameSystems=function(){var options={},userId=this.getCurrentUserId(),userId=(userId&&(options.userId=userId),this.getUrl("Games/SystemSummaries",options));return this.getJSON(userId)},ApiClient.prototype.getAdditionalVideoParts=function(userId,itemId,mediaSourceId){var options;if(itemId)return isLocalId(itemId)||isLocalId(mediaSourceId)?Promise.resolve([]):(options={},userId&&(options.userId=userId),mediaSourceId&&(options.mediaSourceId=mediaSourceId),userId=this.getUrl("Videos/"+itemId+"/AdditionalParts",options),this.getJSON(userId));throw new Error("null itemId")},ApiClient.prototype.getThemeMedia=function(itemId,options,signal){return isLocalId(itemId)?Promise.resolve({ThemeVideosResult:{Items:[],TotalRecordCount:0},ThemeSongsResult:{Items:[],TotalRecordCount:0}}):(itemId=this.getUrl("Items/"+itemId+"/ThemeMedia",options),this.getJSON(itemId,signal))},ApiClient.prototype.getAudioStreamUrl=function(_ref5,_ref6,directPlayContainers,maxBitrate,maxAudioSampleRate,maxAudioBitDepth,startPosition,enableRemoteMedia){var _ref5=_ref5.Id,Container=_ref6.Container,Protocol=_ref6.Protocol,_ref6=_ref6.AudioCodec;return startingPlaySession++,this.getUrl("Audio/"+_ref5+"/universal",{UserId:this.getCurrentUserId(),DeviceId:this.deviceId(),MaxStreamingBitrate:maxBitrate,Container:directPlayContainers,TranscodingContainer:Container||null,TranscodingProtocol:Protocol||null,AudioCodec:_ref6,MaxAudioSampleRate:maxAudioSampleRate,MaxAudioBitDepth:maxAudioBitDepth,api_key:this.accessToken(),PlaySessionId:startingPlaySession,StartTimeTicks:startPosition||0,EnableRedirection:!0,EnableRemoteMedia:enableRemoteMedia})},ApiClient.prototype.getAudioStreamUrls=function(items,transcodingProfile,directPlayContainers,maxBitrate,maxAudioSampleRate,maxAudioBitDepth,startPosition,enableRemoteMedia){for(var streamUrls=[],i=0,length=items.length;i<length;i++){var item=items[i],streamUrl=void 0;"Audio"===item.MediaType&&(streamUrl=this.getAudioStreamUrl(item,transcodingProfile,directPlayContainers,maxBitrate,maxAudioSampleRate,maxAudioBitDepth,startPosition,enableRemoteMedia)),streamUrls.push(streamUrl||""),0===i&&(startPosition=0)}return Promise.resolve(streamUrls)},ApiClient.prototype.getSpecialFeatures=function(userId,itemId,options){if(!userId)throw new Error("null userId");if(itemId)return isLocalId(itemId)?Promise.resolve([]):(userId=this.getUrl("Users/"+userId+"/Items/"+itemId+"/SpecialFeatures",options),this.getJSON(userId));throw new Error("null itemId")},ApiClient.prototype.getDateParamValue=function(date){function formatDigit(i){return i<10?"0"+i:i}return""+date.getFullYear()+formatDigit(date.getMonth()+1)+formatDigit(date.getDate())+formatDigit(date.getHours())+formatDigit(date.getMinutes())+formatDigit(date.getSeconds())},ApiClient.prototype.markPlayed=function(userId,itemIds,date){if(!userId)throw new Error("null userId");var instance;if(itemIds)return instance=this,itemIds=itemIds.filter(isNotLocalId),Promise.all(itemIds.map(function(itemId){var options={},options=(date&&(options.DatePlayed=instance.getDateParamValue(date)),instance.getUrl("Users/"+userId+"/PlayedItems/"+itemId,options));return instance.ajax({type:"POST",url:options,dataType:"json"}).then(onUserDataUpdated.bind({instance:instance,userId:userId,itemId:itemId}))}));throw new Error("null itemIds")},ApiClient.prototype.markUnplayed=function(userId,itemIds){if(!userId)throw new Error("null userId");var instance;if(itemIds)return instance=this,itemIds=itemIds.filter(isNotLocalId),Promise.all(itemIds.map(function(itemId){var url=instance.getUrl("Users/"+userId+"/PlayedItems/"+itemId+"/Delete");return instance.ajax({type:"POST",url:url,dataType:"json"}).then(onUserDataUpdated.bind({instance:instance,userId:userId,itemId:itemId}))}));throw new Error("null itemIds")},ApiClient.prototype.updateFavoriteStatus=function(userId,itemIds,isFavorite){if(!userId)throw new Error("null userId");var instance;if(itemIds)return instance=this,itemIds=itemIds.filter(isNotLocalId),Promise.all(itemIds.map(function(itemId){var url=isFavorite?instance.getUrl("Users/"+userId+"/FavoriteItems/"+itemId):instance.getUrl("Users/"+userId+"/FavoriteItems/"+itemId+"/Delete");return instance.ajax({type:"POST",url:url,dataType:"json"}).then(onUserDataUpdated.bind({instance:instance,userId:userId,itemId:itemId}))}));throw new Error("null itemIds")},ApiClient.prototype.updateUserItemRating=function(userId,itemId,likes){if(!userId)throw new Error("null userId");if(itemId)return likes=this.getUrl("Users/"+userId+"/Items/"+itemId+"/Rating",{likes:likes}),this.ajax({type:"POST",url:likes,dataType:"json"}).then(onUserDataUpdated.bind({instance:this,userId:userId,itemId:itemId}));throw new Error("null itemId")},ApiClient.prototype.updateHideFromResume=function(itemIds,hide){var userId,instance;if(itemIds)return userId=this.getCurrentUserId(),instance=this,Promise.all(itemIds.map(function(itemId){var url=instance.getUrl("Users/"+userId+"/Items/"+itemId+"/HideFromResume",{Hide:!1!==hide});return instance.ajax({type:"POST",url:url,dataType:"json"}).then(onUserDataUpdated.bind({instance:instance,userId:userId,itemId:itemId}))}));throw new Error("null itemIds")},ApiClient.prototype.getItemCounts=function(userId){var options={},userId=(userId&&(options.userId=userId),this.getUrl("Items/Counts",options));return this.getJSON(userId)},ApiClient.prototype.clearUserItemRating=function(userId,itemId){if(!userId)throw new Error("null userId");var url;if(itemId)return url=this.getUrl("Users/"+userId+"/Items/"+itemId+"/Rating/Delete"),this.ajax({type:"POST",url:url,dataType:"json"}).then(onUserDataUpdated.bind({instance:this,userId:userId,itemId:itemId}));throw new Error("null itemId")},ApiClient.prototype.reportPlaybackStart=function(options){if(!options)throw new Error("null options");if(isLocalId(options.ItemId))return Promise.resolve();this.lastPlaybackProgressReport=0,this.lastPlaybackProgressReportTicks=null;var url=this.getUrl("Sessions/Playing"),url=this.ajax({type:"POST",data:JSON.stringify(options),contentType:"application/json",url:url});return options.ItemId&&!isLocalId(options.ItemId)&&this.ensureWebSocket(),url},ApiClient.prototype.shouldSkipProgressReport=function(eventName,positionTicks){if("timeupdate"===(eventName||"timeupdate")){eventName=Date.now()-(this.lastPlaybackProgressReport||0);if(eventName<=1e4){if(!positionTicks)return Promise.resolve();eventName=1e4*eventName+(this.lastPlaybackProgressReportTicks||0);if(Math.abs((positionTicks||0)-eventName)<5e7)return Promise.resolve()}}return!1},ApiClient.prototype.reportPlaybackProgress=function(options){if(!options)throw new Error("null options");var newPositionTicks=options.PositionTicks;if("timeupdate"===(options.EventName||"timeupdate")){var now=Date.now(),msSinceLastReport=now-(this.lastPlaybackProgressReport||0);if(msSinceLastReport<=1e4){if(!newPositionTicks)return Promise.resolve();msSinceLastReport=1e4*msSinceLastReport+(this.lastPlaybackProgressReportTicks||0);if(Math.abs((newPositionTicks||0)-msSinceLastReport)<5e7)return Promise.resolve()}this.lastPlaybackProgressReport=now}else this.lastPlaybackProgressReport=0;this.lastPlaybackProgressReportTicks=newPositionTicks;msSinceLastReport=this.getUrl("Sessions/Playing/Progress");return this.ajax({type:"POST",data:JSON.stringify(options),contentType:"application/json",url:msSinceLastReport})},ApiClient.prototype.reportOfflineActions=function(actions){var url;if(actions)return url=this.getUrl("Sync/OfflineActions"),this.ajax({type:"POST",data:JSON.stringify(actions),contentType:"application/json",url:url});throw new Error("null actions")},ApiClient.prototype.syncData=function(data){var url;if(data)return url=this.getUrl("Sync/Data"),this.ajax({type:"POST",data:JSON.stringify(data),contentType:"application/json",url:url,dataType:"json"});throw new Error("null data")},ApiClient.prototype.getReadySyncItems=function(deviceId){if(deviceId)return deviceId=this.getUrl("Sync/Items/Ready",{TargetId:deviceId}),this.getJSON(deviceId);throw new Error("null deviceId")},ApiClient.prototype.getSyncJobs=function(query){var instance=this,mode=query.mode;return delete query.mode,instance.getJSON(instance.getUrl("Sync/Jobs",query)).then(function(result){for(var items=result.Items,i=0,length=items.length;i<length;i++){var item=items[i];item.SyncJobType="convert"===mode?"Convert":"Download",!function(item,apiClient){item.Type="SyncJob",item.ServerId=apiClient.serverId()}(item,instance)}return result})},ApiClient.prototype.createSyncJob=function(options){return this.ajax({type:"POST",url:this.getUrl("Sync/Jobs"),data:JSON.stringify(options),contentType:"application/json",dataType:"json"}).then(function(result){var instance=this.instance;return _events.default.trigger(instance,"message",[{MessageType:"SyncJobCreated",Data:{IsLocalEvent:!0}}]),result}.bind({instance:this}))},ApiClient.prototype.reportSyncJobItemTransferred=function(syncJobItemId){if(syncJobItemId)return syncJobItemId=this.getUrl("Sync/JobItems/"+syncJobItemId+"/Transferred"),this.ajax({type:"POST",url:syncJobItemId});throw new Error("null syncJobItemId")},ApiClient.prototype.cancelSyncItems=function(itemIds,targetId){if(itemIds)return targetId="Sync/"+(targetId||this.deviceId())+"/Items/Delete",this.ajax({type:"POST",url:this.getUrl(targetId,{ItemIds:itemIds.join(",")})});throw new Error("null itemIds")},ApiClient.prototype.clearUserTrackSelections=function(userId,type){var instance;if(userId)return type=(instance=this).getUrl("Users/"+userId+"/TrackSelections/"+type+"/Delete"),this.ajax({type:"POST",url:type}).then(function(){return updateCachedUser(instance,userId)});throw new Error("null userId")},ApiClient.prototype.reportPlaybackStopped=function(options){if(!options)throw new Error("null options");this.lastPlaybackProgressReport=0,this.lastPlaybackProgressReportTicks=null;var url=this.getUrl("Sessions/Playing/Stopped");return this.ajax({type:"POST",data:JSON.stringify(options),contentType:"application/json",url:url})},ApiClient.prototype.sendPlayCommand=function(sessionId,options){if(!sessionId)throw new Error("null sessionId");if(options)return sessionId=this.getUrl("Sessions/"+sessionId+"/Playing",options),this.ajax({type:"POST",url:sessionId});throw new Error("null options")},ApiClient.prototype.sendCommand=function(sessionId,command){if(!sessionId)throw new Error("null sessionId");if(command)return(sessionId={type:"POST",url:this.getUrl("Sessions/"+sessionId+"/Command")}).data=JSON.stringify(command),sessionId.contentType="application/json",this.ajax(sessionId);throw new Error("null command")},ApiClient.prototype.sendMessageCommand=function(sessionId,options){if(!sessionId)throw new Error("null sessionId");if(options)return(sessionId={type:"POST",url:this.getUrl("Sessions/"+sessionId+"/Message")}).data=JSON.stringify(options),sessionId.contentType="application/json",this.ajax(sessionId);throw new Error("null options")},ApiClient.prototype.sendPlayStateCommand=function(sessionId,command,options){if(!sessionId)throw new Error("null sessionId");if(command)return sessionId=this.getUrl("Sessions/"+sessionId+"/Playing/"+command,options||{}),this.ajax({type:"POST",url:sessionId});throw new Error("null command")},ApiClient.prototype.getSavedEndpointInfo=function(){return this._endPointInfo},ApiClient.prototype.getEndpointInfo=function(signal){var instance,savedValue=this._endPointInfo;return savedValue?Promise.resolve(savedValue):(instance=this).getJSON(this.getUrl("System/Endpoint"),signal).then(function(endPointInfo){return endPointInfo.NetworkType=function(endpointInfo){if(endpointInfo.IsInNetwork)return"lan";if("undefined"!=typeof navigator){endpointInfo=navigator.connection;if(endpointInfo){if("cellular"===endpointInfo.type)return"cellular";endpointInfo=endpointInfo.effectiveType;if("slow-2g"===endpointInfo||"2g"===endpointInfo||"3g"===endpointInfo)return"cellular"}}return"wan"}(endPointInfo),instance._endPointInfo=endPointInfo})},ApiClient.prototype.getWakeOnLanInfo=function(){return this.getJSON(this.getUrl("System/WakeOnLanInfo"))},ApiClient.prototype.getLatestItems=function(){var options=0<arguments.length&&void 0!==arguments[0]?arguments[0]:{};return this.getJSON(this.getUrl("Users/"+this.getCurrentUserId()+"/Items/Latest",options))},ApiClient.prototype.getPlayQueue=function(options){return this.getJSON(this.getUrl("Sessions/PlayQueue",options))},ApiClient.prototype.supportsWakeOnLan=function(){return!!_servicelocator.wakeOnLan.isSupported()&&0<getCachedWakeOnLanInfo(this).length},ApiClient.prototype.wakeOnLan=function(){return function sendNextWakeOnLan(infos,index){var info;return index>=infos.length?Promise.resolve():(info=infos[index],console.log("sending wakeonlan to "+info.MacAddress),_servicelocator.wakeOnLan.send(info).then(goNext,goNext));function goNext(){return sendNextWakeOnLan(infos,index+1)}}(getCachedWakeOnLanInfo(this),0)},ApiClient.prototype.getAddToPlaylistInfo=function(userId,id,addIds){return this.isMinServerVersion("4.8.0.30")?(id=this.getUrl("Playlists/"+id+"/AddToPlaylistInfo",{Ids:addIds,userId:userId}),this.getJSON(id)):Promise.resolve({ContainsDuplicates:!1,ItemCount:addIds.length})},ApiClient.prototype.addToList=function(userId,type,id,addIds,skipDuplicates){var url=this.getUrl(("BoxSet"===type||"Collection"===type?"Collections":"Playlists")+"/"+id+"/Items"),dataType="Playlist"===type&&this.isMinServerVersion("4.8.0.30")?"json":null,instance=this;return this.ajax({type:"POST",url:url,dataType:dataType,data:JSON.stringify({Ids:addIds.join(","),userId:userId,SkipDuplicates:"Playlist"===type?skipDuplicates:null}),contentType:"application/json"}).then(function(result){return null==(result=result||{}).ItemAddedCount&&(result.ItemAddedCount=addIds.length),onItemUpdated.call({instance:instance,itemId:id},result)})},ApiClient.prototype.createList=function(userId,type,name,addIds){type=this.getUrl("BoxSet"===type||"Collection"===type?"Collections":"Playlists",{Name:name,Ids:addIds,userId:userId});return this.ajax({type:"POST",url:type,dataType:"json"}).then(function(result){return null==(result=result||{}).ItemAddedCount&&(result.ItemAddedCount=(addIds||[]).length),Promise.resolve(result)})},ApiClient.prototype.setSystemInfo=function(systemInfo){var instance,info;null!=systemInfo.HasImageEnhancers&&(this.hasImageEnhancers=systemInfo.HasImageEnhancers),systemInfo.WakeOnLanInfo&&(instance=this,info=systemInfo.WakeOnLanInfo,instance=instance.serverId(),_servicelocator.appStorage.setItem("server-"+instance+"-wakeonlaninfo",JSON.stringify(info))),this._serverVersion=systemInfo.Version},ApiClient.prototype.serverVersion=function(){return this._serverVersion},ApiClient.prototype.isMinServerVersion=function(version){var serverVersion=this.serverVersion();return!!serverVersion&&0<=function(a,b){a=a.split("."),b=b.split(".");for(var i=0,length=Math.max(a.length,b.length);i<length;i++){var aVal=parseInt(a[i]||"0"),bVal=parseInt(b[i]||"0");if(aVal<bVal)return-1;if(bVal<aVal)return 1}return 0}(serverVersion,version)},ApiClient.prototype.handleMessageReceived=function(msg){onMessageReceivedInternal(this,msg)},ApiClient.prototype.getSearchResults=function(query,signal){var promises;return!query.SearchTerm||query.SearchTerm.length<1?Promise.resolve({Items:[],TotalRecordCount:0,ItemTypes:[]}):((promises=[]).push(this.getItems(this.getCurrentUserId(),query,signal)),query.StartIndex||query.IncludeItemTypes||!1===query.IncludeSearchTypes||promises.push(this.getItemTypes(this.getCurrentUserId(),query,signal)),Promise.all(promises).then(function(responses){return 1<responses.length&&(responses[0].ItemTypes=responses[1].Items),responses[0]}))},ApiClient.prototype.getToneMapOptions=function(){var url=this.getUrl("Encoding/ToneMapOptions");return this.getJSON(url)},ApiClient.prototype.moveItemsInPlaylist=function(playlistId,items,newIndex){for(var playlistItemIds=[],i=0,length=items.length;i<length;i++)items[i].PlaylistItemId&&playlistItemIds.push(items[i].PlaylistItemId);var playlistItemId=items[0].PlaylistItemId;return this.ajax({url:this.getUrl("Playlists/"+playlistId+"/Items/"+playlistItemId+"/Move/"+newIndex),type:"POST"}).then(function(result){var instance=this.instance,playlistItemIds=this.playlistItemIds,playlistId=this.playlistId;return _events.default.trigger(instance,"message",[{MessageType:"ItemsMovedInPlaylist",Data:{PlaylistId:playlistId,PlaylistItemIds:playlistItemIds,IsLocalEvent:!0}}]),result}.bind({instance:this,playlistItemIds:playlistItemIds,playlistId:playlistId}))},ApiClient.prototype.removeItemsFromPlaylist=function(playlistId,items){for(var playlistItemIds=[],i=0,length=items.length;i<length;i++)items[i].PlaylistItemId&&playlistItemIds.push(items[i].PlaylistItemId);return this.ajax({url:this.getUrl("Playlists/"+playlistId+"/Items/Delete",{EntryIds:playlistItemIds.join(",")}),type:"POST"}).then(function(result){var instance=this.instance,playlistItemIds=this.playlistItemIds,playlistId=this.playlistId;return _events.default.trigger(instance,"message",[{MessageType:"ItemsRemovedFromPlaylist",Data:{PlaylistId:playlistId,PlaylistItemIds:playlistItemIds,IsLocalEvent:!0}}]),result}.bind({instance:this,playlistItemIds:playlistItemIds,playlistId:playlistId}))},ApiClient.prototype.removeItemsFromCollection=function(collectionId,items){for(var itemIds=[],i=0,length=items.length;i<length;i++)itemIds.push(items[i].Id);return this.ajax({url:this.getUrl("Collections/"+collectionId+"/Items/Delete",{Ids:itemIds.join(",")}),type:"POST"}).then(function(result){for(var instance=this.instance,collections=this.collections,i=0,length=collections.length;i<length;i++){var collection=collections[i];_events.default.trigger(instance,"message",[{MessageType:"ItemsRemovedFromCollection",Data:{CollectionId:collection.Id,ItemIds:collection.ItemIds,IsLocalEvent:!0}}])}return result}.bind({instance:this,collections:[{Id:collectionId,ItemIds:itemIds}]}))},ApiClient.prototype.removeItemsFromCollections=function(collections){var instance=this;return Promise.all(collections.map(function(collection){return instance.removeItemsFromCollection(collection.Id,collection.ItemIds.map(function(i){return{Id:i}}))}))},ApiClient.prototype.reconnectTest=function(signal){return tryReconnect(this,signal)},ApiClient.prototype.mergeVersions=function(items){var instance=this;return this.ajax({type:"POST",url:this.getUrl("Videos/MergeVersions",{Ids:items.map(mapToId).join(",")})}).then(function(result){return _events.default.trigger(instance,"message",[{MessageType:"ItemsMerged",Data:{Items:items.map(mapToId),IsLocalEvent:!0}}]),result})},ApiClient.prototype.ungroupVersions=function(id){var instance=this;return instance.ajax({type:"POST",url:instance.getUrl("Videos/"+id+"/AlternateSources/Delete")}).then(function(result){return _events.default.trigger(instance,"message",[{MessageType:"ItemsSplit",Data:{Items:[id],IsLocalEvent:!0}}]),result})},ApiClient.prototype.makePublic=function(itemId){return this.ajax({type:"POST",url:this.getUrl("Items/"+itemId+"/MakePublic")}).then(onItemUpdated.bind({instance:this,itemId:itemId}))},ApiClient.prototype.makePrivate=function(itemId){return this.ajax({type:"POST",url:this.getUrl("Items/"+itemId+"/MakePrivate")}).then(onItemUpdated.bind({instance:this,itemId:itemId}))},ApiClient.prototype.updateUserItemAccess=function(options){return this.ajax({type:"POST",url:this.getUrl("Items/Access"),data:JSON.stringify(options),contentType:"application/json"})},ApiClient.prototype.leaveSharedItems=function(options){return this.ajax({type:"POST",url:this.getUrl("Items/Shared/Leave"),data:JSON.stringify(options),contentType:"application/json"}).then(onItemsDeleted.bind({instance:this,items:options.ItemIds.map(function(i){return{Id:i}})}))},ApiClient.prototype.downloadSubtitles=function(itemId,mediaSourceId,id){return this.ajax({type:"POST",url:this.getUrl("Items/"+itemId+"/RemoteSearch/Subtitles/"+id,{MediaSourceId:mediaSourceId}),dataType:"json"}).then(onItemUpdated.bind({instance:this,itemId:itemId}))},ApiClient.prototype.resetMetadata=function(options){return this.ajax({type:"POST",url:this.getUrl("items/metadata/reset"),data:JSON.stringify(options),contentType:"application/json"}).then(function(result){var instance=this.instance,itemIds=this.itemIds;return _events.default.trigger(instance,"message",[{MessageType:"LibraryChanged",Data:{ItemsAdded:[],ItemsRemoved:[],ItemsUpdated:itemIds,IsLocalEvent:!0}}]),result}.bind({instance:this,itemIds:options.ItemIds.split(",")}))},ApiClient.prototype.applyRemoteSearchResult=function(itemId,searchResult,options){return this.ajax({type:"POST",url:this.getUrl("Items/RemoteSearch/Apply/"+itemId,options),data:JSON.stringify(searchResult),contentType:"application/json"}).then(onItemUpdated.bind({instance:this,itemId:itemId}))},ApiClient.prototype.deleteSubtitles=function(itemId,mediaSourceId,subtitleStreamIndex){return this.ajax({type:"POST",url:this.getUrl("Videos/"+itemId+"/Subtitles/"+subtitleStreamIndex+"/Delete",{MediaSourceId:mediaSourceId})}).then(onItemUpdated.bind({instance:this,itemId:itemId}))},ApiClient.prototype.cancelSyncJobs=function(ids){var instance=this;return Promise.all(ids.map(function(id){return instance.ajax({url:instance.getUrl("Sync/Jobs/"+id+"/Delete"),type:"POST"})})).then(function(result){var instance=this.instance;return _events.default.trigger(instance,"message",[{MessageType:"SyncJobCancelled",Data:{IsLocalEvent:!0}}]),result}.bind({instance:this}))},ApiClient.prototype.cancelSyncJobItems=function(ids){var instance=this;return Promise.all(ids.map(function(id){return instance.ajax({url:instance.getUrl("Sync/JobItems/"+id+"/Delete"),type:"POST"})})).then(function(result){var instance=this.instance;return _events.default.trigger(instance,"message",[{MessageType:"SyncJobItemCancelled",Data:{IsLocalEvent:!0}}]),result}.bind({instance:this}))},ApiClient.prototype.removeEmbyConnectLink=function(userId){return this.ajax({type:"POST",url:this.getUrl("Users/"+userId+"/Connect/Link/Delete")})},ApiClient.prototype.createApiKey=function(options){return this.ajax({type:"POST",url:this.getUrl("Auth/Keys",options)}).then(function(result){var instance=this.instance;return _events.default.trigger(instance,"message",[{MessageType:"ApiKeyCreated",Data:{Ids:[],IsLocalEvent:!0}}]),result}.bind({instance:this}))},ApiClient.prototype.deleteApiKeySingle=function(accessToken){return this.ajax({type:"POST",url:this.getUrl("Auth/Keys/"+accessToken+"/Delete")})},ApiClient.prototype.deleteApiKeys=function(items){return Promise.all(items.map(mapToAccessToken).map(this.deleteApiKeySingle.bind(this))).then(function(result){var instance=this.instance;return _events.default.trigger(instance,"message",[{MessageType:"ApiKeysDeleted",Data:{Ids:[],IsLocalEvent:!0}}]),result}.bind({instance:this,items:items}))},ApiClient.prototype.deleteDevice=function(id){return this.deleteDevices([{Id:id}])},ApiClient.prototype.deleteDeviceSingle=function(id){return this.ajax({type:"POST",url:this.getUrl("Devices/Delete",{Id:id})})},ApiClient.prototype.deleteDevices=function(items){return Promise.all(items.map(mapToId).map(this.deleteDeviceSingle.bind(this))).then(function(result){var instance=this.instance;return _events.default.trigger(instance,"message",[{MessageType:"DevicesDeleted",Data:{Ids:[],IsLocalEvent:!0}}]),result}.bind({instance:this,items:items}))},ApiClient.prototype.deleteLiveTVTunerDevice=function(id){return this.ajax({type:"POST",url:this.getUrl("LiveTv/TunerHosts/Delete",{Id:id})}).then(function(result){var instance=this.instance;return _events.default.trigger(instance,"message",[{MessageType:"LiveTVTunerDevicesDeleted",Data:{Ids:[],IsLocalEvent:!0}}]),result}.bind({instance:this}))},ApiClient.prototype.deleteLiveTVGuideSource=function(id){return this.ajax({type:"POST",url:this.getUrl("LiveTv/ListingProviders/Delete",{Id:id})}).then(function(result){var instance=this.instance;return _events.default.trigger(instance,"message",[{MessageType:"LiveTVGuideSourcesDeleted",Data:{Ids:[],IsLocalEvent:!0}}]),result}.bind({instance:this}))},ApiClient.prototype.getConfigurationPages=function(options,signal){return null!=options&&options.EnableInUserMenu&&!this.isMinServerVersion("4.8.0.20")?Promise.resolve([]):this.getJSON(this.getUrl("web/configurationpages",Object.assign({PageType:"PluginConfiguration",UserId:this.getCurrentUserId()},options)),signal)},ApiClient.prototype.getAvailableRecordingOptions=function(){return this.isMinServerVersion("4.8.0.58")?this.getJSON(this.getUrl("LiveTV/AvailableRecordingOptions")):Promise.resolve({RecordingFolders:[],MovieRecordingFolders:[],SeriesRecordingFolders:[]})},ApiClient.prototype.getHomeScreenSections=function(options,signal){var instance=this;return Promise.all([loadGlobalize(),loadUserSettings()]).then(function(){return enableServerHomeSections(instance),function(instance,options){for(var finalSections=[],sections=userSettings.getHomeScreenSections(),promises=[],i=0,length=sections.length;i<length;i++)promises.push(expandSectionBlock(instance,sections[i],sections,options));return Promise.all(promises).then(function(responses){for(var _i2=0,_length2=responses.length;_i2<_length2;_i2++)finalSections=finalSections.concat(responses[_i2]);return finalSections})}(instance,options)})},ApiClient.prototype.getHomeScreenSectionItems=function(options,signal){var query=options.query,userId=this.getCurrentUserId(),section=options.section,sectionType=section.SectionType,parentItem=(section.Id,enableServerHomeSections(this),section.ParentItem);switch(sectionType){case"playlists":return this.getItems(userId,Object.assign({IncludeItemTypes:"Playlist",Recursive:!0},query),signal);case"collections":return this.getItems(userId,Object.assign({IncludeItemTypes:"BoxSet",Recursive:!0},query),signal);case"latestmoviereleases":var minPremiereDate=new Date(Date.now());return minPremiereDate.setFullYear(minPremiereDate.getFullYear()-1),this.getItems(userId,Object.assign({IncludeItemTypes:"Movie",Recursive:!0,SortBy:"ProductionYear,PremiereDate,SortName",SortOrder:"Descending",MinPremiereDate:minPremiereDate.toISOString()},query),signal);case"resume":return this.getResumableItems(userId,Object.assign({Recursive:!0,MediaTypes:"Video",IncludeNextUp:section.IncludeNextUp},query),signal);case"resumeaudio":return this.getResumableItems(userId,Object.assign({Recursive:!0,MediaTypes:"Audio"},query),signal);case"nextup":return this.getNextUpEpisodes(Object.assign({LegacyNextUp:!0,UserId:userId},query),signal);case"activerecordings":return this.getLiveTvRecordings(Object.assign({userId:userId,IsInProgress:!0},query),signal);case"userviews":return this.getUserViews(Object.assign({},query),userId,signal);case"onnow":return query=Object.assign({userId:userId,IsAiring:!0,EnableUserData:!1},query),userSettings.addLiveTvChannelSortingToQuery(query,globalize),this.getLiveTvChannels(query,signal);case"latestdownloads":return _servicelocator.appHost.supports("sync")?this.getLatestOfflineItems(Object.assign({Filters:"IsNotFolder",Limit:20},query),signal):Promise.resolve({TotalRecordCount:0,Items:[]});case"latestmedia":return this.getLatestItems(Object.assign({ParentId:null==parentItem?void 0:parentItem.Id},query),signal);default:return console.log("unexpected section type: "+console.log(sectionType)),Promise.resolve({TotalRecordCount:0,Items:[]})}},ApiClient.prototype.getParties=function(){return this.getJSON(this.getUrl("Parties"))},ApiClient.prototype.leaveParty=function(){return this.ajax({type:"POST",url:this.getUrl("Parties/Leave")})},ApiClient.prototype.joinParty=function(id){id={Id:id};return this.ajax({type:"POST",url:this.getUrl("Parties/Join",id),data:JSON.stringify(id)})},ApiClient.prototype.createParty=function(name){return this.ajax({type:"POST",url:this.getUrl("Parties"),data:JSON.stringify({Name:name})})},ApiClient.prototype.getPartyInfo=function(){return this.getJSON(this.getUrl("Parties/Info"))},ApiClient.prototype.getUrl=getUrl,ApiClient.getUrl=getUrl,ApiClient.prototype.getScaledImageUrl=function(itemId,options){return this.getImageUrl(itemId,options)},ApiClient.isLocalId=isLocalId,ApiClient.isLocalItem=function(item){if(item){item=item.Id;if("string"==typeof item&&isLocalId(item))return!0}return!1};_exports.default=ApiClient});