/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.applet;

import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.main.applet.FreeplaneApplet;

class AppletResourceController
extends ResourceController {
    private static final String APPLET_PROPERTIES = "/special_applet.properties";
    private Properties userProps;

    public AppletResourceController(FreeplaneApplet freeplaneApplet) {
        URL defaultPropsURL = this.getResource("/freeplane.properties");
        this.userProps = new Properties();
        AppletResourceController.loadProperties(this.userProps, defaultPropsURL);
        URL appletPropsURL = this.getResource(APPLET_PROPERTIES);
        AppletResourceController.loadProperties(this.userProps, appletPropsURL);
        Enumeration<?> allKeys = this.userProps.propertyNames();
        while (allKeys.hasMoreElements()) {
            String key = (String)allKeys.nextElement();
            freeplaneApplet.setPropertyByParameter(this, key);
        }
    }

    @Override
    public String getFreeplaneUserDirectory() {
        return null;
    }

    @Override
    public int getIntProperty(String key, int defaultValue) {
        try {
            return Integer.parseInt(this.getProperty(key));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    @Override
    public Properties getProperties() {
        return this.userProps;
    }

    @Override
    public String getProperty(String key) {
        return this.userProps.getProperty(key);
    }

    @Override
    public URL getResource(String name) {
        URL resourceURL = super.getResource(name);
        if (resourceURL == null || !resourceURL.getProtocol().equals("jar") && System.getProperty("freeplane.debug", null) == null) {
            return null;
        }
        return resourceURL;
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public void saveProperties() {
    }

    @Override
    public void setDefaultProperty(String key, String value) {
        this.userProps.setProperty(key, value);
    }

    @Override
    public void setProperty(String key, String value) {
        this.userProps.setProperty(key, value);
    }

    @Override
    public boolean isApplet() {
        return true;
    }

    @Override
    public Properties getSecuredProperties() {
        return this.getProperties();
    }

    @Override
    public void securePropertyForModification(String key) {
    }

    @Override
    public void securePropertyForReadingAndModification(String key) {
    }
}

