# frozen_string_literal: true

class CreateVulnerabilityDetectionTransitions < Gitlab::Database::Migration[2.3]
  disable_ddl_transaction!
  milestone '18.7'

  FINDING_INDEX_NAME = 'index_vulnerability_detection_transitions_on_finding_id'
  PROJECT_INDEX_NAME = 'index_vulnerability_detection_transitions_on_project_id'

  def up
    create_table :vulnerability_detection_transitions, if_not_exists: true do |t| # rubocop:disable Migration/EnsureFactoryForTable -- https://gitlab.com/gitlab-org/gitlab/-/issues/578566
      t.bigint :vulnerability_occurrence_id, null: false, index: { name: FINDING_INDEX_NAME }
      t.bigint :project_id, null: false, index: { name: PROJECT_INDEX_NAME }
      t.timestamps_with_timezone null: false
      t.boolean :detected, null: false, default: true
    end

    add_concurrent_foreign_key(
      :vulnerability_detection_transitions,
      :vulnerability_occurrences,
      column: :vulnerability_occurrence_id,
      on_delete: :cascade,
      if_not_exists: true
    )
  end

  def down
    drop_table :vulnerability_detection_transitions
  end
end
