---
stage: Developer Experience
group: API
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: "GitLab REST APIのコミュニティ管理クライアントライブラリの一覧。"
title: REST APIサードパーティクライアント
---

{{< details >}}

- プラン: Free
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

サードパーティのAPIクライアントライブラリをGitLabとインテグレーションできます。以下のライブラリはコミュニティメンバーによってメンテナンスされており、GitLabによって公式にサポートされているものではありません。バグや機能に関する提案は、それぞれのプロジェクトにレポートしてください。

これらのインテグレーションに関するご質問は、[GitLabコミュニティフォーラム](https://forum.gitlab.com/)をご利用ください。

管理者は、[解析するログ](../../administration/logs/log_parsing.md#print-top-api-user-agents)によって、これらのAPIクライアントの利用状況を監視できます。

## `C#` {#c}

- [`GitLabApiClient`](https://github.com/nmklotas/GitLabApiClient)
- [`NGitLab`](https://github.com/ubisoft/NGitLab)

## Go {#go}

- GitLab [`client-go`](https://gitlab.com/gitlab-org/api/client-go)

## Haskell {#haskell}

- [`gitlab-haskell`](https://hackage.haskell.org/package/gitlab-haskell)

## Java {#java}

- [`gitlab4j-api`](https://github.com/gmessner/gitlab4j-api)
- [`java-gitlab-api`](https://github.com/timols/java-gitlab-api)

## Node.js {#nodejs}

- [`gitlab-yaac`](https://www.npmjs.com/package/gitlab-yaac)
- [`backbone-gitlab`](https://github.com/oreillymedia/backbone-gitlab)
- [`@gitbeaker/rest`](https://www.npmjs.com/package/@gitbeaker/rest)

## Perl {#perl}

- [`GitLab::API::v4`](https://metacpan.org/pod/GitLab::API::v4)

## PHP {#php}

- [`php-gitlab-api`](https://github.com/GitLabPHP/Client)

## Python {#python}

- [`python-gitlab`](https://github.com/python-gitlab/python-gitlab)
  - ブログ投稿: [効率的なDevSecOpsワークフロー: 実践的な`python-gitlab` API自動化](https://about.gitlab.com/blog/2023/02/01/efficient-devsecops-workflows-hands-on-python-gitlab-api-automation/)
- [`libsaas_gitlab`](https://gitlab.com/bor-sh-infrastructure/libsaas_gitlab)

## Ruby {#ruby}

- [GitLab REST APIのRubyラッパーとCLI](https://github.com/NARKOZ/gitlab)

## Rust {#rust}

- [`gitlab`クレート](https://crates.io/crates/gitlab/)

## Swift {#swift}

- [`RxGitLabKit`](https://github.com/Qase/RxGitLabKit)
