/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.MaxScoreAccumulator;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollector;

public class TopScoreDocCollectorManager
implements CollectorManager<TopScoreDocCollector, TopDocs> {
    private final int numHits;
    private final ScoreDoc after;
    private final int totalHitsThreshold;
    private final MaxScoreAccumulator minScoreAcc;

    @Deprecated
    public TopScoreDocCollectorManager(int numHits, ScoreDoc after, int totalHitsThreshold, boolean supportsConcurrency) {
        this(numHits, after, totalHitsThreshold);
    }

    public TopScoreDocCollectorManager(int numHits, ScoreDoc after, int totalHitsThreshold) {
        if (totalHitsThreshold < 0) {
            throw new IllegalArgumentException("totalHitsThreshold must be >= 0, got " + totalHitsThreshold);
        }
        if (numHits <= 0) {
            throw new IllegalArgumentException("numHits must be > 0; please use TotalHitCountCollectorManager if you just need the total hit count");
        }
        this.numHits = numHits;
        this.after = after;
        this.totalHitsThreshold = Math.max(totalHitsThreshold, numHits);
        this.minScoreAcc = totalHitsThreshold != Integer.MAX_VALUE ? new MaxScoreAccumulator() : null;
    }

    public TopScoreDocCollectorManager(int numHits, int totalHitsThreshold) {
        this(numHits, null, totalHitsThreshold, true);
    }

    @Override
    public TopScoreDocCollector newCollector() {
        return new TopScoreDocCollector(this.numHits, this.after, this.totalHitsThreshold, this.minScoreAcc);
    }

    @Override
    public TopDocs reduce(Collection<TopScoreDocCollector> collectors) throws IOException {
        TopDocs[] topDocs = new TopDocs[collectors.size()];
        int i = 0;
        for (TopScoreDocCollector collector : collectors) {
            topDocs[i++] = collector.topDocs();
        }
        return TopDocs.merge(0, this.numHits, topDocs);
    }
}

